package com.merlin204.tde.epicfight.gameassets.skill.sect.se1.se1_1;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect.GuardType;
import com.merlin204.tde.epicfight.gameassets.skill.sect.se1.SE1Sect;
import com.merlin204.tde.epicfight.gameassets.skill.sect.se1.se1_1.SE1_1Animations;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.sounds.SoundEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;

public class SE1_1Sect extends SE1Sect {

   public SE1_1Sect(SkillBuilder builder) {
      super(builder);
   }

   public String getId() {
      return "1";
   }

   protected List getBuiltInAttacks() {
      return List.of(SE1_1Animations.ATK_1, SE1_1Animations.ATK_2, SE1_1Animations.ATK_3);
   }

   protected Map createLivingAnimations() {
      HashMap map = new HashMap();
      map.put(LivingMotions.IDLE, SE1_1Animations.IDLE);
      map.put(TDELivingMotions.TDE_WALK, SE1_1Animations.WALK);
      map.put(TDELivingMotions.TDE_SNEAK, SE1_1Animations.SNEAK);
      map.put(TDELivingMotions.TDE_KNEEL, SE1_1Animations.KNEE);
      map.put(TDELivingMotions.TDE_RUN, SE1_1Animations.RUN);
      return map;
   }

   public SoundEvent getPerfectBlockSound() {
      return (SoundEvent)EpicFightSounds.CLASH.get();
   }

   public SoundEvent getBlockSound() {
      return (SoundEvent)EpicFightSounds.CLASH.get();
   }

   public AnimationAccessor getGuardHitAnimations(int levelDifference) {
      switch(levelDifference) {
      case 0:
         return SE1_1Animations.BLOCK_3;
      case 1:
         return SE1_1Animations.BLOCK_2;
      default:
         return SE1_1Animations.BLOCK_1;
      }
   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.STRENGTH, Float.valueOf(10.0F));
      requirements.put(AbilityType.DEXTERITY, Float.valueOf(4.0F));
      requirements.put(AbilityType.STAMINA, Float.valueOf(6.0F));
      requirements.put(AbilityType.VITALITY, Float.valueOf(5.0F));
      return requirements;
   }

   public int getDefendLevel() {
      return 5;
   }

   public GuardType getGuardType() {
      return GuardType.MAIN;
   }

   public AnimationAccessor getGuardBrokenAnimations() {
      return SE1_1Animations.BLOCK_BROKEN;
   }

   public AnimationAccessor getPerfectGuardAnimations() {
      return SE1_1Animations.BLOCK_PERFECT;
   }

   public AnimationAccessor getDashAtkAnimations() {
      return SE1_1Animations.RUN_ATK;
   }

   public AnimationAccessor getGuardAnimation() {
      return SE1_1Animations.BLOCK;
   }

   public AnimationAccessor getChargingAnimation() {
      return SE1_1Animations.CHARGE;
   }

   public AnimationAccessor getChargingAttackAnimation() {
      return SE1_1Animations.CHARGE_ATK;
   }

   public AnimationAccessor getFullChargingAttackAnimation() {
      return SE1_1Animations.FULL_CHARGE_ATK;
   }

   protected AnimationAccessor getHoldAnimation() {
      return SE1_1Animations.HOLD;
   }

   public float getMaxWeight() {
      return 20.0F;
   }

   public Set getMainAllowed() {
      return Set.of(TDEWeaponType.GREATSWORD);
   }

   public Set getOffAllowed() {
      return Set.of(TDEWeaponType.EMPTY);
   }
}
