package com.merlin204.tde.epicfight.gameassets.skill.sect.basic;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.client.CameraShake;
import com.merlin204.tde.epicfight.animations.TDEMovementAnimation;
import com.merlin204.tde.epicfight.animations.TDEAttackAnimation.TDEPhase;
import com.merlin204.tde.epicfight.animations.player.TDEPlayerAttackAnimation;
import com.merlin204.tde.epicfight.gameassets.skill.charge.BasicChargedAttack;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.util.TDEEventUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.AnimationManager.AnimationBuilder;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationParameters;
import yesman.epicfight.api.animation.property.AnimationEvent.InPeriodEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.InTimeEvent;
import yesman.epicfight.api.animation.property.AnimationEvent.Side;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.AttackPhaseProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.gameasset.Armatures.ArmatureAccessor;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class BasicSectAnimations {

   public static AnimationAccessor FIST_IDLE;
   public static AnimationAccessor FIST_HOLD;
   public static AnimationAccessor FIST_WALK;
   public static AnimationAccessor FIST_CHARGE;
   public static AnimationAccessor FIST_BLOCK;
   public static AnimationAccessor FIST_1;
   public static AnimationAccessor FIST_2;
   public static AnimationAccessor FIST_3;
   public static AnimationAccessor FIST_CHARGE_ATK;
   public static AnimationAccessor FIST_CHARGE_ATK_FULL;


   public static void buildBasicSectAnimations(AnimationBuilder builder) {
      ArmatureAccessor biped = Armatures.BIPED;
      FIST_IDLE = builder.nextAccessor("biped/sect/basicsect/fist_idle", biped);
      FIST_HOLD = builder.nextAccessor("biped/sect/basicsect/fist_hold", biped);
      FIST_WALK = builder.nextAccessor("biped/sect/basicsect/fist_walk", biped);
      FIST_BLOCK = builder.nextAccessor("biped/sect/basicsect/fist_block", biped);
      FIST_CHARGE = builder.nextAccessor("biped/sect/basicsect/fist_charge", biped);
      FIST_1 = builder.nextAccessor("biped/sect/basicsect/fist_1", biped);
      FIST_2 = builder.nextAccessor("biped/sect/basicsect/fist_2", biped);
      FIST_3 = builder.nextAccessor("biped/sect/basicsect/fist_3", biped);
      FIST_CHARGE_ATK = builder.nextAccessor("biped/sect/basicsect/fist_charge_atk", biped);
      FIST_CHARGE_ATK_FULL = builder.nextAccessor("biped/sect/basicsect/fist_charge_atk_full", biped);
   }

   // $FF: synthetic method
   private static TDEPlayerAttackAnimation lambda$buildBasicSectAnimations$13(ArmatureAccessor param0, AnimationAccessor param1) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static void lambda$buildBasicSectAnimations$12(LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      TDEAnimationUtils.dealRectangularDamage((ServerLevel)entity.m_9236_(), (LivingEntity)entity, TDEAnimationUtils.getTotalAttackDamage(entityPatch) * 2.0F, 2.5F, 5.0F, 2.0F);
   }

   // $FF: synthetic method
   private static void lambda$buildBasicSectAnimations$11(ArmatureAccessor biped, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation("photon:fist_wind_2"));
      JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, ((HumanoidArmature)biped.get()).toolR, 20, false);
      effect.setRotation(0.0D, (double)(-entity.m_146908_()), 0.0D);
      effect.start();
      CameraShake.shake(3, 2.0F, 1.0F, entity.m_20182_(), 5.0F);
   }

   // $FF: synthetic method
   private static TDEPlayerAttackAnimation lambda$buildBasicSectAnimations$10(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (TDEPlayerAttackAnimation)(new TDEPlayerAttackAnimation(0.1F, accessor, biped, new TDEPhase[]{TDEAnimationUtils.createSimplePhase(5, 10, 25, InteractionHand.MAIN_HAND, ((HumanoidArmature)biped.get()).toolR, (Collider)null)})).addProperty(AttackPhaseProperty.SWING_SOUND, (SoundEvent)EpicFightSounds.WHOOSH.get()).addEvents(new AnimationEvent[]{InTimeEvent.create(0.13333334F, biped, Side.CLIENT)});
   }

   // $FF: synthetic method
   private static void lambda$buildBasicSectAnimations$9(ArmatureAccessor biped, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      Entity entity = entityPatch.getOriginal();
      FX fx = FXHelper.getFX(new ResourceLocation("photon:fist_wind_1"));
      JointEffect effect = new JointEffect(fx, entity.m_9236_(), entity, ((HumanoidArmature)biped.get()).toolR, 20, false);
      effect.setRotation(0.0D, (double)(-entity.m_146908_()), 0.0D);
      effect.start();
      CameraShake.shake(2, 1.0F, 1.0F, entity.m_20182_(), 2.0F);
   }

   // $FF: synthetic method
   private static TDEPlayerAttackAnimation lambda$buildBasicSectAnimations$8(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (TDEPlayerAttackAnimation)(new TDEPlayerAttackAnimation(0.1F, accessor, biped, new TDEPhase[]{TDEAnimationUtils.createSimplePhase(20, 25, 45, InteractionHand.MAIN_HAND, ((HumanoidArmature)biped.get()).toolR, (Collider)null)})).addProperty(AttackPhaseProperty.SWING_SOUND, (SoundEvent)EpicFightSounds.WHOOSH.get()).addEvents(new AnimationEvent[]{TDEEventUtils.costEnergyEvent(21, 15.0F), TDEEventUtils.creatSimpleSyncRotFxEvent(25, "photon:fist_wind_1", ((HumanoidArmature)biped.get()).toolR, 20, false)});
   }

   // $FF: synthetic method
   private static TDEPlayerAttackAnimation lambda$buildBasicSectAnimations$7(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (TDEPlayerAttackAnimation)(new TDEPlayerAttackAnimation(0.1F, accessor, biped, new TDEPhase[]{TDEAnimationUtils.createSimplePhase(15, 21, 35, InteractionHand.OFF_HAND, ((HumanoidArmature)biped.get()).toolL, (Collider)null)})).addProperty(AttackPhaseProperty.SWING_SOUND, (SoundEvent)EpicFightSounds.WHOOSH.get()).addEvents(new AnimationEvent[]{TDEEventUtils.costEnergyEvent(17, 10.0F), TDEEventUtils.creatSimpleSyncRotFxEvent(21, "photon:fist_wind_1", ((HumanoidArmature)biped.get()).toolL, 20, false)});
   }

   // $FF: synthetic method
   private static TDEPlayerAttackAnimation lambda$buildBasicSectAnimations$6(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (TDEPlayerAttackAnimation)(new TDEPlayerAttackAnimation(0.1F, accessor, biped, new TDEPhase[]{TDEAnimationUtils.createSimplePhase(20, 25, 35, InteractionHand.MAIN_HAND, ((HumanoidArmature)biped.get()).toolR, (Collider)null)})).addProperty(AttackPhaseProperty.SWING_SOUND, (SoundEvent)EpicFightSounds.WHOOSH.get()).addEvents(new AnimationEvent[]{TDEEventUtils.costEnergyEvent(22, 10.0F), TDEEventUtils.creatSimpleSyncRotFxEvent(25, "photon:fist_wind_1", ((HumanoidArmature)biped.get()).toolR, 20, false)});
   }

   // $FF: synthetic method
   private static StaticAnimation lambda$buildBasicSectAnimations$5(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (new StaticAnimation(0.5F, true, accessor, biped)).addProperty(ActionAnimationProperty.STOP_MOVEMENT, Boolean.valueOf(true)).newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.MOVEMENT_LOCKED, Boolean.valueOf(true)).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).addEvents(new AnimationEvent[]{InPeriodEvent.create(0.0F, Float.MAX_VALUE, biped, Side.CLIENT)});
   }

   // $FF: synthetic method
   private static void lambda$buildBasicSectAnimations$4(ArmatureAccessor biped, LivingEntityPatch entityPatch, AssetAccessor self, AnimationParameters params) {
      if(entityPatch instanceof PlayerPatch) {
         PlayerPatch playerPatch = (PlayerPatch)entityPatch;
         if(playerPatch.getSkill(TDESkillSlots.CHARGED_ATTACK) != null) {
            SkillDataManager manager = playerPatch.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager();
            SkillContainer charge = playerPatch.getSkill(TDESkillSlots.CHARGED_ATTACK);
            Skill entity = charge.getSkill();
            if(entity instanceof BasicChargedAttack) {
               BasicChargedAttack basicChargedAttack = (BasicChargedAttack)entity;
               if(manager.hasData((SkillDataKey)TDEDatakeys.CHARGING_TIME.get())) {
                  FX fx;
                  Entity entity1;
                  if(((Integer)manager.getDataValue((SkillDataKey)TDEDatakeys.CHARGING_TIME.get())).intValue() == basicChargedAttack.MAX_CHARGING_TICKS) {
                     entity1 = entityPatch.getOriginal();
                     fx = FXHelper.getFX(new ResourceLocation("photon:charge_1_end"));
                     (new JointEffect(fx, entity1.m_9236_(), entity1, ((HumanoidArmature)biped.get()).toolR, 3, false)).start();
                  } else {
                     entity1 = entityPatch.getOriginal();
                     fx = FXHelper.getFX(new ResourceLocation("photon:charge_1"));
                     (new JointEffect(fx, entity1.m_9236_(), entity1, ((HumanoidArmature)biped.get()).toolR, 3, false)).start();
                  }
               }
            }
         }
      }

   }

   // $FF: synthetic method
   private static StaticAnimation lambda$buildBasicSectAnimations$3(ArmatureAccessor biped, AnimationAccessor accessor) {
      return (new StaticAnimation(0.15F, true, accessor, biped)).newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.MOVEMENT_LOCKED, Boolean.valueOf(true));
   }

   // $FF: synthetic method
   private static TDEMovementAnimation lambda$buildBasicSectAnimations$2(ArmatureAccessor biped, AnimationAccessor accessor) {
      return new TDEMovementAnimation(0.15F, true, accessor, biped, 1.2F);
   }

   // $FF: synthetic method
   private static StaticAnimation lambda$buildBasicSectAnimations$1(ArmatureAccessor biped, AnimationAccessor accessor) {
      return new StaticAnimation(0.15F, true, accessor, biped);
   }

   // $FF: synthetic method
   private static StaticAnimation lambda$buildBasicSectAnimations$0(ArmatureAccessor biped, AnimationAccessor accessor) {
      return new StaticAnimation(0.15F, true, accessor, biped);
   }
}
