package com.merlin204.tde.epicfight.gameassets.skill.sect.basic;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSectAnimations;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.skill.Skill.Resource;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.AnimationEndEvent;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;
import yesman.epicfight.world.entity.eventlistener.ComboCounterHandleEvent.Causal;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

public class BasicSect extends BasicAttack implements SkillInfo {

   protected final UUID EVENT_UUID = UUID.randomUUID();


   public String getGroup() {
      return "basic";
   }

   public String getId() {
      return "";
   }

   public String getMoreText() {
      return Component.m_237115_(String.format("%s.%s.%s", new Object[]{"skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()})).getString();
   }

   public void setMoreInfo(WidgetGroup widgetGroup) {
      super.setMoreInfo(widgetGroup);
      ImageWidget defendLevelInfo = new ImageWidget();
      TextTexture defendLevelInfoText = (new TextTexture()).setType(TextType.LEFT);
      defendLevelInfoText.setWidth(130);
      Component.m_237115_("gui.tde.campfire.skill.defend_level").getString().updateText(String.valueOf(this.getDefendLevel()));
      defendLevelInfo.setBackground(new IGuiTexture[]{defendLevelInfoText});
      defendLevelInfo.setSize(130, 20);
      defendLevelInfo.setSelfPosition(5, 5);
      widgetGroup.addWidget(defendLevelInfo);
      ImageWidget moreInfo = new ImageWidget();
      TextTexture moreInfoText = (new TextTexture()).setType(TextType.LEFT);
      moreInfoText.setWidth(130);
      moreInfoText.updateText(this.getMoreText());
      moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
      moreInfo.setSize(130, 100);
      moreInfo.setSelfPosition(5, 25);
      widgetGroup.addWidget(moreInfo);
   }

   public Component getIntroduce() {
      return Component.m_237115_(this.getGroup());
   }

   public String getIcon() {
      return "tde:textures/skill/sect/b.png";
   }

   public BasicSect(SkillBuilder builder) {
      super(builder);
   }

   protected List getBuiltInAttacks() {
      return List.of(BasicSectAnimations.FIST_1, BasicSectAnimations.FIST_2, BasicSectAnimations.FIST_3);
   }

   protected Map createLivingAnimations() {
      HashMap map = new HashMap();
      map.put(LivingMotions.IDLE, BasicSectAnimations.FIST_IDLE);
      map.put(LivingMotions.JUMP, this.getHoldAnimation());
      map.put(TDELivingMotions.TDE_WALK, BasicSectAnimations.FIST_WALK);
      map.put(TDELivingMotions.TDE_SNEAK, this.getHoldAnimation());
      map.put(TDELivingMotions.TDE_KNEEL, this.getHoldAnimation());
      return map;
   }

   public int getDefendLevel() {
      return 1;
   }

   public AnimationAccessor getGuardBrokenAnimations() {
      return null;
   }

   public AnimationAccessor getGuardHitAnimations(int levelDifference) {
      return null;
   }

   public AnimationAccessor getPerfectGuardAnimations() {
      return null;
   }

   public AnimationAccessor getDashAtkAnimations() {
      return null;
   }

   public SoundEvent getPerfectBlockSound() {
      return (SoundEvent)EpicFightSounds.BLUNT_HIT_HARD.get();
   }

   public SoundEvent getBlockSound() {
      return (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
   }

   public AnimationAccessor getGuardAnimation() {
      return BasicSectAnimations.FIST_BLOCK;
   }

   public AnimationAccessor getChargingAnimation() {
      return BasicSectAnimations.FIST_CHARGE;
   }

   public AnimationAccessor getChargingAttackAnimation() {
      return BasicSectAnimations.FIST_CHARGE_ATK;
   }

   public AnimationAccessor getFullChargingAttackAnimation() {
      return BasicSectAnimations.FIST_CHARGE_ATK_FULL;
   }

   protected AnimationAccessor getHoldAnimation() {
      return BasicSectAnimations.FIST_HOLD;
   }

   public float getMaxWeight() {
      return 10.0F;
   }

   public Set getMainAllowed() {
      return Set.of(TDEWeaponType.EMPTY);
   }

   public Set getOffAllowed() {
      return Set.of(TDEWeaponType.EMPTY);
   }

   public BasicSect.GuardType getGuardType() {
      return BasicSect.GuardType.ALL;
   }

   public Map getLivingAnimations() {
      return this.createLivingAnimations();
   }

   public boolean checkAllowed(Player player) {
      return this.validatePlayer(player);
   }

   public void onInitiate(SkillContainer container) {
      this.updatePlayerState(container);
      this.registerEventListeners(container);
   }

   public void executeOnClient(SkillContainer container, FriendlyByteBuf args) {
      super.executeOnClient(container, args);
   }

   public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
      ServerPlayerPatch executor = skillContainer.getServerExecutor();
      if(executor instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch player = (TDEServerPlayerPatch)executor;
         if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)player.getOriginal()) <= 5.0F) {
            return;
         }

         if(!this.checkAllowed((Player)executor.getOriginal())) {
            if(!this.validatePlayerWeapons((Player)executor.getOriginal())) {
               Minecraft.m_91087_().f_91065_.m_93063_(Component.m_237115_("gui.tde.sect.warn_1"), false);
            } else if(!this.validatePlayerAbilities((Player)executor.getOriginal())) {
               Minecraft.m_91087_().f_91065_.m_93063_(Component.m_237115_("gui.tde.sect.warn_2"), false);
            }

            return;
         }
      }

      this.handleSkillConsume(executor);
      if(!this.shouldCancelExecution(executor)) {
         ServerPlayer var14 = (ServerPlayer)executor.getOriginal();
         SkillDataManager dataManager = skillContainer.getDataManager();
         int comboCounter = ((Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get())).intValue();
         AnimationAccessor selectedAnimation = null;
         List attacks = this.getBuiltInAttacks();
         int comboSize = attacks.size();
         boolean isFirstAttack = comboCounter == 0;
         boolean dashAttack = var14.m_20142_();
         if(isFirstAttack && dashAttack && this.getDashAtkAnimations() != null) {
            selectedAnimation = this.getDashAtkAnimations();
            comboCounter = 1;
         } else if(comboSize >= 2) {
            if(comboCounter >= comboSize) {
               int loopSize = comboSize - 1;
               int loopIndex = (comboCounter - comboSize) % loopSize;
               selectedAnimation = (AnimationAccessor)attacks.get(loopIndex + 1);
            } else {
               selectedAnimation = (AnimationAccessor)attacks.get(comboCounter);
            }

            ++comboCounter;
         } else if(comboSize > 0) {
            selectedAnimation = (AnimationAccessor)attacks.get(comboCounter % comboSize);
            ++comboCounter;
         }

         this.updateComboCounter(executor, skillContainer, selectedAnimation, comboCounter);
         this.playAnimation(executor, dataManager, selectedAnimation);
      }
   }

   public void onRemoved(SkillContainer container) {
      this.updatePlayerState(container);
      container.getExecutor().getEventListener().removeListener(EventType.ACTION_EVENT_SERVER, this.EVENT_UUID);
   }

   public boolean isExecutableState(PlayerPatch executor) {
      EntityState playerState = executor.getEntityState();
      Player player = (Player)executor.getOriginal();
      return !player.m_5833_() && !executor.isInAir() && playerState.canBasicAttack();
   }

   public void updateContainer(SkillContainer container) {
      PlayerPatch var3 = container.getExecutor();
      if(var3 instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)var3;
         if(serverPlayerPatch.isCharging() || serverPlayerPatch.isGuard()) {
            setComboCounterWithEvent(Causal.TIME_EXPIRED, container.getServerExecutor(), container, (AnimationAccessor)null, 0);
         }
      }

      if(!container.getExecutor().isLogicalClient() && container.getExecutor().getTickSinceLastAction() > 16 && ((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get())).intValue() > 0) {
         setComboCounterWithEvent(Causal.TIME_EXPIRED, container.getServerExecutor(), container, (AnimationAccessor)null, 0);
      }

   }

   private void updatePlayerState(SkillContainer container) {
      PlayerPatch executor = container.getExecutor();
      if(executor instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)executor;
         TDEServerPlayerPatch executor1 = (TDEServerPlayerPatch)container.getExecutor();
         executor1.modifyLivingMotionByCurrentItem(false);
      }

   }

   private void registerEventListeners(SkillContainer container) {
      PlayerEventListener listener = container.getExecutor().getEventListener();
      EventType.ACTION_EVENT_SERVER.addEventListener(this.EVENT_UUID, this, container);
      listener.addEventListener(EventType.ANIMATION_END_EVENT, this.EVENT_UUID, container);
   }

   private void handleSkillConsume(ServerPlayerPatch executor) {
      SkillConsumeEvent event = new SkillConsumeEvent(executor, this, this.resource);
      executor.getEventListener().triggerEvents(EventType.SKILL_CONSUME_EVENT, event);
      if(!event.isCanceled()) {
         event.getResourceType().consumer.consume(executor.getSkill(this), executor, event.getAmount());
      }

   }

   private boolean shouldCancelExecution(ServerPlayerPatch executor) {
      return executor.getEventListener().triggerEvents(EventType.BASIC_ATTACK_EVENT, new BasicAttackEvent(executor));
   }

   private void updateComboCounter(ServerPlayerPatch executor, SkillContainer container, AnimationAccessor animation, int newValue) {
      setComboCounterWithEvent(Causal.ANOTHER_ACTION_ANIMATION, executor, container, animation, newValue);
   }

   private void playAnimation(ServerPlayerPatch executor, SkillDataManager dataManager, AnimationAccessor animation) {
      if(animation != null) {
         executor.playAnimationSynchronized(animation, 0.0F);
         dataManager.setData((SkillDataKey)SkillDataKeys.BASIC_ATTACK_ACTIVATE.get(), Boolean.valueOf(true));
      }

      executor.updateEntityState();
   }

   public static void setComboCounterWithEvent(Causal reason, ServerPlayerPatch playerpatch, SkillContainer container, AnimationAccessor causalAnimation, int value) {
      int prevValue = ((Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get())).intValue();
      ComboCounterHandleEvent comboResetEvent = new ComboCounterHandleEvent(reason, playerpatch, causalAnimation, prevValue, value);
      container.getExecutor().getEventListener().triggerEvents(EventType.COMBO_COUNTER_HANDLE_EVENT, comboResetEvent);
      container.getDataManager().setData((SkillDataKey)SkillDataKeys.COMBO_COUNTER.get(), Integer.valueOf(comboResetEvent.getNextValue()));
   }

   public static SkillBuilder createBuiltInBasicAttackBuilder() {
      return (new SkillBuilder()).setCategory(TDESkillCategories.SECT).setActivateType(ActivateType.ONE_SHOT).setResource(Resource.NONE);
   }

   // $FF: synthetic method
   private static void lambda$registerEventListeners$1(SkillContainer container, AnimationEndEvent event) {
      container.getDataManager().setData((SkillDataKey)SkillDataKeys.BASIC_ATTACK_ACTIVATE.get(), Boolean.valueOf(false));
   }

   // $FF: synthetic method
   private void lambda$registerEventListeners$0(SkillContainer container, ActionEvent event) {
      if(((Boolean)((StaticAnimation)event.getAnimation().get()).getProperty(ActionAnimationProperty.RESET_PLAYER_COMBO_COUNTER).orElse(Boolean.valueOf(true))).booleanValue()) {
         HashSet attackSet = new HashSet(this.getBuiltInAttacks());
         AnimationAccessor dashAtk = this.getDashAtkAnimations();
         if(dashAtk != null) {
            attackSet.add(dashAtk);
         }

         CapabilityItem capability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
         if(!attackSet.contains(event.getAnimation()) && capability.shouldCancelCombo(event.getPlayerPatch())) {
            setComboCounterWithEvent(Causal.ANOTHER_ACTION_ANIMATION, (ServerPlayerPatch)event.getPlayerPatch(), container, event.getAnimation(), 0);
         }
      }

   }

   public static enum GuardType {

      MAIN,
      OFF,
      ALL;
      // $FF: synthetic field
      private static final BasicSect.GuardType[] $VALUES = $values();


      // $FF: synthetic method
      private static BasicSect.GuardType[] $values() {
         return new BasicSect.GuardType[]{MAIN, OFF, ALL};
      }

   }
}
