package com.merlin204.tde.epicfight.gameassets.skill.guard;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.CameraShake;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.photon.PosEffect;
import com.merlin204.tde.util.TDEAbilityUtils;
import com.merlin204.tde.world.TDEDamageSource;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.utils.AttackResult.ResultType;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.skill.Skill.Resource;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.HurtEvent.Pre;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

public class BasicGuard extends Skill implements SkillInfo {

   protected static final UUID EVENT_UUID = UUID.fromString("b422f7a0-f378-11eb-9a03-0242ac130103");


   private int getPerfectTick() {
      return 5;
   }

   public String getMoreText() {
      return Component.m_237115_(String.format("%s.%s.%s", new Object[]{"skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()})).getString();
   }

   public void setMoreInfo(WidgetGroup widgetGroup) {
      super.setMoreInfo(widgetGroup);
      ImageWidget moreInfo = new ImageWidget();
      TextTexture moreInfoText = (new TextTexture()).setType(TextType.LEFT);
      moreInfoText.setWidth(130);
      moreInfoText.updateText(this.getMoreText());
      moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
      moreInfo.setSize(130, 100);
      moreInfo.setSelfPosition(5, 5);
      widgetGroup.addWidget(moreInfo);
   }

   public String getIcon() {
      return "tde:textures/skill/guard/basic.png";
   }

   public BasicGuard(SkillBuilder builder) {
      super(builder);
   }

   public static BasicGuard.Builder createBasicGuardBuilder() {
      return (new BasicGuard.Builder()).setCategory(TDESkillCategories.TDEGUARD).setResource(Resource.NONE);
   }

   public void updateContainer(SkillContainer container) {
      super.updateContainer(container);
      PlayerPatch basicSect = container.getExecutor();
      if(basicSect instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch basicAttack = (TDEServerPlayerPatch)basicSect;
         ServerPlayer basicSect1 = (ServerPlayer)basicAttack.getOriginal();
         int isKeyDown = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get())).intValue();
         if(isKeyDown > 0) {
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get(), Integer.valueOf(isKeyDown - 1), basicSect1);
         }
      }

      if(container.getExecutor().isLogicalClient()) {
         LocalPlayer basicAttack1 = (LocalPlayer)container.getExecutor().getOriginal();
         if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, basicAttack1) <= 0.0F) {
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), Boolean.valueOf(false), basicAttack1);
            return;
         }
      }

      if(container.getExecutor().getEntityState().canUseSkill()) {
         SkillContainer basicAttack2 = container.getExecutor().getSkill(TDESkillSlots.SECT);
         Skill isKeyDown1 = basicAttack2.getSkill();
         if(isKeyDown1 instanceof BasicSect) {
            BasicSect basicSect2 = (BasicSect)isKeyDown1;
            if(!basicSect2.checkAllowed((Player)container.getExecutor().getOriginal())) {
               return;
            }

            boolean isKeyDown2 = TDEKeyMappings.GUARD.m_90857_();
            boolean wasGuard = ((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue();
            if(!wasGuard) {
               if(container.getExecutor().isLogicalClient()) {
                  container.getExecutor().getAnimator().stopPlaying(basicSect2.getGuardAnimation());
               } else {
                  container.getExecutor().stopPlaying(basicSect2.getGuardAnimation());
               }
            }

            if(container.getExecutor().isLogicalClient()) {
               LocalPlayer player = (LocalPlayer)container.getExecutor().getOriginal();
               if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, player) <= 0.0F) {
                  container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), Boolean.valueOf(false), player);
                  return;
               }

               int guardTime = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get())).intValue();
               if(isKeyDown2) {
                  Minecraft mc = Minecraft.m_91087_();
                  ControllEngine.setKeyBind(mc.f_91066_.f_92091_, false);
                  ControllEngine.setKeyBind(mc.f_91066_.f_92085_, false);
                  ControllEngine.setKeyBind(mc.f_91066_.f_92087_, false);
                  ControllEngine.setKeyBind(mc.f_91066_.f_92086_, false);
                  ControllEngine.setKeyBind(mc.f_91066_.f_92088_, false);
                  ControllEngine.setKeyBind(mc.f_91066_.f_92089_, false);
                  if(!wasGuard) {
                     player.m_20334_(0.0D, 0.0D, 0.0D);
                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), Boolean.valueOf(true), player);
                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), Integer.valueOf(0), player);
                  } else {
                     player.m_20334_(0.0D, 0.0D, 0.0D);
                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), Integer.valueOf(guardTime + 1), player);
                     container.getExecutor().playAnimationSynchronized(basicSect2.getGuardAnimation(), 0.0F);
                  }
               } else if(wasGuard) {
                  container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), Boolean.valueOf(false), player);
                  container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), Integer.valueOf(0), player);
               }
            }
         }

      }
   }

   public void onInitiate(SkillContainer container) {
      container.getExecutor().getEventListener().addEventListener(EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, container);
      container.getExecutor().getEventListener();
      EventType.HURT_EVENT_PRE.addEventListener(EVENT_UUID, this, container, 0);
   }

   public void guard(SkillContainer container, Pre event, boolean advanced, SoundEvent perfact, SoundEvent normal) {
      DamageSource damageSource = (DamageSource)event.getDamageSource();
      SkillContainer basicAttack = container.getExecutor().getSkill(TDESkillSlots.SECT);
      Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
      boolean perfect = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get())).intValue() <= this.getPerfectTick();
      TDEServerPlayerPatch serverPlayerPatch;
      PlayerPatch basicSect;
      if(perfect) {
         basicSect = event.getPlayerPatch();
         if(basicSect instanceof TDEServerPlayerPatch) {
            serverPlayerPatch = (TDEServerPlayerPatch)basicSect;
            serverPlayerPatch.stopEnergyRecoveryTime = 0;
         }

         if(this.isBlockableSource(damageSource, advanced)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound(perfact, 2.0F, 2.1F);
            ServerPlayer serverPlayerPatch1 = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get(), Integer.valueOf(10), serverPlayerPatch1);
            this.spark(event.getPlayerPatch(), "photon:spark_perfect", 5);
            this.dealEvent(event.getPlayerPatch(), event);
         }
      } else if(this.isBlockableSource(damageSource, advanced)) {
         this.dealEvent(event.getPlayerPatch(), event);
         this.spark(event.getPlayerPatch(), "photon:spark", 5);
         basicSect = event.getPlayerPatch();
         if(basicSect instanceof TDEServerPlayerPatch) {
            serverPlayerPatch = (TDEServerPlayerPatch)basicSect;
            serverPlayerPatch.stopEnergyRecoveryTime = 90;
            serverPlayerPatch.hurtEnergyDamage(event.getAmount() * 2.0F);
            if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, (Player)serverPlayerPatch.getOriginal()) <= 0.0F) {
               container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_GUARD.get(), Boolean.valueOf(false), (ServerPlayer)serverPlayerPatch.getOriginal());
               container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.GUARD_TIME.get(), Integer.valueOf(0), (ServerPlayer)serverPlayerPatch.getOriginal());
               Skill var12 = basicAttack.getSkill();
               if(var12 instanceof BasicSect) {
                  BasicSect basicSect1 = (BasicSect)var12;
                  if(basicSect1.getGuardBrokenAnimations() != null) {
                     container.getExecutor().playAnimationSynchronized(basicSect1.getGuardBrokenAnimations(), 0.0F);
                  }
               }
            } else {
               ((ServerPlayerPatch)event.getPlayerPatch()).playSound(normal, -0.05F, 0.1F);
            }
         } else {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound(normal, -0.05F, 0.1F);
         }
      }

   }

   public void dealEvent(PlayerPatch playerpatch, Pre event) {
      event.setCanceled(true);
      event.setResult(ResultType.BLOCKED);
      EpicFightCapabilities.getUnparameterizedEntityPatch(((DamageSource)event.getDamageSource()).m_7639_(), LivingEntityPatch.class).ifPresent(playerpatch);
      EpicFightCapabilities.getParameterizedEntityPatch(((DamageSource)event.getDamageSource()).m_7640_(), LivingEntity.class, LivingEntityPatch.class);
      event.ifPresent(playerpatch);
   }

   protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
      return true;
   }

   public void onRemoved(SkillContainer container) {
      container.getExecutor().getEventListener().removeListener(EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
      container.getExecutor().getEventListener().removeListener(EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
   }

   private void spark(LivingEntityPatch entityPatch, String Fx, int maxAge) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      Vec3 pos = entity.m_146892_();
      float yaw = entityPatch.getYRot();
      double radians = Math.toRadians((double)yaw);
      double cosYaw = Math.cos(radians);
      double sinYaw = Math.sin(radians);
      Vec3 viewDir = (new Vec3(-sinYaw, 0.0D, cosYaw)).m_82490_(1.0D);
      Vec3 target = pos.m_82520_(viewDir.f_82479_, viewDir.f_82480_ - 0.699999988079071D, viewDir.f_82481_);
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      (new PosEffect(fx, entity.m_9236_(), entity, target, maxAge, false)).start();
   }

   // $FF: synthetic method
   private static void lambda$dealEvent$3(Pre event, PlayerPatch playerpatch, LivingEntityPatch entitypatch) {
      entitypatch.onAttackBlocked((DamageSource)event.getDamageSource(), playerpatch);
   }

   // $FF: synthetic method
   private static void lambda$dealEvent$2(PlayerPatch playerpatch, LivingEntityPatch attackerpatch) {
      attackerpatch.setLastAttackEntity(playerpatch.getOriginal());
   }

   // $FF: synthetic method
   private void lambda$onInitiate$1(SkillContainer container, Pre event) {
      if(((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue()) {
         DamageSource damageSource = (DamageSource)event.getDamageSource();
         SkillContainer basicAttack = container.getExecutor().getSkill(TDESkillSlots.SECT);
         Skill epicfightDamageSource = basicAttack.getSkill();
         if(epicfightDamageSource instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)epicfightDamageSource;
            Object tdeDamageSource = event.getDamageSource();
            if(tdeDamageSource instanceof EpicFightDamageSource) {
               EpicFightDamageSource epicfightDamageSource1 = (EpicFightDamageSource)tdeDamageSource;
               if(epicfightDamageSource1 instanceof TDEDamageSource) {
                  TDEDamageSource tdeDamageSource1 = (TDEDamageSource)epicfightDamageSource1;
                  boolean perfect = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.GUARD_TIME.get())).intValue() <= this.getPerfectTick();
                  PlayerPatch defendLevel = container.getExecutor();
                  if(!(defendLevel instanceof TDEServerPlayerPatch)) {
                     return;
                  }

                  TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)defendLevel;
                  int defendLevel1 = tdeServerPlayerPatch.getDefendLevel();
                  if(tdeDamageSource1.getImpactLevel() > defendLevel1 && !perfect) {
                     CameraShake.shake(40, (float)(tdeDamageSource1.getImpactLevel() * 5), 0.6F, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0F);
                     tdeServerPlayerPatch.hurtEnergyDamage(event.getAmount() * 1.5F);
                  } else {
                     CameraShake.shake(30, (float)(tdeDamageSource1.getImpactLevel() * 3), 0.6F, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0F);
                     AnimationAccessor hitAnimation = basicSect.getGuardHitAnimations(defendLevel1 - tdeDamageSource1.getImpactLevel());
                     if(perfect) {
                        hitAnimation = basicSect.getPerfectGuardAnimations();
                     }

                     if(hitAnimation != null) {
                        container.getExecutor().playAnimationSynchronized(hitAnimation, 0.0F);
                     }
                  }
               } else {
                  CameraShake.shake(30, 10.0F, 0.6F, ((Player)container.getExecutor().getOriginal()).m_20182_(), 3.0F);
               }

               if(epicfightDamageSource1.m_269533_(EpicFightDamageType.GUARD_PUNCTURE)) {
                  return;
               }
            }

            this.guard(container, event, false, basicSect.getPerfectBlockSound(), basicSect.getBlockSound());
         }
      }

   }

   // $FF: synthetic method
   private static void lambda$onInitiate$0(SkillContainer container, MovementInputEvent event) {
      if(((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue()) {
         LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
         clientPlayer.m_6858_(false);
         clientPlayer.m_20334_(0.0D, 0.0D, 0.0D);
         Minecraft mc = Minecraft.m_91087_();
         ControllEngine.setKeyBind(mc.f_91066_.f_92091_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92085_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92087_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92086_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92088_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92089_, false);
      }

   }


   public static class Builder extends SkillBuilder {

      public BasicGuard.Builder setCategory(SkillCategory category) {
         this.category = category;
         return this;
      }

      public BasicGuard.Builder setActivateType(ActivateType activateType) {
         this.activateType = activateType;
         return this;
      }

      public BasicGuard.Builder setResource(Resource resource) {
         this.resource = resource;
         return this;
      }

      public BasicGuard.Builder setCreativeTab(CreativeModeTab tab) {
         this.tab = tab;
         return this;
      }
   }
}
