package com.merlin204.tde.epicfight.gameassets.skill.dodge;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.dodge.DodgeAnimations;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.client.CPExecuteSkill;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.DodgeSuccessEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

public class BasicDodge extends Skill implements SkillInfo {

   protected final AnimationAccessor[] animations;
   private static final UUID EVENT_UUID = UUID.fromString("23bd8c76-fe77-11ed-be56-0242ac164514");


   public void setMoreInfo(WidgetGroup widgetGroup) {
      super.setMoreInfo(widgetGroup);
      ImageWidget moreInfo = new ImageWidget();
      TextTexture moreInfoText = (new TextTexture()).setType(TextType.LEFT);
      moreInfoText.setWidth(130);
      moreInfoText.updateText(this.getMoreText());
      moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
      moreInfo.setSize(130, 100);
      moreInfo.setSelfPosition(5, 5);
      widgetGroup.addWidget(moreInfo);
   }

   public String getMoreText() {
      return Component.m_237115_(String.format("%s.%s.%s", new Object[]{"skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()})).getString();
   }

   public String getIcon() {
      return "tde:textures/skill/dodge/basic.png";
   }

   private int getPerfectTick() {
      return 4;
   }

   private float getCost() {
      return 20.0F;
   }

   public BasicDodge(BasicDodge.Builder builder) {
      super(builder);
      this.animations = builder.animations;
   }

   public static BasicDodge.Builder createDodgeBuilder() {
      return (BasicDodge.Builder)(new BasicDodge.Builder()).setAnimations(new AnimationAccessor[]{DodgeAnimations.BASICDODGE_F, DodgeAnimations.BASICDODGE_B, DodgeAnimations.BASICDODGE_L, DodgeAnimations.BASICDODGE_R}).setCategory(SkillCategories.DODGE).setActivateType(ActivateType.ONE_SHOT);
   }

   public void onInitiate(SkillContainer container) {
      container.getExecutor().getEventListener().addEventListener(EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, this);
   }

   public void updateContainer(SkillContainer container) {
      super.updateContainer(container);
      PlayerPatch player = container.getExecutor();
      if(player instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)player;
         ServerPlayer player1 = (ServerPlayer)serverPlayerPatch.getOriginal();
         int dodgeTime = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.DODGE_TIME.get())).intValue();
         int perfectDodgeTime = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get())).intValue();
         if(dodgeTime > 0) {
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.DODGE_TIME.get(), Integer.valueOf(dodgeTime - 1), player1);
            if(dodgeTime - 1 <= 0 && perfectDodgeTime <= 0) {
               serverPlayerPatch.costEnergy(this.getCost());
               serverPlayerPatch.stopEnergyRecoveryTime = 15;
            } else if(dodgeTime - 1 <= 0 && perfectDodgeTime > 0) {
               serverPlayerPatch.stopEnergyRecoveryTime = 0;
            }
         }

         if(perfectDodgeTime > 0) {
            ServerPlayer serverPlayer = (ServerPlayer)serverPlayerPatch.getOriginal();
            serverPlayer.m_284548_().m_8767_((SimpleParticleType)EpicFightParticles.ENTITY_AFTER_IMAGE.get(), serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1, (double)serverPlayer.m_19879_(), 1.0D, 1.0D, (double)serverPlayer.m_19879_());
            container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get(), Integer.valueOf(perfectDodgeTime - 1), player1);
         }
      }

   }

   public void onRemoved(SkillContainer container) {
      container.getExecutor().getEventListener().removeListener(EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
   }

   @OnlyIn(Dist.CLIENT)
   public Object getExecutionPacket(SkillContainer container, FriendlyByteBuf args) {
      LocalPlayerPatch executor = container.getClientExecutor();
      Input input = ((LocalPlayer)executor.getOriginal()).f_108618_;
      float pulse = Mth.m_14036_(0.3F + EnchantmentHelper.m_220302_((LivingEntity)executor.getOriginal()), 0.0F, 1.0F);
      input.m_214106_(false, pulse);
      int forward = input.f_108568_?1:0;
      int backward = input.f_108569_?-1:0;
      int left = input.f_108570_?1:0;
      int right = input.f_108571_?-1:0;
      int vertic = forward + backward;
      int horizon = left + right;
      float yRot = Minecraft.m_91087_().f_91063_.m_109153_().m_90590_();
      float degree = (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon)) + yRot;
      int animation;
      if(vertic == 0) {
         if(horizon == 0) {
            animation = 0;
         } else {
            animation = horizon >= 0?2:3;
         }
      } else {
         animation = vertic >= 0?0:1;
      }

      CPExecuteSkill packet = new CPExecuteSkill(container.getSlotId());
      packet.getBuffer().writeInt(animation);
      packet.getBuffer().writeFloat(vertic == 0 && horizon != 0?yRot:degree);
      return packet;
   }

   public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
      super.executeOnServer(skillContainer, args);
      ServerPlayerPatch executor = skillContainer.getServerExecutor();
      int i = args.readInt();
      float yRot = args.readFloat();
      ServerPlayer player = (ServerPlayer)skillContainer.getServerExecutor().getOriginal();
      if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, player) >= this.getCost()) {
         executor.playAnimationSynchronized(this.animations[i], 0.0F);
         skillContainer.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.DODGE_TIME.get(), Integer.valueOf(this.getPerfectTick()), player);
         executor.setModelYRot(yRot, true);
         skillContainer.getExecutor().playSound((SoundEvent)EpicFightSounds.ENTITY_MOVE.get(), 1.0F, 1.0F);
      }
   }

   // $FF: synthetic method
   private void lambda$onInitiate$0(DodgeSuccessEvent event) {
      ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
      if(((Integer)((ServerPlayerPatch)event.getPlayerPatch()).getSkill(SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.DODGE_TIME.get())).intValue() <= this.getPerfectTick()) {
         ((ServerPlayerPatch)event.getPlayerPatch()).getSkill(SkillSlots.DODGE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get(), Integer.valueOf(20), serverPlayer);
      }

   }


   public static class Builder extends SkillBuilder {

      protected AnimationAccessor[] animations;


      @SafeVarargs
      public final BasicDodge.Builder setAnimations(AnimationAccessor ... animations) {
         this.animations = animations;
         return this;
      }
   }
}
