package com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill.Builder;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Animations;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Skill;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CS1_8Skill extends CS1Skill {

   public CS1_8Skill(Builder builder) {
      super(builder);
   }

   public String getIcon() {
      return "tde:textures/skill/cycle/cs1_8.png";
   }

   public void tickEvent(PlayerPatch playerPatch) {
      super.tickEvent(playerPatch);
      if(TDEAbilityUtils.getAbility(AbilityType.MANA, (Player)playerPatch.getOriginal()) < 80.0F) {
         this.toNext(playerPatch);
      }

   }

   public void uesServerEvent(ServerPlayerPatch playerPatch) {
      super.uesServerEvent(playerPatch);
      if(TDEAbilityUtils.getAbility(AbilityType.MANA, (Player)playerPatch.getOriginal()) >= 80.0F) {
         playerPatch.playAnimationSynchronized(CS1Animations.CS1_8, 0.0F);
      }

      this.toNext(playerPatch);
   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.INTELLIGENCE, Float.valueOf(5.0F));
      requirements.put(AbilityType.ARCANE, Float.valueOf(10.0F));
      return requirements;
   }

   public float getMaxWeight() {
      return 50.0F;
   }

   public Set getMainAllowed() {
      return null;
   }

   public Set getOffAllowed() {
      return null;
   }
}
