package com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill.Builder;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Skill;
import com.merlin204.tde.util.TDEAnimationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CS1_6Skill extends CS1Skill {

   public CS1_6Skill(Builder builder) {
      super(builder);
   }

   public String getIcon() {
      return "tde:textures/skill/cycle/cs1_6.png";
   }

   public void tickEvent(PlayerPatch playerPatch) {
      super.tickEvent(playerPatch);
      if(playerPatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)playerPatch;
         if(tdeServerPlayerPatch.getPerfectGuardTime() > 0) {
            TDEAnimationUtils.groundSplit(tdeServerPlayerPatch, 0.0D, 0.0D, 0.0D, 0.0D, 5.0F, 8);
            this.toNext(tdeServerPlayerPatch);
         }
      }

   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.STRENGTH, Float.valueOf(12.0F));
      requirements.put(AbilityType.STAMINA, Float.valueOf(8.0F));
      return requirements;
   }

   public float getMaxWeight() {
      return 30.0F;
   }

   public Set getMainAllowed() {
      return null;
   }

   public Set getOffAllowed() {
      return null;
   }
}
