package com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.effect.TDEMobEffects;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill.Builder;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Animations;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Skill;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CS1_4Skill extends CS1Skill {

   public CS1_4Skill(Builder builder) {
      super(builder);
   }

   public String getIcon() {
      return "tde:textures/skill/cycle/cs1_4.png";
   }

   public void uesTickEvent(PlayerPatch playerPatch) {
      super.uesTickEvent(playerPatch);
      if(playerPatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)playerPatch;
         ServerPlayer serverPlayer = (ServerPlayer)tdeServerPlayerPatch.getOriginal();
         MobEffectInstance mobEffectInstance = serverPlayer.m_21124_((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get());
         if(mobEffectInstance != null && mobEffectInstance.m_19564_() > 0) {
            serverPlayer.m_21195_((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get());
            if(serverPlayer.m_21124_(MobEffects.f_19600_) != null) {
               int i = Math.min(serverPlayer.m_21124_(MobEffects.f_19600_).m_19564_() + mobEffectInstance.m_19564_(), 10);
               serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 500, i, false, false, true));
            } else {
               serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 500, mobEffectInstance.m_19564_(), false, false, true));
            }
         }
      }

   }

   public void tickEvent(PlayerPatch playerPatch) {
      super.tickEvent(playerPatch);
      if(TDEAbilityUtils.getAbility(AbilityType.MANA, (Player)playerPatch.getOriginal()) < 50.0F) {
         this.toNext(playerPatch);
      }

   }

   public void uesServerEvent(ServerPlayerPatch playerPatch) {
      super.uesServerEvent(playerPatch);
      if(TDEAbilityUtils.getAbility(AbilityType.MANA, (Player)playerPatch.getOriginal()) >= 50.0F) {
         playerPatch.playAnimationSynchronized(CS1Animations.CS1_4, 0.0F);
      }

      this.toNext(playerPatch);
   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.INTELLIGENCE, Float.valueOf(5.0F));
      requirements.put(AbilityType.ARCANE, Float.valueOf(6.0F));
      return requirements;
   }

   public float getMaxWeight() {
      return 50.0F;
   }

   public Set getMainAllowed() {
      return null;
   }

   public Set getOffAllowed() {
      return null;
   }
}
