package com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill.Builder;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Animations;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.cs1.CS1Skill;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class CS1_1Skill extends CS1Skill {

   public CS1_1Skill(Builder builder) {
      super(builder);
   }

   public String getIcon() {
      return "tde:textures/skill/cycle/cs1_1.png";
   }

   public void uesServerEvent(ServerPlayerPatch playerPatch) {
      label12: {
         super.uesServerEvent(playerPatch);
         if(playerPatch instanceof TDEServerPlayerPatch) {
            TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)playerPatch;
            if(tdeServerPlayerPatch.getPerfectDodgeTime() > 0) {
               playerPatch.playAnimationSynchronized(CS1Animations.CS1_1B, 0.0F);
               break label12;
            }
         }

         playerPatch.playAnimationSynchronized(CS1Animations.CS1_1, 0.0F);
      }

      this.toNext(playerPatch);
   }

   public Map getAbilityRequirements() {
      HashMap requirements = new HashMap();
      requirements.put(AbilityType.STRENGTH, Float.valueOf(5.0F));
      requirements.put(AbilityType.DEXTERITY, Float.valueOf(10.0F));
      return requirements;
   }

   public float getMaxWeight() {
      return 15.0F;
   }

   public Set getMainAllowed() {
      return Set.of(TDEWeaponType.SWORD, TDEWeaponType.DAGGER);
   }

   public Set getOffAllowed() {
      return Set.of(TDEWeaponType.SWORD, TDEWeaponType.DAGGER, TDEWeaponType.HATCHET);
   }
}
