package com.merlin204.tde.epicfight.gameassets.skill.cycle;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.skill.Skill.Resource;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public abstract class CycleSkill extends Skill implements SkillInfo {

   public CycleSkill(CycleSkill.Builder builder) {
      super(builder);
   }

   public String getMoreText() {
      return Component.m_237115_(String.format("%s.%s.%s", new Object[]{"skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()})).getString();
   }

   public void setMoreInfo(WidgetGroup widgetGroup) {
      super.setMoreInfo(widgetGroup);
      ImageWidget moreInfo = new ImageWidget();
      TextTexture moreInfoText = (new TextTexture()).setType(TextType.LEFT);
      moreInfoText.setWidth(130);
      moreInfoText.updateText(this.getMoreText());
      moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
      moreInfo.setSize(130, 100);
      moreInfo.setSelfPosition(5, 5);
      widgetGroup.addWidget(moreInfo);
   }

   public static CycleSkill.Builder createCycleBuilder() {
      return (new CycleSkill.Builder()).setCategory(TDESkillCategories.CYCLE).setResource(Resource.NONE);
   }

   public void uesServerEvent(ServerPlayerPatch playerPatch) {
   }

   public void cycleInEvent(PlayerPatch playerPatch) {
      if(!this.validatePlayer((Player)playerPatch.getOriginal())) {
         this.setCoolDown(playerPatch, 100);
      }

   }

   public void cycleOutEvent(PlayerPatch playerPatch) {
   }

   public void tickEvent(PlayerPatch playerPatch) {
   }

   public void uesStartEvent(PlayerPatch playerPatch) {
   }

   public void uesEndEvent(PlayerPatch playerPatch) {
   }

   public void uesTickEvent(PlayerPatch playerPatch) {
   }

   public boolean validatePlayer(Player player) {
      if(!this.validatePlayerWeapons(player)) {
         Minecraft.m_91087_().f_91065_.m_93063_(Component.m_237115_("gui.tde.cycle.warn_1"), false);
         return false;
      } else if(!this.validatePlayerAbilities(player)) {
         Minecraft.m_91087_().f_91065_.m_93063_(Component.m_237115_("gui.tde.cycle.warn_2"), false);
         return false;
      } else {
         return super.validatePlayer(player);
      }
   }

   public int getMaxCoolDown() {
      return 100;
   }

   public boolean canExecute(SkillContainer container) {
      PlayerPatch executor = container.getExecutor();
      return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_() || !container.getExecutor().getEntityState().inaction() || container.getExecutor().getEntityState().canUseSkill();
   }

   public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
      super.executeOnServer(container, args);
      ServerPlayerPatch executor = container.getServerExecutor();
      if(this.getCoolDown(container.getExecutor()) <= 0 && this.getSlotNumber(executor) == (int)TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)executor.getOriginal())) {
         this.uesServerEvent(executor);
      }
   }

   public void updateContainer(SkillContainer container) {
      super.updateContainer(container);
      PlayerPatch playerPatch = container.getExecutor();
      if(this.getCoolDown(container.getExecutor()) > 0) {
         this.setCoolDown(container.getExecutor(), this.getCoolDown(container.getExecutor()) - 1);
      }

      if((float)this.getSlotNumber(playerPatch) == TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal()) && !this.cycleNow(playerPatch)) {
         this.setCycleNow(playerPatch, true);
         this.cycleInEvent(playerPatch);
      } else if((float)this.getSlotNumber(playerPatch) != TDEAbilityUtils.getAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal()) && this.cycleNow(playerPatch)) {
         this.setCycleNow(playerPatch, false);
         this.cycleOutEvent(playerPatch);
      }

      if(this.getCoolDown(playerPatch) == 0 && this.cycleNow(playerPatch) && !super.validatePlayer((Player)playerPatch.getOriginal())) {
         this.toNext(playerPatch);
      }

      if(this.cycleNow(playerPatch) && this.getCoolDown(playerPatch) == 0) {
         this.tickEvent(playerPatch);
         if(this.getUesTick(playerPatch) > 0) {
            if(!this.uesNow(playerPatch)) {
               this.uesStartEvent(playerPatch);
               this.setUesNow(playerPatch, true);
            }

            this.uesTickEvent(playerPatch);
            this.setUesTick(playerPatch, this.getUesTick(playerPatch) - 1);
         } else if(this.getUesTick(playerPatch) == 0 && this.uesNow(playerPatch)) {
            this.uesEndEvent(playerPatch);
            this.setUesNow(playerPatch, false);
         }
      }

   }

   public void toNext(PlayerPatch playerPatch) {
      TDEAbilityUtils.setAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal(), (float)this.getNextSlot(playerPatch).getCycle());
   }

   public void toPrevious(PlayerPatch playerPatch) {
      TDEAbilityUtils.setAbility(AbilityType.CYCLE, (Player)playerPatch.getOriginal(), (float)this.getPreviousSlot(playerPatch).getCycle());
   }

   public TDESkillSlots getNextSlot(PlayerPatch playerPatch) {
      TDESkillSlots var10000;
      switch(this.getSlot(playerPatch).getCycle()) {
      case 1:
         var10000 = TDESkillSlots.CYCLE_2;
         break;
      case 2:
         var10000 = TDESkillSlots.CYCLE_3;
         break;
      case 3:
         var10000 = TDESkillSlots.CYCLE_4;
         break;
      case 4:
         var10000 = TDESkillSlots.CYCLE_5;
         break;
      case 5:
         var10000 = TDESkillSlots.CYCLE_1;
         break;
      default:
         var10000 = null;
      }

      return var10000;
   }

   public TDESkillSlots getPreviousSlot(PlayerPatch playerPatch) {
      TDESkillSlots var10000;
      switch(this.getSlot(playerPatch).getCycle()) {
      case 1:
         var10000 = TDESkillSlots.CYCLE_5;
         break;
      case 2:
         var10000 = TDESkillSlots.CYCLE_1;
         break;
      case 3:
         var10000 = TDESkillSlots.CYCLE_2;
         break;
      case 4:
         var10000 = TDESkillSlots.CYCLE_3;
         break;
      case 5:
         var10000 = TDESkillSlots.CYCLE_4;
         break;
      default:
         var10000 = null;
      }

      return var10000;
   }

   public boolean uesNow(PlayerPatch playerPatch) {
      return ((Boolean)playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.UES_NOW.get())).booleanValue();
   }

   public void setUesNow(PlayerPatch playerPatch, boolean b) {
      Entity var5 = playerPatch.getOriginal();
      if(var5 instanceof LocalPlayer) {
         LocalPlayer localPlayer = (LocalPlayer)var5;
         playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_NOW.get(), Boolean.valueOf(b), localPlayer);
      } else {
         var5 = playerPatch.getOriginal();
         if(var5 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)var5;
            playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_NOW.get(), Boolean.valueOf(b), serverPlayer);
         }
      }

   }

   public boolean cycleNow(PlayerPatch playerPatch) {
      return ((Boolean)playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CYCLE_NOW.get())).booleanValue();
   }

   public void setCycleNow(PlayerPatch playerPatch, boolean b) {
      Entity var5 = playerPatch.getOriginal();
      if(var5 instanceof LocalPlayer) {
         LocalPlayer localPlayer = (LocalPlayer)var5;
         playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_NOW.get(), Boolean.valueOf(b), localPlayer);
      } else {
         var5 = playerPatch.getOriginal();
         if(var5 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)var5;
            playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_NOW.get(), Boolean.valueOf(b), serverPlayer);
         }
      }

   }

   public int getUesTick(PlayerPatch playerPatch) {
      return ((Integer)playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.UES_TICK.get())).intValue();
   }

   public void setUesTick(PlayerPatch playerPatch, int tick) {
      Entity var5 = playerPatch.getOriginal();
      if(var5 instanceof LocalPlayer) {
         LocalPlayer localPlayer = (LocalPlayer)var5;
         playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_TICK.get(), Integer.valueOf(tick), localPlayer);
      } else {
         var5 = playerPatch.getOriginal();
         if(var5 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)var5;
            playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.UES_TICK.get(), Integer.valueOf(tick), serverPlayer);
         }
      }

   }

   public int getCoolDown(PlayerPatch playerPatch) {
      return ((Integer)playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get())).intValue();
   }

   public void setCoolDown(PlayerPatch playerPatch, int tick) {
      Entity var5 = playerPatch.getOriginal();
      if(var5 instanceof LocalPlayer) {
         LocalPlayer localPlayer = (LocalPlayer)var5;
         playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get(), Integer.valueOf(tick), localPlayer);
      } else {
         var5 = playerPatch.getOriginal();
         if(var5 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)var5;
            playerPatch.getSkill(this.getSlot(playerPatch)).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CYCLE_COOLDOWN.get(), Integer.valueOf(tick), serverPlayer);
         }
      }

   }

   public int getSlotNumber(PlayerPatch playerPatch) {
      return this.getSlot(playerPatch).getCycle();
   }

   public TDESkillSlots getSlot(PlayerPatch playerPatch) {
      Iterator var2 = List.of(TDESkillSlots.CYCLE_1, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_5).iterator();

      TDESkillSlots slot;
      Skill skill;
      do {
         if(!var2.hasNext()) {
            return null;
         }

         slot = (TDESkillSlots)var2.next();
         skill = playerPatch.getSkill(slot).getSkill();
      } while(skill != this);

      return slot;
   }

   public static class Builder extends SkillBuilder {

      public CycleSkill.Builder setCategory(SkillCategory category) {
         this.category = category;
         return this;
      }

      public CycleSkill.Builder setActivateType(ActivateType activateType) {
         this.activateType = activateType;
         return this;
      }

      public CycleSkill.Builder setResource(Resource resource) {
         this.resource = resource;
         return this;
      }

      public CycleSkill.Builder setCreativeTab(CreativeModeTab tab) {
         this.tab = tab;
         return this;
      }
   }
}
