package com.merlin204.tde.epicfight.gameassets.skill.charge;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture.TextType;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.keymapping.TDEKeyMappings;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.SkillInfo;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.skill.Skill.Resource;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.MovementInputEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

public class BasicChargedAttack extends Skill implements SkillInfo {

   protected static final UUID EVENT_UUID = UUID.fromString("b421f7a0-f568-11eb-9a03-0242ac130103");
   public int MAX_CHARGING_TICKS = 60;
   public int MIN_CHARGING_TICKS = 10;
   private float COST = 0.5F;


   public String getIcon() {
      return "tde:textures/skill/charge/basic.png";
   }

   public String getMoreText() {
      return Component.m_237115_(String.format("%s.%s.%s", new Object[]{"skill", this.getRegistryName().m_135827_(), this.getRegistryName().m_135815_()})).getString();
   }

   public boolean canExecute(SkillContainer container) {
      PlayerPatch executor = container.getExecutor();
      return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_();
   }

   public void setMoreInfo(WidgetGroup widgetGroup) {
      super.setMoreInfo(widgetGroup);
      ImageWidget moreInfo = new ImageWidget();
      TextTexture moreInfoText = (new TextTexture()).setType(TextType.LEFT);
      moreInfoText.setWidth(130);
      moreInfoText.updateText(this.getMoreText());
      moreInfo.setBackground(new IGuiTexture[]{moreInfoText});
      moreInfo.setSize(130, 100);
      moreInfo.setSelfPosition(5, 5);
      widgetGroup.addWidget(moreInfo);
   }

   public void updateContainer(SkillContainer container) {
      super.updateContainer(container);
      if(!container.getExecutor().getEntityState().inaction()) {
         SkillContainer basicAttack = container.getExecutor().getSkill(TDESkillSlots.SECT);
         Skill tdeLocalPlayerPatch = basicAttack.getSkill();
         if(tdeLocalPlayerPatch instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)tdeLocalPlayerPatch;
            if(container.getExecutor().isLogicalClient()) {
               PlayerPatch player = container.getExecutor();
               if(player instanceof TDELocalPlayerPatch) {
                  TDELocalPlayerPatch tdeLocalPlayerPatch1 = (TDELocalPlayerPatch)player;
                  if(!basicSect.checkAllowed((Player)tdeLocalPlayerPatch1.getOriginal())) {
                     return;
                  }

                  LocalPlayer player1 = (LocalPlayer)container.getExecutor().getOriginal();
                  boolean isKeyDown = TDEKeyMappings.CHARGED_ATTACK.m_90857_();
                  boolean wasCharging = ((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get())).booleanValue();
                  int chargingTime = ((Integer)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.CHARGING_TIME.get())).intValue();
                  if(isKeyDown) {
                     if(chargingTime == this.MAX_CHARGING_TICKS) {
                        tdeLocalPlayerPatch1.costEnergy(this.COST * 0.4F);
                     } else {
                        tdeLocalPlayerPatch1.costEnergy(this.COST);
                     }

                     if(TDEAbilityUtils.getAbility(AbilityType.ENERGY, player1) == 0.0F) {
                        if(chargingTime >= this.MIN_CHARGING_TICKS) {
                           if(chargingTime == this.MAX_CHARGING_TICKS) {
                              container.getExecutor().playAnimationSynchronized(basicSect.getFullChargingAttackAnimation(), 0.0F);
                           } else {
                              container.getExecutor().playAnimationSynchronized(basicSect.getChargingAttackAnimation(), 0.0F);
                           }
                        }

                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), Float.valueOf((float)chargingTime / (float)this.MAX_CHARGING_TICKS), player1);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), Integer.valueOf(0), player1);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), Boolean.valueOf(false), player1);
                        return;
                     }

                     if(!wasCharging) {
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), Boolean.valueOf(true), player1);
                        container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), Integer.valueOf(0), player1);
                     } else {
                        int newTime = Math.min(chargingTime + 1, this.MAX_CHARGING_TICKS);
                        if(newTime != chargingTime) {
                           container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), Integer.valueOf(newTime), player1);
                        }

                        if(chargingTime == this.MIN_CHARGING_TICKS) {
                           container.getExecutor().playAnimationSynchronized(basicSect.getChargingAnimation(), 0.15F);
                        }
                     }
                  } else if(wasCharging) {
                     if(chargingTime >= this.MIN_CHARGING_TICKS) {
                        if(chargingTime == this.MAX_CHARGING_TICKS) {
                           container.getExecutor().playAnimationSynchronized(basicSect.getFullChargingAttackAnimation(), 0.0F);
                        } else {
                           container.getExecutor().playAnimationSynchronized(basicSect.getChargingAttackAnimation(), 0.0F);
                        }
                     }

                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), Float.valueOf((float)chargingTime / (float)this.MAX_CHARGING_TICKS), player1);
                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.IS_CHARGING.get(), Boolean.valueOf(false), player1);
                     container.getDataManager().setDataSync((SkillDataKey)TDEDatakeys.CHARGING_TIME.get(), Integer.valueOf(0), player1);
                  }
               }
            }
         }

      }
   }

   public BasicChargedAttack(BasicChargedAttack.Builder builder) {
      super(builder);
   }

   public static BasicChargedAttack.Builder createChargedBasicAttackBuilder() {
      return (new BasicChargedAttack.Builder()).setCategory(TDESkillCategories.CHARGED_ATTACK).setResource(Resource.NONE);
   }

   public void onInitiate(SkillContainer container) {
      container.getExecutor().getEventListener().addEventListener(EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, container);
   }

   public void onRemoved(SkillContainer container) {
      container.getExecutor().getEventListener().removeListener(EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
   }

   public int getMAX_CHARGING_TICKS() {
      return this.MAX_CHARGING_TICKS;
   }

   public KeyMapping getKeyMapping() {
      return TDEKeyMappings.CHARGED_ATTACK;
   }

   // $FF: synthetic method
   private static void lambda$onInitiate$0(SkillContainer container, MovementInputEvent event) {
      if(((Boolean)container.getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get())).booleanValue()) {
         LocalPlayer clientPlayer = (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal();
         clientPlayer.m_6858_(false);
         clientPlayer.m_20334_(0.0D, 0.0D, 0.0D);
         Minecraft mc = Minecraft.m_91087_();
         ControllEngine.setKeyBind(mc.f_91066_.f_92091_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92085_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92087_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92086_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92088_, false);
         ControllEngine.setKeyBind(mc.f_91066_.f_92089_, false);
      }

   }


   public static class Builder extends SkillBuilder {

      public BasicChargedAttack.Builder setCategory(SkillCategory category) {
         super.setCategory(category);
         return this;
      }

      public BasicChargedAttack.Builder setActivateType(ActivateType activateType) {
         super.setActivateType(activateType);
         return this;
      }

      public BasicChargedAttack.Builder setResource(Resource resource) {
         super.setResource(resource);
         return this;
      }
   }
}
