package com.merlin204.tde.epicfight.gameassets.skill;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.gui.UiResource;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponType;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface SkillInfo {

   default String getIcon() {
      return "tde:textures/skill/empty.png";
   }

   default String getGroup() {
      return "basic";
   }

   default void setMoreInfo(WidgetGroup widgetGroup) {
      widgetGroup.setSize(140, 120);
      widgetGroup.setSelfPosition(5, 45);
      widgetGroup.setBackground(new IGuiTexture[]{UiResource.BACKGROUND_1});
   }

   default WidgetGroup getMoreInfo() {
      return new WidgetGroup();
   }

   default String getMoreText() {
      return "";
   }

   default Component getIntroduce() {
      return Component.m_237115_(this.getGroup());
   }

   default Set getMainAllowed() {
      return null;
   }

   default Set getOffAllowed() {
      return null;
   }

   default float getMaxWeight() {
      return 100.0F;
   }

   default Map getAbilityRequirements() {
      return Map.of();
   }

   default String getMainAllowedWeaponTypes() {
      return this.weaponTypesToString(this.getMainAllowed());
   }

   default String getOffAllowedWeaponTypes() {
      return this.weaponTypesToString(this.getOffAllowed());
   }

   private default String weaponTypesToString(Set param1) {
      // $FF: Couldn't be decompiled
   }

   default float getAbilityRequirement(AbilityType abilityType) {
      return ((Float)this.getAbilityRequirements().getOrDefault(abilityType, Float.valueOf(0.0F))).floatValue();
   }

   default boolean validatePlayer(Player player) {
      return this.validatePlayerWeapons(player) && this.validatePlayerAbilities(player);
   }

   default boolean validatePlayerWeapons(Player player) {
      ItemStack mainHand = player.m_21205_();
      ItemStack offHand = player.m_21206_();
      float totalWeight = getItemWeight(mainHand) + getItemWeight(offHand);
      return totalWeight > this.getMaxWeight()?false:(!isValidItem(mainHand, this.getMainAllowed())?false:isValidItem(offHand, this.getOffAllowed()));
   }

   default boolean validatePlayerAbilities(Player player) {
      Map requirements = this.getAbilityRequirements();
      Iterator var3 = requirements.entrySet().iterator();

      float requiredValue;
      float playerValue;
      do {
         if(!var3.hasNext()) {
            return true;
         }

         Entry entry = (Entry)var3.next();
         AbilityType type = (AbilityType)entry.getKey();
         requiredValue = ((Float)entry.getValue()).floatValue();
         playerValue = TDEAbilityUtils.getAbility(type, player);
      } while(playerValue >= requiredValue);

      return false;
   }

   private static default boolean isValidItem(ItemStack stack, Set allowed) {
      if(allowed == null) {
         return true;
      } else if(stack.m_41619_()) {
         return allowed.contains(TDEWeaponType.EMPTY);
      } else {
         Item var3 = stack.m_41720_();
         if(var3 instanceof TDEWeaponItem) {
            TDEWeaponItem weapon = (TDEWeaponItem)var3;
            return allowed.contains(weapon.getProperties().getWeaponType());
         } else {
            return allowed.contains(TDEWeaponType.EMPTY);
         }
      }
   }

   private static default float getItemWeight(ItemStack stack) {
      if(stack.m_41619_()) {
         return 0.0F;
      } else {
         Item var2 = stack.m_41720_();
         if(var2 instanceof TDEWeaponItem) {
            TDEWeaponItem weapon = (TDEWeaponItem)var2;
            return weapon.getProperties().getWeight();
         } else {
            return 0.5F;
         }
      }
   }

   // $FF: synthetic method
   private static default String lambda$weaponTypesToString$0(TDEWeaponType type) {
      return Component.m_237115_(type.getTranslationKey()).getString();
   }
}
