package com.merlin204.tde.epicfight.gameassets.skill;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.epicfight.gameassets.skill.soulfire.SoulfireSkill;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillCategories;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.Skill.ActivateType;
import yesman.epicfight.skill.Skill.Resource;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class ExecuteSkill extends Skill {

   public ExecuteSkill(ExecuteSkill.Builder builder) {
      super(builder);
   }

   public static ExecuteSkill.Builder createExecuteBuilder() {
      return (new ExecuteSkill.Builder()).setCategory(TDESkillCategories.EXECUTE).setResource(Resource.NONE);
   }

   public int getCoolDown(PlayerPatch playerPatch) {
      return ((Integer)playerPatch.getSkill(TDESkillSlots.EXECUTE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get())).intValue();
   }

   public void setCoolDown(PlayerPatch playerPatch, int tick) {
      Entity var5 = playerPatch.getOriginal();
      if(var5 instanceof LocalPlayer) {
         LocalPlayer localPlayer = (LocalPlayer)var5;
         playerPatch.getSkill(TDESkillSlots.EXECUTE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get(), Integer.valueOf(tick), localPlayer);
      } else {
         var5 = playerPatch.getOriginal();
         if(var5 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)var5;
            playerPatch.getSkill(TDESkillSlots.EXECUTE).getDataManager().setDataSync((SkillDataKey)TDEDatakeys.EXCUTE_COOLDOWN.get(), Integer.valueOf(tick), serverPlayer);
         }
      }

   }

   public boolean canExecute(SkillContainer container) {
      PlayerPatch executor = container.getExecutor();
      return ((Player)executor.getOriginal()).m_20096_() || ((Player)executor.getOriginal()).m_7500_() || !container.getExecutor().getEntityState().inaction();
   }

   public void executeOnServer(SkillContainer container, FriendlyByteBuf args) {
      super.executeOnServer(container, args);
      if(this.getCoolDown(container.getExecutor()) <= 0) {
         ServerPlayerPatch executor = container.getServerExecutor();
         if(executor.getTarget() != null) {
            LivingEntity soulfireSkill = executor.getTarget();
            if(soulfireSkill instanceof EnemyEntity) {
               EnemyEntity enemyEntity = (EnemyEntity)soulfireSkill;
               if(enemyEntity.isKnockdown()) {
                  Skill var6 = executor.getSkill(TDESkillSlots.SOULFIRE).getSkill();
                  if(var6 instanceof SoulfireSkill) {
                     SoulfireSkill soulfireSkill1 = (SoulfireSkill)var6;
                     executor.playAnimationSynchronized(soulfireSkill1.getExecuteAnimation(), 0.0F);
                     TDEAbilityUtils.addAbility(AbilityType.ENERGY, (Player)executor.getOriginal(), 9999.0F);
                  }
               }
            }
         }

      }
   }

   public void updateContainer(SkillContainer container) {
      super.updateContainer(container);
      if(this.getCoolDown(container.getExecutor()) > 0) {
         this.setCoolDown(container.getExecutor(), this.getCoolDown(container.getExecutor()) - 1);
      }

   }

   public static class Builder extends SkillBuilder {

      public ExecuteSkill.Builder setCategory(SkillCategory category) {
         this.category = category;
         return this;
      }

      public ExecuteSkill.Builder setActivateType(ActivateType activateType) {
         this.activateType = activateType;
         return this;
      }

      public ExecuteSkill.Builder setResource(Resource resource) {
         this.resource = resource;
         return this;
      }

      public ExecuteSkill.Builder setCreativeTab(CreativeModeTab tab) {
         this.tab = tab;
         return this;
      }
   }
}
