package com.merlin204.tde.epicfight.animations.player;

import java.util.function.Function;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.StaticAnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult.ResultType;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageType;
import yesman.epicfight.world.entity.DodgeLocationIndicator;

public class TDEPlayerDodgeAnimation extends ActionAnimation {

   public static final Function DODGEABLE_SUCCESS;


   public TDEPlayerDodgeAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature) {
      this(transitionTime, 10.0F, accessor, armature);
   }

   public TDEPlayerDodgeAnimation(float transitionTime, float endFrame, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, endFrame / 60.0F, accessor, armature);
      float endTime = endFrame / 60.0F;
      this.stateSpectrumBlueprint.clear().newTimePair(0.0F, endTime).addState(EntityState.TURNING_LOCKED, Boolean.valueOf(true)).addState(EntityState.MOVEMENT_LOCKED, Boolean.valueOf(true)).addState(EntityState.UPDATE_LIVING_MOTION, Boolean.valueOf(false)).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(false)).addState(EntityState.INACTION, Boolean.valueOf(true)).addState(EntityState.ATTACK_RESULT, DODGEABLE_SUCCESS).newTimePair(endTime, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, Boolean.valueOf(false)).addState(EntityState.MOVEMENT_LOCKED, Boolean.valueOf(false)).addState(EntityState.UPDATE_LIVING_MOTION, Boolean.valueOf(true)).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(true)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(true)).addState(EntityState.INACTION, Boolean.valueOf(true));
      this.addProperty(ActionAnimationProperty.AFFECT_SPEED, Boolean.valueOf(true));
      this.addProperty(StaticAnimationProperty.FIXED_HEAD_ROTATION, Boolean.valueOf(false));
   }

   public void begin(LivingEntityPatch entitypatch) {
      super.begin(entitypatch);
      if(!entitypatch.isLogicalClient() && entitypatch != null) {
         ((LivingEntity)entitypatch.getOriginal()).m_9236_().m_7967_(new DodgeLocationIndicator(entitypatch));
      }

   }

   // $FF: synthetic method
   private static ResultType lambda$static$0(DamageSource damagesource) {
      return damagesource.m_7639_() != null && !damagesource.m_276093_(DamageTypes.f_268515_) && !damagesource.m_269533_(DamageTypeTags.f_268490_) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && !damagesource.m_269533_(EpicFightDamageType.BYPASS_DODGE)?ResultType.MISSED:ResultType.SUCCESS;
   }

   static {
      // $FF: Couldn't be decompiled
   }
}
