package com.merlin204.tde.epicfight.animations.player;

import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEPlayerBlockHitAnimation extends ActionAnimation {

   private final boolean shouldReserve;


   public TDEPlayerBlockHitAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, accessor, armature);
      this.addProperty(ActionAnimationProperty.FIXED_HEAD_ROTATION, Boolean.valueOf(false));
      this.newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.INACTION, Boolean.valueOf(false)).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(true)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(true)).addState(EntityState.CAN_SWITCH_HAND_ITEM, Boolean.valueOf(false)).addState(EntityState.CAN_USE_ITEM, Boolean.valueOf(true));
      this.shouldReserve = true;
   }

   public TDEPlayerBlockHitAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, boolean shouldReserve) {
      super(transitionTime, accessor, armature);
      this.addProperty(ActionAnimationProperty.FIXED_HEAD_ROTATION, Boolean.valueOf(false));
      this.newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.INACTION, Boolean.valueOf(false)).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(true)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(true)).addState(EntityState.CAN_SWITCH_HAND_ITEM, Boolean.valueOf(false)).addState(EntityState.CAN_USE_ITEM, Boolean.valueOf(true));
      this.shouldReserve = shouldReserve;
   }

   public void end(LivingEntityPatch entitypatch, AssetAccessor nextAnimation, boolean isEnd) {
      super.end(entitypatch, nextAnimation, isEnd);
      if(entitypatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch = (TDEServerPlayerPatch)entitypatch;
         SkillContainer basicAttack = serverPlayerPatch.getSkill(TDESkillSlots.SECT);
         if(serverPlayerPatch.isGuard()) {
            Skill var7 = basicAttack.getSkill();
            if(var7 instanceof BasicSect) {
               BasicSect basicSect = (BasicSect)var7;
               if(this.shouldReserve) {
                  serverPlayerPatch.reserveAnimation(basicSect.getGuardAnimation());
               }
            }
         }
      }

   }
}
