package com.merlin204.tde.epicfight.animations.player;

import com.merlin204.tde.entity.boss.BossEntity;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.epicfight.animations.TDEAttackAnimation.TDEPhase;
import com.merlin204.tde.epicfight.animations.player.TDEPlayerAttackAnimation;
import com.merlin204.tde.epicfight.gameassets.skill.ExecuteSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.TDEDamageSource;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.AttackPhaseProperty;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.AttackAnimation.Phase;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.HitEntityList.Priority;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ExecuteAnimation extends TDEPlayerAttackAnimation {

   private final float healthDamageRatio;
   private final float energyDamageRatio;


   public ExecuteAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, float healthDamageRatio, float energyDamageRatio, TDEPhase ... phases) {
      super(transitionTime, accessor, armature, phases);
      this.healthDamageRatio = healthDamageRatio;
      this.energyDamageRatio = energyDamageRatio;
   }

   public void tick(LivingEntityPatch entitypatch) {
      super.tick(entitypatch);
      if(entitypatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entitypatch;
         Skill var4 = tdeServerPlayerPatch.getSkill(TDESkillSlots.EXECUTE).getSkill();
         if(var4 instanceof ExecuteSkill) {
            ExecuteSkill executeSkill = (ExecuteSkill)var4;
            executeSkill.setCoolDown(tdeServerPlayerPatch, 5);
         }
      }

   }

   protected void hurtCollidingEntities(LivingEntityPatch entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, Phase phase) {
      LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
      float phasePrevTime = Math.max(prevElapsedTime, phase.start);
      float phaseCurrentTime = Math.min(elapsedTime, phase.end);
      float phasePreDelay = phase.start + phase.preDelay;
      float phaseContact = phase.start + phase.contact;
      if(phaseCurrentTime >= phasePreDelay && phasePrevTime < phaseContact) {
         List list = phase.getCollidingEntities(entitypatch, this, phasePrevTime, phaseCurrentTime, this.getPlaySpeed(entitypatch, this));
         if(!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, (Priority)phase.getProperty(AttackPhaseProperty.HIT_PRIORITY).orElse(Priority.DISTANCE));
            boolean maxStrikes = true;

            while(hitEntities.next()) {
               Entity target = hitEntities.getEntity();
               LivingEntity trueEntity = this.getTrueEntity(target);
               boolean canAttack = trueEntity != null && trueEntity.m_6084_() && !entitypatch.getCurrenltyAttackedEntities().contains(trueEntity) && !entitypatch.isTargetInvulnerable(target);
               if(phase instanceof TDEPhase) {
                  TDEPhase damagesource = (TDEPhase)phase;
                  canAttack = canAttack && damagesource.tryAttack(trueEntity);
               }

               if(canAttack && entity.m_142582_(target)) {
                  TDEDamageSource damagesource1 = this.getEpicFightDamageSource(entitypatch, target, phase);
                  int prevInvulTime = target.f_19802_;
                  target.f_19802_ = 0;
                  AttackResult attackResult = entitypatch.attack(damagesource1, target, phase.hand);
                  target.f_19802_ = prevInvulTime;
                  if(attackResult.resultType.dealtDamage()) {
                     TDEAnimationUtils.shakeCameraForNearbyPlayers(entity.m_9236_(), target.m_20182_(), 3.0D, 20, (float)(damagesource1.getImpactLevel() * 2), 0.5F);
                     if(target instanceof EnemyEntity) {
                        EnemyEntity enemyEntity = (EnemyEntity)target;
                        if(enemyEntity instanceof BossEntity) {
                           enemyEntity.m_6469_(damagesource1, enemyEntity.m_21233_() * this.healthDamageRatio);
                        } else {
                           enemyEntity.m_6469_(damagesource1, enemyEntity.m_21233_() * this.healthDamageRatio * 3.0F);
                        }

                        if(entitypatch instanceof TDEServerPlayerPatch) {
                           TDEServerPlayerPatch tdeServerPlayerPatch = (TDEServerPlayerPatch)entitypatch;
                           tdeServerPlayerPatch.energyDamageAtk(enemyEntity.getEnemyPatch(), enemyEntity.getMaxEnergy() * this.energyDamageRatio);
                        }

                        enemyEntity.getEnemyPatch().playAnimationSynchronized(enemyEntity.getEnemyPatch().getKnockFlyAnimation(), 0.0F);
                     }

                     target.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0F, 1.0F);
                     this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                  }

                  entitypatch.getCurrenltyAttackedEntities().add(trueEntity);
                  if(attackResult.resultType.shouldCount()) {
                     entitypatch.getCurrenltyHurtEntities().add(trueEntity);
                  }
               }
            }
         }

      }
   }
}
