package com.merlin204.tde.epicfight.animations.player;

import com.merlin204.tde.epicfight.animations.TDEAttackAnimation.TDEPhase;
import com.merlin204.tde.epicfight.animations.player.TDEPlayerAttackAnimation;
import com.merlin204.tde.epicfight.gameassets.skill.cycle.CycleSkill;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class CycleSkillAttackAnimation extends TDEPlayerAttackAnimation {

   public CycleSkillAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, float play_speed, float damageMulti, TDEPhase ... phases) {
      super(transitionTime, (AnimationAccessor)accessor, armature, play_speed, damageMulti, phases);
   }

   public CycleSkillAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationAccessor accessor, AssetAccessor armature, float play_speed, float damageMulti) {
      super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature, play_speed, damageMulti);
   }

   public CycleSkillAttackAnimation(float convertTime, String path, AssetAccessor armature, float play_speed, float damageMulti, TDEPhase ... phases) {
      super(convertTime, (String)path, armature, play_speed, damageMulti, phases);
   }

   public CycleSkillAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, TDEPhase ... phases) {
      super(transitionTime, accessor, armature, phases);
   }

   public CycleSkillAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, float damageMulti, TDEPhase ... phases) {
      super(transitionTime, accessor, armature, damageMulti, phases);
   }

   public void tick(LivingEntityPatch entitypatch) {
      super.tick(entitypatch);
      Iterator var2 = List.of(TDESkillSlots.CYCLE_1, TDESkillSlots.CYCLE_2, TDESkillSlots.CYCLE_3, TDESkillSlots.CYCLE_4, TDESkillSlots.CYCLE_5).iterator();

      while(var2.hasNext()) {
         TDESkillSlots slot = (TDESkillSlots)var2.next();
         if(entitypatch instanceof PlayerPatch) {
            PlayerPatch playerPatch = (PlayerPatch)entitypatch;
            Skill var6 = playerPatch.getSkill(slot).getSkill();
            if(var6 instanceof CycleSkill) {
               CycleSkill cycleSkill = (CycleSkill)var6;
               cycleSkill.setUesTick(playerPatch, 3);
            }
         }
      }

   }
}
