package com.merlin204.tde.epicfight.animations;

import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEMovementAnimation extends MovementAnimation {

   private final float speed;


   public TDEMovementAnimation(boolean isRepeat, AnimationAccessor accessor, AssetAccessor armature, float speed) {
      super(isRepeat, accessor, armature);
      this.speed = speed;
   }

   public TDEMovementAnimation(float transitionTime, boolean isRepeat, AnimationAccessor accessor, AssetAccessor armature, float speed) {
      super(transitionTime, isRepeat, accessor, armature);
      this.speed = speed;
   }

   public TDEMovementAnimation(float transitionTime, boolean isRepeat, String path, AssetAccessor armature, float speed) {
      super(transitionTime, isRepeat, path, armature);
      this.speed = speed;
   }

   public float getPlaySpeed(LivingEntityPatch entitypatch, DynamicAnimation animation) {
      if(animation.isLinkAnimation()) {
         return 1.0F;
      } else {
         float movementSpeed = 1.0F;
         if(Math.abs(((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267731_() - ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267711_(1.0F)) < 0.007F) {
            movementSpeed *= ((LivingEntity)entitypatch.getOriginal()).f_267362_.m_267731_() * this.speed;
         }

         return movementSpeed;
      }
   }
}
