package com.merlin204.tde.epicfight.animations;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TDEKnockDownAnimation extends ActionAnimation {

   public TDEKnockDownAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, accessor, armature);
      this.newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(false)).addState(EntityState.CAN_SWITCH_HAND_ITEM, Boolean.valueOf(false)).addState(EntityState.CAN_USE_ITEM, Boolean.valueOf(false));
   }

   public TDEKnockDownAnimation(float transitionTime, float postDelay, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, postDelay, accessor, armature);
      this.newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(false)).addState(EntityState.CAN_SWITCH_HAND_ITEM, Boolean.valueOf(false)).addState(EntityState.CAN_USE_ITEM, Boolean.valueOf(false));
   }

   public TDEKnockDownAnimation(float transitionTime, float postDelay, String path, AssetAccessor armature) {
      super(transitionTime, postDelay, path, armature);
      this.newTimePair(0.0F, Float.MAX_VALUE).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(false)).addState(EntityState.CAN_SWITCH_HAND_ITEM, Boolean.valueOf(false)).addState(EntityState.CAN_USE_ITEM, Boolean.valueOf(false));
   }

   public void tick(LivingEntityPatch entitypatch) {
      super.tick(entitypatch);
      if(entitypatch instanceof EnemyPatch) {
         EnemyPatch serverPlayerPatch = (EnemyPatch)entitypatch;
         ((EnemyEntity)serverPlayerPatch.getOriginal()).setStopEnergyRecoverTick(30);
         ((EnemyEntity)serverPlayerPatch.getOriginal()).setKnockdownTick(5);
      }

      if(entitypatch instanceof TDEServerPlayerPatch) {
         TDEServerPlayerPatch serverPlayerPatch1 = (TDEServerPlayerPatch)entitypatch;
         serverPlayerPatch1.stopEnergyRecoveryTime = 30;
      }

   }
}
