package com.merlin204.tde.epicfight.animations;

import com.google.common.collect.Sets;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.AttackPhaseProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.StaticAnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.BasicAttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.AttackAnimation.JointColliderPair;
import yesman.epicfight.api.animation.types.AttackAnimation.Phase;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.HitEntityList.Priority;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class TDEAttackAnimation extends BasicAttackAnimation {

   private final float play_speed;
   private final float damageMulti;


   public TDEAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationAccessor accessor, AssetAccessor armature, float play_speed, float damageMulti) {
      super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
      this.play_speed = play_speed;
      this.damageMulti = damageMulti;
      this.addProperty(StaticAnimationProperty.POSE_MODIFIER, (Object)null);
      this.addProperty(ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
   }

   public TDEAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, float play_speed, float damageMulti, TDEAttackAnimation.TDEPhase ... phases) {
      super(transitionTime, accessor, armature, phases);
      this.play_speed = play_speed;
      this.damageMulti = damageMulti;
      this.addProperty(StaticAnimationProperty.POSE_MODIFIER, (Object)null);
      this.addProperty(ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
   }

   public TDEAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, float damageMulti, TDEAttackAnimation.TDEPhase ... phases) {
      super(transitionTime, accessor, armature, phases);
      this.damageMulti = damageMulti;
      this.play_speed = 1.0F;
      this.addProperty(StaticAnimationProperty.POSE_MODIFIER, (Object)null);
      this.addProperty(ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
   }

   public TDEAttackAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature, TDEAttackAnimation.TDEPhase ... phases) {
      super(transitionTime, accessor, armature, phases);
      this.damageMulti = 1.0F;
      this.play_speed = 1.0F;
      this.addProperty(StaticAnimationProperty.POSE_MODIFIER, (Object)null);
      this.addProperty(ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
   }

   public TDEAttackAnimation(float convertTime, String path, AssetAccessor armature, float play_speed, float damageMulti, TDEAttackAnimation.TDEPhase ... phases) {
      super(convertTime, path, armature, phases);
      this.play_speed = play_speed;
      this.damageMulti = damageMulti;
      this.addProperty(StaticAnimationProperty.POSE_MODIFIER, (Object)null);
      this.addProperty(ActionAnimationProperty.CANCELABLE_MOVE, Boolean.valueOf(true));
   }

   public void begin(LivingEntityPatch entitypatch) {
      super.begin(entitypatch);
      entitypatch.getCurrenltyAttackedEntities().clear();
      entitypatch.getCurrenltyHurtEntities().clear();
      Phase[] var2 = this.phases;
      int var3 = var2.length;

      for(int var4 = 0; var4 < var3; ++var4) {
         Phase phase = var2[var4];
         if(phase instanceof TDEAttackAnimation.TDEPhase) {
            TDEAttackAnimation.TDEPhase tdePhase = (TDEAttackAnimation.TDEPhase)phase;
            tdePhase.resetAttackRecord(entitypatch);
         }
      }

   }

   protected void attackTick(LivingEntityPatch entitypatch, AssetAccessor animation) {
      AnimationPlayer player = entitypatch.getAnimator().getPlayerFor(this.getAccessor());
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      EntityState prevState = ((DynamicAnimation)animation.get()).getState(entitypatch, prevElapsedTime);
      EntityState state = ((DynamicAnimation)animation.get()).getState(entitypatch, elapsedTime);
      List activePhases = this.getActivePhases(elapsedTime);
      Iterator var9 = activePhases.iterator();

      while(var9.hasNext()) {
         Phase phase = (Phase)var9.next();
         if(prevElapsedTime < phase.start && elapsedTime >= phase.start && phase instanceof TDEAttackAnimation.TDEPhase) {
            TDEAttackAnimation.TDEPhase mobpatch = (TDEAttackAnimation.TDEPhase)phase;
            mobpatch.resetAttackRecord(entitypatch);
         }

         if(state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch1 = (MobPatch)entitypatch;
            ((Mob)mobpatch1.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0F;
            LivingEntity target = entitypatch.getTarget();
            if(target != null) {
               entitypatch.rotateTo(target, entitypatch.getYRotLimit(), false);
            }
         }

         if(prevState.attacking() || state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2) {
            if(!prevState.attacking() || (prevElapsedTime < phase.start || prevElapsedTime >= phase.end) && (state.attacking() || prevState.getLevel() <= 2 && state.getLevel() > 2)) {
               entitypatch.playSound(this.getSwingSound(entitypatch, phase), 0.0F, 0.0F);
               entitypatch.removeHurtEntities();
            }

            this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
         }
      }

   }

   protected void hurtCollidingEntities(LivingEntityPatch entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, Phase phase) {
      LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
      if(prevElapsedTime < phase.start && elapsedTime >= phase.start) {
         entitypatch.getCurrenltyAttackedEntities().clear();
         entitypatch.getCurrenltyHurtEntities().clear();
         if(phase instanceof TDEAttackAnimation.TDEPhase) {
            TDEAttackAnimation.TDEPhase phasePrevTime = (TDEAttackAnimation.TDEPhase)phase;
            phasePrevTime.resetAttackRecord(entitypatch);
         }
      }

      float phasePrevTime1 = Math.max(prevElapsedTime, phase.start);
      float phaseCurrentTime = Math.min(elapsedTime, phase.end);
      float phasePreDelay = phase.start + phase.preDelay;
      float phaseContact = phase.start + phase.contact;
      if(phaseCurrentTime >= phasePreDelay && phasePrevTime1 < phaseContact) {
         List list = phase.getCollidingEntities(entitypatch, this, phasePrevTime1, phaseCurrentTime, this.getPlaySpeed(entitypatch, this));
         if(!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, (Priority)phase.getProperty(AttackPhaseProperty.HIT_PRIORITY).orElse(Priority.DISTANCE));
            boolean maxStrikes = true;

            while(hitEntities.next()) {
               Entity target = hitEntities.getEntity();
               LivingEntity trueEntity = this.getTrueEntity(target);
               boolean canAttack = trueEntity != null && trueEntity.m_6084_() && !entitypatch.getCurrenltyAttackedEntities().contains(trueEntity) && !entitypatch.isTargetInvulnerable(target);
               if(phase instanceof TDEAttackAnimation.TDEPhase) {
                  TDEAttackAnimation.TDEPhase damagesource = (TDEAttackAnimation.TDEPhase)phase;
                  canAttack = canAttack && damagesource.tryAttack(trueEntity);
               }

               if(entitypatch instanceof EnemyPatch && target instanceof EnemyEntity) {
                  canAttack = false;
               }

               if(canAttack && entity.m_142582_(target)) {
                  TDEDamageSource damagesource1 = this.getEpicFightDamageSource(entitypatch, target, phase);
                  int prevInvulTime = target.f_19802_;
                  target.f_19802_ = 0;
                  AttackResult attackResult = entitypatch.attack(damagesource1, target, phase.hand);
                  target.f_19802_ = prevInvulTime;
                  if(attackResult.resultType.dealtDamage()) {
                     TDEAnimationUtils.shakeCameraForNearbyPlayers(entity.m_9236_(), target.m_20182_(), 3.0D, 20, (float)(damagesource1.getImpactLevel() * 2), 0.5F);
                     if(target instanceof EnemyEntity) {
                        EnemyEntity enemyPatch = (EnemyEntity)target;
                        if(!enemyPatch.isGuarding()) {
                           enemyPatch.getEnemyPatch().playHitAnimation(damagesource1);
                        }
                     }

                     if(entitypatch instanceof EnemyPatch) {
                        EnemyPatch enemyPatch1 = (EnemyPatch)entitypatch;
                        ((EnemyEntity)enemyPatch1.getOriginal()).atkEvent(enemyPatch1.getOriginal(), target);
                     }

                     target.m_9236_().m_6263_((Player)null, target.m_20185_(), target.m_20186_(), target.m_20189_(), this.getHitSound(entitypatch, phase), target.m_5720_(), 1.0F, 1.0F);
                     this.spawnHitParticle((ServerLevel)target.m_9236_(), entitypatch, target, phase);
                  }

                  entitypatch.getCurrenltyAttackedEntities().add(trueEntity);
                  if(attackResult.resultType.shouldCount()) {
                     entitypatch.getCurrenltyHurtEntities().add(trueEntity);
                  }
               }
            }
         }

      }
   }

   public float getPlaySpeed(LivingEntityPatch entitypatch, DynamicAnimation animation) {
      AnimationPlayer player = entitypatch.getAnimator().getPlayerFor(this.getAccessor());
      float prevElapsedTime = player.getPrevElapsedTime();
      float elapsedTime = player.getElapsedTime();
      LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
      List activePhases = this.getActivePhases(elapsedTime);
      Iterator var8 = activePhases.iterator();

      List list;
      do {
         if(!var8.hasNext()) {
            return this.play_speed;
         }

         Phase phase = (Phase)var8.next();
         float phasePrevTime = Math.max(prevElapsedTime, phase.start);
         float phaseCurrentTime = Math.min(elapsedTime, phase.end);
         float phasePreDelay = phase.start + phase.preDelay;
         float phaseContact = phase.start + phase.contact;
         if(phaseCurrentTime < phasePreDelay || phasePrevTime >= phaseContact) {
            return this.play_speed;
         }

         list = phase.getCollidingEntities(entitypatch, this, phasePrevTime, phaseCurrentTime, this.play_speed);
      } while(list.isEmpty() || !entitypatch.getEntityState().attacking());

      return this.play_speed * 0.6F;
   }

   protected void bindPhaseState(Phase phase) {
      float preDelay = phase.preDelay;
      this.stateSpectrumBlueprint.newTimePair(0.0F, preDelay).addState(EntityState.PHASE_LEVEL, Integer.valueOf(1)).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_SKILL_EXECUTION, Boolean.valueOf(false)).newTimePair(phase.start, phase.recovery + 0.1F).addState(EntityState.MOVEMENT_LOCKED, Boolean.valueOf(true)).addState(EntityState.UPDATE_LIVING_MOTION, Boolean.valueOf(false)).newTimePair(phase.start, phase.recovery).addState(EntityState.CAN_BASIC_ATTACK, Boolean.valueOf(false)).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, Boolean.valueOf(true)).newTimePair(phase.antic, phase.end).addState(EntityState.TURNING_LOCKED, Boolean.valueOf(true)).newTimePair(preDelay, phase.contact).addState(EntityState.ATTACKING, Boolean.valueOf(true)).addState(EntityState.PHASE_LEVEL, Integer.valueOf(2)).newTimePair(phase.contact, phase.end).addState(EntityState.PHASE_LEVEL, Integer.valueOf(3));
   }

   public TDEDamageSource getEpicFightDamageSource(DamageSource originalSource, LivingEntityPatch entitypatch, Entity target, Phase phase) {
      if(phase == null) {
         phase = this.getPhaseByTime(entitypatch.getAnimator().getPlayerFor(this.getAccessor()).getElapsedTime());
      }

      TDEDamageSource extendedSource;
      if(originalSource instanceof TDEDamageSource) {
         TDEDamageSource phaseImpactLevelMulti = (TDEDamageSource)originalSource;
         extendedSource = phaseImpactLevelMulti;
      } else {
         extendedSource = (new TDEDamageSource(originalSource)).setAnimation(this.getAccessor());
      }

      int phaseImpactLevelMulti1 = 1;
      if(phase instanceof TDEAttackAnimation.TDEPhase) {
         TDEAttackAnimation.TDEPhase damageModifier = (TDEAttackAnimation.TDEPhase)phase;
         phaseImpactLevelMulti1 = damageModifier.phaseImpactLevelMulti;
         extendedSource.setAtkDirection(damageModifier.atkDirection);
      }

      ValueModifier damageModifier1 = ValueModifier.multiplier(this.damageMulti);
      extendedSource.setDamageModifier(damageModifier1);
      int a = 0;
      Item var10 = ((LivingEntity)entitypatch.getOriginal()).m_21120_(phase.hand).m_41720_();
      if(var10 instanceof TDEWeaponItem) {
         TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)var10;
         a = tdeWeaponItem.getProperties().getImpactBonus();
      }

      extendedSource.setImpactLevel(phaseImpactLevelMulti1 + a);
      phase.getProperty(AttackPhaseProperty.SOURCE_TAG).ifPresent(extendedSource);
      phase.getProperty(AttackPhaseProperty.EXTRA_DAMAGE).ifPresent(extendedSource);
      phase.getProperty(AttackPhaseProperty.SOURCE_LOCATION_PROVIDER);
      extendedSource.ifPresent(entitypatch);
      phase.getProperty(AttackPhaseProperty.SOURCE_LOCATION_PROVIDER);
      entitypatch.ifPresentOrElse(extendedSource, entitypatch);
      return extendedSource;
   }

   public TDEDamageSource getEpicFightDamageSource(LivingEntityPatch entitypatch, Entity target, Phase phase) {
      return this.getEpicFightDamageSource(entitypatch.getDamageSource(this.getAccessor(), phase.hand), entitypatch, target, phase);
   }

   @OnlyIn(Dist.CLIENT)
   public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch entitypatch, float playbackTime, float partialTicks) {
      AnimationPlayer animPlayer = entitypatch.getAnimator().getPlayerFor(this.getAccessor());
      float prevElapsedTime = animPlayer.getPrevElapsedTime();
      float elapsedTime = animPlayer.getElapsedTime();
      List activePhases = this.getActivePhases(playbackTime);
      Iterator var10 = activePhases.iterator();

      while(var10.hasNext()) {
         Phase phase = (Phase)var10.next();
         JointColliderPair[] colliders = phase.getColliders();
         if(colliders != null) {
            JointColliderPair[] var13 = colliders;
            int var14 = colliders.length;

            for(int var15 = 0; var15 < var14; ++var15) {
               JointColliderPair colliderInfo = var13[var15];
               Collider collider = (Collider)colliderInfo.getSecond();
               if(collider == null) {
                  collider = entitypatch.getColliderMatching(phase.hand);
               }

               float phaseStart = phase.start;
               float phaseEnd = phase.end;
               float phasePrevTime = Math.max(prevElapsedTime, phaseStart);
               float phaseCurrentTime = Math.min(elapsedTime, phaseEnd);
               collider.draw(poseStack, buffer, entitypatch, this, (Joint)colliderInfo.getFirst(), phasePrevTime, phaseCurrentTime, partialTicks, this.getPlaySpeed(entitypatch, this));
            }
         }
      }

   }

   public List getActivePhases(float elapsedTime) {
      ArrayList activePhases = new ArrayList();
      Phase[] var3 = this.phases;
      int var4 = var3.length;

      for(int var5 = 0; var5 < var4; ++var5) {
         Phase phase = var3[var5];
         if(elapsedTime >= phase.start && elapsedTime < phase.end) {
            activePhases.add(phase);
         }
      }

      return activePhases;
   }

   // $FF: synthetic method
   private static void lambda$getEpicFightDamageSource$4(TDEDamageSource extendedSource, LivingEntityPatch entitypatch) {
      extendedSource.setInitialPosition(((LivingEntity)entitypatch.getOriginal()).m_20182_());
   }

   // $FF: synthetic method
   private static void lambda$getEpicFightDamageSource$3(TDEDamageSource extendedSource, LivingEntityPatch entitypatch, Function opt) {
      extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch));
   }

   // $FF: synthetic method
   private static void lambda$getEpicFightDamageSource$2(TDEDamageSource extendedSource, LivingEntityPatch entitypatch, Function opt) {
      extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch));
   }

   // $FF: synthetic method
   private static void lambda$getEpicFightDamageSource$1(TDEDamageSource extendedSource, Set opt) {
      Objects.requireNonNull(extendedSource);
      Objects.requireNonNull(extendedSource);
      opt.forEach(extendedSource);
   }

   // $FF: synthetic method
   private static void lambda$getEpicFightDamageSource$0(TDEDamageSource extendedSource, Set opt) {
      Objects.requireNonNull(extendedSource);
      Objects.requireNonNull(extendedSource);
      opt.forEach(extendedSource);
   }

   public static class TDEPhase extends Phase {

      public final int phaseImpactLevelMulti;
      public final AtkDirection atkDirection;
      private WeakReference currentEntityPatch;
      private Set attackedEntities;


      public void resetAttackRecord(LivingEntityPatch entitypatch) {
         if(this.currentEntityPatch != null && this.currentEntityPatch.get() == entitypatch) {
            this.attackedEntities.clear();
         } else {
            this.currentEntityPatch = new WeakReference(entitypatch);
            this.attackedEntities = new HashSet();
         }

      }

      public boolean tryAttack(Entity entity) {
         return this.attackedEntities == null?false:this.attackedEntities.add(entity);
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, int phaseImpactLevelMulti, AtkDirection atkDirection, Joint joint, Collider collider) {
         super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
         this.phaseImpactLevelMulti = phaseImpactLevelMulti;
         this.atkDirection = atkDirection;
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, int phaseImpactLevelMulti, Joint joint, Collider collider) {
         super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
         this.phaseImpactLevelMulti = phaseImpactLevelMulti;
         this.atkDirection = AtkDirection.MIDDLE;
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, AtkDirection atkDirection, Joint joint, Collider collider) {
         super(start, antic, preDelay, contact, recovery, end, hand, joint, collider);
         this.phaseImpactLevelMulti = 0;
         this.atkDirection = atkDirection;
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, int phaseImpactLevelMulti, AtkDirection atkDirection, JointColliderPair ... colliders) {
         super(start, antic, preDelay, contact, recovery, end, hand, colliders);
         this.phaseImpactLevelMulti = phaseImpactLevelMulti;
         this.atkDirection = atkDirection;
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, AtkDirection atkDirection, JointColliderPair ... colliders) {
         super(start, antic, preDelay, contact, recovery, end, hand, colliders);
         this.phaseImpactLevelMulti = 1;
         this.atkDirection = atkDirection;
      }

      public TDEPhase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, int phaseImpactLevelMulti, JointColliderPair ... colliders) {
         super(start, antic, preDelay, contact, recovery, end, hand, colliders);
         this.phaseImpactLevelMulti = phaseImpactLevelMulti;
         this.atkDirection = AtkDirection.MIDDLE;
      }

      public List getCollidingEntities(LivingEntityPatch entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float attackSpeed) {
         HashSet entities = Sets.newHashSet();
         JointColliderPair[] var7 = this.colliders;
         int var8 = var7.length;

         for(int var9 = 0; var9 < var8; ++var9) {
            JointColliderPair colliderInfo = var7[var9];
            Collider collider = (Collider)colliderInfo.getSecond();
            if(collider == null) {
               collider = entitypatch.getColliderMatching(this.hand);
            }

            float phasePrev = Math.max(prevElapsedTime, this.start);
            float phaseCurrent = Math.min(elapsedTime, this.end);
            entities.addAll(collider.updateAndSelectCollideEntity(entitypatch, animation, phasePrev, phaseCurrent, (Joint)colliderInfo.getFirst(), attackSpeed));
         }

         return new ArrayList(entities);
      }
   }
}
