package com.merlin204.tde.epicfight.animations;

import com.merlin204.tde.entity.boss.B1.B1Animations;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.property.AnimationProperty.ActionAnimationProperty;
import yesman.epicfight.api.animation.property.AnimationProperty.AttackAnimationProperty;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RotatingAnimation extends ActionAnimation {

   private float startRot = 0.0F;


   public RotatingAnimation(float transitionTime, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, accessor, armature);
      this.addProperty(ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, Boolean.valueOf(false));
      this.addProperty(AttackAnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(false));
      this.addProperty(AttackAnimationProperty.MOVE_VERTICAL, Boolean.valueOf(false));
   }

   public RotatingAnimation(float transitionTime, float postDelay, AnimationAccessor accessor, AssetAccessor armature) {
      super(transitionTime, accessor, armature);
      this.addProperty(ActionAnimationProperty.REMOVE_DELTA_MOVEMENT, Boolean.valueOf(false));
      this.addProperty(AttackAnimationProperty.FIXED_MOVE_DISTANCE, Boolean.valueOf(false));
      this.addProperty(AttackAnimationProperty.MOVE_VERTICAL, Boolean.valueOf(false));
   }

   public void begin(LivingEntityPatch entityPatch) {
      super.begin(entityPatch);
      if(entityPatch instanceof EnemyPatch) {
         EnemyPatch enemyPatch = (EnemyPatch)entityPatch;
         this.startRot = enemyPatch.getRootYRot();
         ((EnemyEntity)enemyPatch.getOriginal()).setRotating(true);
         ((EnemyEntity)enemyPatch.getOriginal()).updateYRotBeforeRotation();
      }

   }

   public void tick(LivingEntityPatch entitypatch) {
      super.tick(entitypatch);
      if(entitypatch instanceof EnemyPatch) {
         EnemyPatch enemyPatch = (EnemyPatch)entitypatch;
         enemyPatch.setYRot(((EnemyEntity)enemyPatch.getOriginal()).getCorrectYRot(1.0F) + enemyPatch.getRootYRot() - this.startRot);
         ((EnemyEntity)enemyPatch.getOriginal()).f_20883_ = enemyPatch.getYRot();
      }

   }

   public void end(LivingEntityPatch entityPatch, AssetAccessor nextAnimation, boolean isEnd) {
      super.end(entityPatch, nextAnimation, isEnd);
      if(entityPatch instanceof EnemyPatch) {
         EnemyPatch enemyPatch = (EnemyPatch)entityPatch;
         ((EnemyEntity)enemyPatch.getOriginal()).setRotating(false);
         enemyPatch.reserveAnimation(B1Animations.B1_IDLE);
      }

   }
}
