package com.merlin204.tde.entity.xuan;

import com.merlin204.tde.entity.skill.other.ArrowAnimations;
import com.merlin204.tde.entity.xuan.XEntity;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class XPatch extends MobPatch {

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, ArrowAnimations.IDLE);
   }

   public void updateMotion(boolean b) {
      this.currentLivingMotion = LivingMotions.IDLE;
   }

   public AssetAccessor getHitAnimation(StunType stunType) {
      return null;
   }

   public boolean applyStun(StunType stunType, float stunTime) {
      return false;
   }

   public void onConstructed(XEntity entity) {
      this.original = entity;
      this.armature = entity.getArmature();
      Animator animator = EpicFightSharedConstants.getAnimator(this);
      this.animator = animator;
      this.initAnimator(animator);
      animator.postInit();
   }
}
