package com.merlin204.tde.entity.vfx.soulfire;

import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.client.hud.TDEHud;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.entity.vfx.soulfire.SoulFireEntity;
import com.merlin204.tde.util.TDEAbilityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import yesman.epicfight.api.data.reloader.SkillManager;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;

public class BossSoulFireEntity extends SoulFireEntity {

   private int deathTick = 0;
   protected static final EntityDataAccessor SKILL_ID = SynchedEntityData.m_135353_(BossSoulFireEntity.class, EntityDataSerializers.f_135030_);


   public BossSoulFireEntity(EntityType pEntityType, Level pLevel) {
      super(pEntityType, pLevel);
   }

   public BossSoulFireEntity(EntityType pEntityType, Level pLevel, Float soulFireAmount) {
      super(pEntityType, pLevel, "photon:soulfire/soulfire_3", soulFireAmount);
   }

   public BossSoulFireEntity(EntityType pEntityType, Level pLevel, Float soulFireAmount, String skillId) {
      super(pEntityType, pLevel, "photon:soulfire/soulfire_3", soulFireAmount);
      this.f_19804_.m_135381_(SKILL_ID, skillId);
   }

   protected void m_8097_() {
      super.m_8097_();
      this.m_20088_().m_135372_(SKILL_ID, "");
   }

   public void m_7380_(CompoundTag tag) {
      super.m_7380_(tag);
      tag.m_128359_("skillId", (String)this.f_19804_.m_135370_(SKILL_ID));
   }

   public void m_7378_(CompoundTag tag) {
      super.m_7378_(tag);
      if(tag.m_128441_("skillId")) {
         this.f_19804_.m_135381_(SKILL_ID, tag.m_128461_("skillId"));
      }

   }

   public void giveSkill(Player player) {
      System.out.println(player.m_9236_());
      Skill skill;
      CapabilitySkill skills;
      if(player.m_9236_().f_46443_) {
         if(SkillManager.getSkill((String)this.f_19804_.m_135370_(SKILL_ID)) != null) {
            skill = SkillManager.getSkill((String)this.f_19804_.m_135370_(SKILL_ID));
            TDELocalPlayerPatch tdeServerPlayerPatch = (TDELocalPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDELocalPlayerPatch.class);
            skills = tdeServerPlayerPatch.getSkillCapability();
            skills.addLearnedSkill(skill);
            if(TDEHud.instance != null) {
               TDEHud.instance.showLearnSkill(skill);
            }
         }
      } else if(SkillManager.getSkill((String)this.f_19804_.m_135370_(SKILL_ID)) != null) {
         skill = SkillManager.getSkill((String)this.f_19804_.m_135370_(SKILL_ID));
         TDEServerPlayerPatch tdeServerPlayerPatch1 = (TDEServerPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDEServerPlayerPatch.class);
         skills = tdeServerPlayerPatch1.getSkillCapability();
         skills.addLearnedSkill(skill);
      }

   }

   public void m_8119_() {
      super.m_8119_();
      if(((Float)this.f_19804_.m_135370_(SOUL_AMOUNT)).floatValue() == 0.0F) {
         ++this.deathTick;
         if(this.deathTick == 2) {
            this.m_146870_();
         }
      }

   }

   public void transferSoulFire(Player player) {
      float amount = ((Float)this.f_19804_.m_135370_(SOUL_AMOUNT)).floatValue();
      if(!player.m_9236_().f_46443_) {
         TDEAbilityUtils.addAbility(AbilityType.SOUL, player, amount);
         FX fx = FXHelper.getFX(ResourceLocation.parse("photon:soulfire/soulfire_3_boom"));
         BlockEffect blockEffect = new BlockEffect(fx, this.m_9236_(), this.m_20097_());
         blockEffect.setForcedDeath(true);
         blockEffect.setAllowMulti(true);
         blockEffect.start();
         this.f_19804_.m_135381_(SOUL_AMOUNT, Float.valueOf(0.0F));
      }

   }

   public void flyToPlayer(Player player) {
   }

}
