package com.merlin204.tde.entity.skill.se_1;

import com.lowdragmc.photon.client.fx.BlockEffect;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.effect.TDEMobEffects;
import com.merlin204.tde.entity.TDEEntities;
import com.merlin204.tde.entity.skill.SkillEntity;
import com.merlin204.tde.entity.skill.se_1.SoulGroundFlameEntity;
import com.merlin204.tde.photon.PosEffect;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockPos.MutableBlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Entity.RemovalReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ClipContext.Block;
import net.minecraft.world.level.ClipContext.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.HitResult.Type;

public class SoulFireBallEntity extends SkillEntity {

   private static final double BASE_SPEED = 0.6000000238418579D;
   private static final double TRACKING_STRENGTH = 0.03D;
   private static final double GRAVITY = 0.005D;
   private static final int MAX_LIFETIME = 300;
   private static final float DAMAGE_RADIUS = 2.0F;
   private static final float BASE_DAMAGE = 10.0F;
   private Vec3 firstTargetPos = null;
   private float damageAmount = 10.0F;
   private int ignoreOwnerTicks = 5;
   private LivingEntity target;


   public SoulFireBallEntity(EntityType entityType, Level level) {
      super(entityType, level);
   }

   public SoulFireBallEntity(EntityType entityType, LivingEntity owner, Level level) {
      super(entityType, owner);
      this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.1D, owner.m_20189_());
      Vec3 look = owner.m_20154_();
      this.m_20256_(look.m_82490_(0.6000000238418579D));
   }

   public SoulFireBallEntity(EntityType entityType, LivingEntity owner, Vec3 TargetPos, Level level) {
      super(entityType, owner);
      this.firstTargetPos = TargetPos;
   }

   public void setDamageAmount(float damage) {
      this.damageAmount = damage;
   }

   public void m_8119_() {
      super.m_8119_();
      if(this.f_19797_ > 300) {
         this.explode();
         this.m_146870_();
      } else {
         if(this.ignoreOwnerTicks > 0) {
            --this.ignoreOwnerTicks;
         }

         Vec3 oldPos = this.m_20182_();
         Vec3 movement = this.m_20184_();
         Vec3 newPos = oldPos.m_82549_(movement);
         this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
         this.checkCollisions(oldPos);
         Vec3 newMovement = movement.m_82520_(0.0D, -0.005D, 0.0D);
         Vec3 fx;
         Vec3 lastTickPos;
         if(this.firstTargetPos != null) {
            if(this.m_20182_().m_82554_(this.firstTargetPos) < 0.5D) {
               this.firstTargetPos = null;
            } else {
               fx = this.firstTargetPos.m_82546_(this.m_20182_()).m_82541_();
               newMovement = newMovement.m_82490_(0.97D).m_82549_(fx.m_82490_(0.018000000715255735D));
            }
         } else if(this.getOwnerPatch() != null) {
            this.target = this.getOwnerPatch().getTarget();
            if(this.target != null && this.target.m_6084_()) {
               fx = this.target.m_20182_().m_82520_(0.0D, (double)(this.target.m_20206_() / 2.0F), 0.0D);
               lastTickPos = fx.m_82546_(this.m_20182_()).m_82541_();
               newMovement = newMovement.m_82490_(0.97D).m_82549_(lastTickPos.m_82490_(0.018000000715255735D));
            }
         }

         this.m_20256_(newMovement);
         if(this.m_9236_().f_46443_ && this.m_6084_()) {
            FX var9 = FXHelper.getFX(new ResourceLocation("photon:skill/se_1/soulfireball"));
            lastTickPos = new Vec3(this.f_19790_, this.f_19791_, this.f_19792_);
            Vec3 step = this.m_20182_().m_82546_(lastTickPos).m_82490_(0.30000001192092896D);

            for(int i = 1; i < 4; ++i) {
               (new PosEffect(var9, this.m_9236_(), this, lastTickPos.m_82549_(step), 8, false, true)).start();
            }
         }

      }
   }

   private void checkCollisions(Vec3 startPos) {
      Vec3 endPos = this.m_20182_();
      endPos.m_82546_(startPos);
      EntityHitResult entityHit = this.findEntityCollision(startPos, endPos);
      if(entityHit != null) {
         this.onEntityCollision(entityHit);
      } else {
         BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, Block.COLLIDER, Fluid.NONE, this));
         if(blockHit.m_6662_() != Type.MISS) {
            this.onBlockCollision(blockHit);
         }

      }
   }

   private EntityHitResult findEntityCollision(Vec3 startPos, Vec3 endPos) {
      AABB collisionBox = this.m_20191_().m_82369_(this.m_20184_());
      Iterator var4 = this.m_9236_().m_45933_(this, collisionBox).iterator();

      while(var4.hasNext()) {
         Entity entity = (Entity)var4.next();
         if(entity != this.getOwner() && entity != this) {
            AABB entityBox = entity.m_20191_().m_82400_(1.0D);
            Optional collisionPoint = entityBox.m_82371_(startPos, endPos);
            if(collisionPoint.isPresent()) {
               return new EntityHitResult(entity, (Vec3)collisionPoint.get());
            }
         }
      }

      return null;
   }

   private void onEntityCollision(EntityHitResult hitResult) {
      if(hitResult.m_82443_() != this.getOwner()) {
         this.createGroundFlame(hitResult.m_82450_());
         this.explode();
         this.m_146870_();
      }
   }

   private void onBlockCollision(BlockHitResult hitResult) {
      this.createGroundFlame(hitResult.m_82450_());
      this.explode();
      this.m_146870_();
   }

   private void createGroundFlame(Vec3 position) {
      if(!this.m_9236_().f_46443_) {
         double x = position.f_82479_;
         double y = position.f_82480_;
         double z = position.f_82481_;
         MutableBlockPos mutablePos = new MutableBlockPos(x, y, z);
         Level level = this.m_9236_();

         while(mutablePos.m_123342_() < level.m_151558_() && level.m_8055_(mutablePos).m_280296_()) {
            mutablePos.m_122184_(0, 1, 0);
         }

         if(mutablePos.m_123342_() < level.m_151558_()) {
            y = (double)mutablePos.m_123342_();
         } else {
            y += 0.1D;
         }

         SoulGroundFlameEntity groundFlame = new SoulGroundFlameEntity((EntityType)TDEEntities.SOUL_GROUND_FLAME.get(), this.getOwner(), level, x, y, z);
         level.m_7967_(groundFlame);
         level.m_6263_((Player)null, x, y, z, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0F, 0.8F);
      }
   }

   public void m_142687_(RemovalReason pReason) {
      super.m_142687_(pReason);
   }

   private void explode() {
      if(!this.m_9236_().f_46443_) {
         FX fx = FXHelper.getFX(new ResourceLocation("photon:skill/se_1/soulfireball_boom"));
         if(fx != null) {
            BlockPos damageArea = this.m_20097_();
            BlockEffect blockEffect = new BlockEffect(fx, this.m_9236_(), damageArea);
            blockEffect.setOffset(0.0D, 0.0D, 0.0D);
            blockEffect.setAllowMulti(true);
            blockEffect.setForcedDeath(true);
            blockEffect.start();
         }

         this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 4.0F, (1.0F + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2F) * 0.7F);
         AABB damageArea1 = this.m_20191_().m_82400_(2.0D);
         Iterator blockEffect1 = this.m_9236_().m_45976_(LivingEntity.class, damageArea1).iterator();

         while(blockEffect1.hasNext()) {
            LivingEntity entity = (LivingEntity)blockEffect1.next();
            if(entity != this.getOwner()) {
               double dist = (double)this.m_20270_(entity);
               if(dist < 2.0D) {
                  float damage = this.damageAmount * (1.0F - (float)(dist / 2.0D));
                  MobEffectInstance effect = entity.m_21124_((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get());
                  MobEffectInstance newEffect;
                  if(effect != null) {
                     newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, effect.m_19564_() + 1, false, false, true);
                     if(effect.m_19564_() >= 9) {
                        newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, 9, false, false, true);
                     }

                     entity.m_7292_(newEffect);
                  } else {
                     newEffect = new MobEffectInstance((MobEffect)TDEMobEffects.SOUL_FIRE_INFLICTION.get(), 100, 0, false, false, true);
                     entity.m_7292_(newEffect);
                  }

                  entity.m_6469_(entity.m_269291_().m_269036_(this, this.getOwner()), damage);
               }
            }
         }

      }
   }

   public boolean m_6087_() {
      return false;
   }

   public boolean m_5829_() {
      return false;
   }

   public boolean m_6051_() {
      return false;
   }
}
