package com.merlin204.tde.entity.skill.other;

import com.merlin204.tde.entity.skill.SkillEntityPatch;
import com.merlin204.tde.entity.skill.other.ArrowAnimations;
import com.merlin204.tde.entity.skill.other.ArrowEntity;
import com.merlin204.tde.util.TDEAnimationUtils;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;

public class ArrowEntityPatch extends SkillEntityPatch {

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      super.poseTick(animation, pose, elapsedTime, partialTicks);
      TDEAnimationUtils.joinRotationInPose(pose, this, "Root", ((ArrowEntity)this.original).m_146909_(), 0.0F, 0.0F);
   }

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, ArrowAnimations.IDLE);
   }

   public void updateMotion(boolean considerInaction) {
      this.currentLivingMotion = LivingMotions.IDLE;
   }
}
