package com.merlin204.tde.entity.skill.other;

import com.merlin204.tde.entity.skill.SkillEntity;
import com.merlin204.tde.entity.skill.other.ArrowAnimations;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier.Builder;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ClipContext.Block;
import net.minecraft.world.level.ClipContext.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.HitResult.Type;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;

public class ArrowEntity extends SkillEntity {

   private static final double ATTACK_RADIUS = 1.0D;
   private boolean initialVelocityApplied = false;
   private float flightSpeed = 1.5F;
   private boolean hasCollided = false;


   public ArrowEntity(EntityType entityType, LivingEntity owner) {
      super(entityType, owner);
      this.m_20242_(true);
      this.f_19794_ = true;
   }

   public ArrowEntity(EntityType entityType, Level level) {
      super(entityType, level);
      this.m_20242_(true);
      this.f_19794_ = true;
   }

   @Nullable
   public AnimationAccessor getDefaultAnimation() {
      return ArrowAnimations.IDLE;
   }

   public void m_8119_() {
      super.m_8119_();
      if(this.m_9236_().f_46443_) {
         this.updateClientSide();
      } else {
         if(!this.initialVelocityApplied) {
            this.applyInitialVelocity();
            this.initialVelocityApplied = true;
         }

         this.moveEntity();
         if(!this.hasCollided) {
            this.checkCollisions();
         } else if(this.f_19797_ > 5) {
            this.m_146870_();
         }

         if(this.f_19797_ >= 200) {
            this.m_146870_();
         }

      }
   }

   private void updateClientSide() {
      Vec3 motion = this.m_20184_();
      Vec3 newPos = this.m_20182_().m_82549_(motion);
      this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
   }

   private void moveEntity() {
      Vec3 motion = this.m_20184_();
      Vec3 newPos = this.m_20182_().m_82549_(motion);
      this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
   }

   private void checkCollisions() {
      BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_()), Block.COLLIDER, Fluid.NONE, this));
      if(blockHit.m_6662_() != Type.MISS) {
         this.handleCollision();
      } else {
         AABB collisionBox = this.m_20191_().m_82369_(this.m_20184_());
         List entities = this.m_9236_().m_45933_(this, collisionBox);
         Iterator var4 = entities.iterator();

         while(var4.hasNext()) {
            Entity entity = (Entity)var4.next();
            if(entity instanceof LivingEntity) {
               LivingEntity target = (LivingEntity)entity;
               if(target != this && target != this.getOwner()) {
                  this.handleCollision();
                  this.attackEntity(target);
                  break;
               }
            }
         }

      }
   }

   private void handleCollision() {
      this.hasCollided = true;
      this.m_20256_(Vec3.f_82478_);
      this.playCollisionEffects();
   }

   private void applyInitialVelocity() {
      float yRotRad = this.m_146908_() * 0.017453292F;
      float xRotRad = this.m_146909_() * 0.017453292F;
      double motionX = -Math.sin((double)yRotRad) * Math.cos((double)xRotRad);
      double motionY = -Math.sin((double)xRotRad);
      double motionZ = Math.cos((double)yRotRad) * Math.cos((double)xRotRad);
      Vec3 motion = (new Vec3(motionX, motionY, motionZ)).m_82490_((double)this.flightSpeed);
      this.m_20256_(motion);
   }

   public void setFlightSpeed(float speed) {
      this.flightSpeed = speed;
   }

   public Armature getArmature() {
      // $FF: Couldn't be decompiled
   }

   public AssetAccessor getMesh() {
      // $FF: Couldn't be decompiled
   }

   public ResourceLocation getTexture() {
      return ResourceLocation.fromNamespaceAndPath("tde", "textures/entity/arrow/arrow_1.png");
   }

   private void attackEntity(LivingEntity target) {
      if(this.getOwner() != null) {
         this.getOwnerPatch().attack(this.getPatch().getDamageSource(Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND), target, InteractionHand.MAIN_HAND);
      } else {
         this.getPatch().attack(this.getPatch().getDamageSource(Animations.EMPTY_ANIMATION, InteractionHand.MAIN_HAND), target, InteractionHand.MAIN_HAND);
      }

   }

   private void playCollisionEffects() {
      this.m_5496_((SoundEvent)EpicFightSounds.BLADE_HIT.get(), 1.0F, 1.0F);
      Level var2 = this.m_9236_();
      if(var2 instanceof ServerLevel) {
         ServerLevel serverLevel = (ServerLevel)var2;
         serverLevel.m_8767_(ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, 0.2D, 0.2D, 0.2D, 0.1D);
      }

   }

   public void aimAtEntity(Entity target) {
      if(target != null) {
         Vec3 eyePos = this.m_146892_();
         Vec3 targetPos = target.m_146892_();
         Vec3 direction = targetPos.m_82546_(eyePos).m_82541_();
         double horizontalDistance = direction.m_165924_();
         float yRot = (float)(Mth.m_14136_(direction.f_82479_, direction.f_82481_) * -57.29577951308232D);
         float xRot = (float)(Mth.m_14136_(direction.f_82480_, horizontalDistance) * -57.29577951308232D);
         this.m_146922_(yRot);
         this.m_146926_(xRot);
         this.f_19859_ = yRot;
         this.f_19860_ = xRot;
      }
   }

   public static Builder createAttributes() {
      return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1.0D).m_22268_(Attributes.f_22281_, 0.0D);
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$getMesh$0(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }
}
