package com.merlin204.tde.entity.skill;

import com.merlin204.tde.entity.skill.SkillEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class SkillEntityPatch extends MobPatch {

   @Nullable
   private LivingEntityPatch ownerPatch;


   public SkillEntityPatch() {
   }

   public void onConstructed(SkillEntity entityIn) {
      this.original = entityIn;
      this.armature = entityIn.getArmature();
      Animator animator = EpicFightSharedConstants.getAnimator(this);
      this.animator = animator;
      this.initAnimator(animator);
      animator.postInit();
   }

   public void onJoinWorld(SkillEntity entity, EntityJoinLevelEvent event) {
      super.onJoinWorld(entity, event);
      if(this.isLogicalClient()) {
         this.getClientAnimator().playAnimation(((SkillEntity)this.original).getDefaultAnimation(), 0.0F);
      } else {
         this.playAnimationSynchronized(((SkillEntity)this.original).getDefaultAnimation(), 0.0F);
      }

   }

   public SkillEntityPatch(Faction faction) {
      super(faction);
   }

   public void updateMotion(boolean considerInaction) {
      if(considerInaction) {
         this.currentLivingMotion = LivingMotions.IDLE;
      }

   }

   public Armature getArmature() {
      return ((SkillEntity)this.original).getArmature();
   }

   public AssetAccessor getHitAnimation(StunType stunType) {
      return null;
   }

   @Nullable
   public LivingEntityPatch getOwnerPatch() {
      if(this.ownerPatch != null) {
         return this.ownerPatch;
      } else if(((SkillEntity)this.getOriginal()).getOwner() != null) {
         this.ownerPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(((SkillEntity)this.getOriginal()).getOwner(), LivingEntityPatch.class);
         return this.ownerPatch;
      } else {
         return null;
      }
   }

   public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
      return this.getOwnerPatch() != null && this.shouldUseOwnerAttack()?this.getOwnerPatch().attack(damageSource, target, hand):super.attack(damageSource, target, hand);
   }

   public boolean shouldUseOwnerAttack() {
      return true;
   }

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, ((SkillEntity)this.original).getIdleAnimation());
   }

   @Nullable
   public EpicFightDamageSource getEpicFightDamageSource() {
      return this.getOwnerPatch() != null?this.getOwnerPatch().getEpicFightDamageSource():super.getEpicFightDamageSource();
   }

   public EpicFightDamageSource getDamageSource(AnimationAccessor animation, InteractionHand hand) {
      return this.getOwnerPatch() != null?this.getOwnerPatch().getDamageSource(animation, hand):super.getDamageSource(animation, hand);
   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return this.getOwnerPatch() == null?super.getSwingSound(hand):this.getOwnerPatch().getSwingSound(hand);
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return this.getOwnerPatch() == null?super.getWeaponHitSound(hand):this.getOwnerPatch().getWeaponHitSound(hand);
   }

   public boolean isTargetInvulnerable(Entity entity) {
      if(entity.equals(((SkillEntity)this.getOriginal()).getOwner())) {
         return true;
      } else {
         if(entity instanceof SkillEntity) {
            SkillEntity artifactSpiritEntity = (SkillEntity)entity;
            if(this.getOwnerPatch() != null) {
               return ((LivingEntity)this.getOwnerPatch().getOriginal()).equals(artifactSpiritEntity.getOwner());
            }
         }

         return false;
      }
   }

   @OnlyIn(Dist.CLIENT)
   public boolean flashTargetIndicator(LocalPlayerPatch playerPatch) {
      return false;
   }
}
