package com.merlin204.tde.entity.skill;

import com.merlin204.tde.entity.TDEMeshEntity;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public abstract class SkillEntity extends Mob implements TDEMeshEntity {

   protected static final EntityDataAccessor DATA_OWNER_UUID = SynchedEntityData.m_135353_(SkillEntity.class, EntityDataSerializers.f_135041_);


   public SkillEntity(EntityType entityType, LivingEntity owner) {
      super(entityType, owner.m_9236_());
      this.tame(owner);
      this.m_20242_(true);
      this.f_19794_ = true;
      this.m_20242_(true);
   }

   public SkillEntity(EntityType entityType, Level level) {
      super(entityType, level);
      this.f_19794_ = true;
      this.m_20242_(true);
   }

   @Nullable
   public Armature getArmature() {
      return super.getArmature();
   }

   @Nullable
   public AssetAccessor getMesh() {
      return super.getMesh();
   }

   @Nullable
   public ResourceLocation getTexture() {
      return super.getTexture();
   }

   @Nullable
   public AnimationAccessor getDefaultAnimation() {
      return null;
   }

   @Nullable
   public AnimationAccessor getIdleAnimation() {
      return null;
   }

   protected void m_8097_() {
      super.m_8097_();
      this.f_19804_.m_135372_(DATA_OWNER_UUID, Optional.empty());
   }

   @Nullable
   public UUID getOwnerUUID() {
      return (UUID)((Optional)this.f_19804_.m_135370_(DATA_OWNER_UUID)).orElse((Object)null);
   }

   public void setOwnerUUID(@Nullable UUID pUuid) {
      this.f_19804_.m_135381_(DATA_OWNER_UUID, Optional.ofNullable(pUuid));
   }

   public void tame(LivingEntity livingEntity) {
      this.setOwnerUUID(livingEntity.m_20148_());
   }

   @Nullable
   public LivingEntity getOwner() {
      UUID uuid = this.getOwnerUUID();
      if(uuid != null) {
         Player player = this.m_9236_().m_46003_(uuid);
         if(player != null) {
            return player;
         }

         Level livingEntity = this.m_9236_();
         if(livingEntity instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            Entity var5 = serverLevel.m_8791_(uuid);
            LivingEntity var10000;
            if(var5 instanceof LivingEntity) {
               LivingEntity livingEntity1 = (LivingEntity)var5;
               var10000 = livingEntity1;
            } else {
               var10000 = null;
            }

            return var10000;
         }
      }

      return null;
   }

   public LivingEntityPatch getOwnerPatch() {
      return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(this.getOwner(), LivingEntityPatch.class);
   }

   public LivingEntityPatch getPatch() {
      return (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(this, LivingEntityPatch.class);
   }

   public EntityPatch getPatch(Class type) {
      return EpicFightCapabilities.getEntityPatch(this, type);
   }

   public void m_8119_() {
      super.m_8119_();
      this.f_19789_ = 0.0F;
   }

   public static AttributeSupplier getDefaultAttribute() {
      return Animal.m_21552_().m_22268_(Attributes.f_22276_, 19.899999618530273D).m_22268_(Attributes.f_22281_, 3.0D).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0D).m_22265_();
   }

   protected void moveToOwner(LivingEntity owner) {
      this.m_146922_(owner.f_20883_);
      this.m_5618_(owner.f_20883_);
      this.m_5616_(owner.f_20883_);
      this.m_146884_(owner.m_20182_());
   }

   protected boolean shouldRemoveWhenOwnerLost() {
      return false;
   }

   public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
      return false;
   }

   protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
   }

   public boolean m_142535_(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
      return false;
   }

   public boolean m_5843_() {
      return false;
   }

}
