package com.merlin204.tde.entity.player.client;

import com.github.leawind.thirdperson.ThirdPerson;
import com.github.leawind.thirdperson.ThirdPersonStatus;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector2d;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class TDECamera {

   private static final double MAX_PITCH = 70.0D;
   private static final double BASE_TURN_SPEED = 0.15D;
   private static final double MIN_TURN_SPEED = 0.03D;
   private static final double MAX_TURN_SPEED = 0.25D;
   private static final double EDGE_THRESHOLD = 0.5D;
   private static final double CENTER_RELAX = 0.3D;
   private static Vector2d previousRotation = new Vector2d(0.0D, 0.0D);
   private static Vec3 lastTargetPos = Vec3.f_82478_;
   private static Vec3 lastValidTargetPos = Vec3.f_82478_;
   private static boolean lastFrameValid = true;


   public static void thirdCamera(TDELocalPlayerPatch localPlayerPatch, float partialTicks) {
      LivingEntity targetEntity = localPlayerPatch.getTarget();
      if(targetEntity != null && localPlayerPatch.isLockon()) {
         if(ThirdPersonStatus.isRenderingInThirdPerson()) {
            Camera camera = ThirdPerson.CAMERA_AGENT.getRawCamera();
            if(camera != null) {
               Vector2d currentRot = ThirdPerson.CAMERA_AGENT.getRotation();
               if(!isFinite(currentRot.x) || !isFinite(currentRot.y)) {
                  ThirdPerson.CAMERA_AGENT.setRotation(new Vector2d(0.0D, 0.0D));
                  currentRot = new Vector2d(0.0D, 0.0D);
               }

               Vec3 targetPos = getTargetPosition(targetEntity, partialTicks);
               if(isFinite(targetPos.f_82479_) && isFinite(targetPos.f_82480_) && isFinite(targetPos.f_82481_)) {
                  lastValidTargetPos = targetPos;
                  lastFrameValid = true;
               } else {
                  if(!lastFrameValid) {
                     return;
                  }

                  targetPos = lastValidTargetPos;
               }

               Vector2d screenPos = worldToScreenPosition(camera, targetPos, partialTicks);
               if(isFinite(screenPos.x) && isFinite(screenPos.y)) {
                  if(!isInRelaxedZone(screenPos)) {
                     Vec3 cameraPos = camera.m_90583_();
                     if(isFinite(cameraPos.f_82479_) && isFinite(cameraPos.f_82480_) && isFinite(cameraPos.f_82481_)) {
                        Vec3 toTarget = targetPos.m_82546_(cameraPos);
                        double distance = toTarget.m_82553_();
                        if(distance < 1.0E-5D) {
                           if(lastTargetPos != Vec3.f_82478_ && lastTargetPos != targetPos) {
                              toTarget = lastTargetPos.m_82546_(cameraPos);
                              distance = toTarget.m_82553_();
                              if(distance > 1.0E-5D) {
                                 toTarget = toTarget.m_82490_(1.0D / distance);
                              } else {
                                 toTarget = new Vec3(0.0D, 0.0D, 1.0D);
                              }
                           } else {
                              toTarget = new Vec3(0.0D, 0.0D, 1.0D);
                           }
                        } else {
                           toTarget = toTarget.m_82490_(1.0D / distance);
                        }

                        lastTargetPos = targetPos;
                        double horizontalDist = Math.sqrt(toTarget.f_82479_ * toTarget.f_82479_ + toTarget.f_82481_ * toTarget.f_82481_);
                        double denominator = Math.max(horizontalDist, 1.0E-5D);
                        double targetYaw = Math.toDegrees(Math.atan2(toTarget.f_82481_, toTarget.f_82479_)) - 90.0D;
                        double targetPitch = -Math.toDegrees(Math.atan2(toTarget.f_82480_, denominator));
                        if(!isFinite(targetYaw) || !isFinite(targetPitch)) {
                           targetYaw = currentRot.y;
                           targetPitch = currentRot.x;
                        }

                        double maxPitchChange = 15.0D;
                        double currentPitch = currentRot.x;
                        targetPitch = Mth.m_14008_(targetPitch, currentPitch - maxPitchChange, currentPitch + maxPitchChange);
                        targetPitch = Mth.m_14008_(targetPitch, -70.0D, 70.0D);
                        double yawDiff = Mth.m_14175_(targetYaw - currentRot.y);
                        double pitchDiff = targetPitch - currentPitch;
                        yawDiff = Mth.m_14008_(yawDiff, -180.0D, 180.0D);
                        pitchDiff = Mth.m_14008_(pitchDiff, -90.0D, 90.0D);
                        double edgeFactor = calculateEdgeFactor(screenPos);
                        double turnSpeed = Mth.m_14008_(0.15D * (1.0D - distance * 0.005D) * edgeFactor, 0.03D, 0.25D);
                        if(isFinite(yawDiff) && isFinite(pitchDiff) && isFinite(turnSpeed)) {
                           ThirdPerson.CAMERA_AGENT.turnCamera(yawDiff * turnSpeed, pitchDiff * turnSpeed);
                        }

                     }
                  }
               }
            }
         }
      }
   }

   private static boolean isFinite(double value) {
      return !Double.isNaN(value) && !Double.isInfinite(value);
   }

   private static boolean isFinite(Vec3 vec) {
      return isFinite(vec.f_82479_) && isFinite(vec.f_82480_) && isFinite(vec.f_82481_);
   }

   private static boolean isFinite(Vector2d vec) {
      return isFinite(vec.x) && isFinite(vec.y);
   }

   private static boolean isInRelaxedZone(Vector2d screenPos) {
      double centerX = 0.5D;
      double centerY = 0.5D;
      double relaxedRadius = 0.15D;
      double distToCenter = Math.sqrt(Math.pow(screenPos.x - centerX, 2.0D) + Math.pow(screenPos.y - centerY, 2.0D));
      return distToCenter < relaxedRadius;
   }

   private static double calculateEdgeFactor(Vector2d screenPos) {
      if(screenPos.x >= 0.0D && screenPos.x <= 1.0D && screenPos.y >= 0.0D && screenPos.y <= 1.0D) {
         double horizontalEdge = Math.max(Math.abs(screenPos.x - 0.5D) - 0.15D, 0.0D) / 0.2D;
         double verticalEdge = Math.max(Math.abs(screenPos.y - 0.5D) - 0.15D, 0.0D) / 0.2D;
         return Mth.m_14008_(Math.max(horizontalEdge, verticalEdge), 0.0D, 1.0D);
      } else {
         return 1.0D;
      }
   }

   private static Vector2d worldToScreenPosition(Camera camera, Vec3 targetPos, float partialTicks) {
      Window window = Minecraft.m_91087_().m_91268_();
      int width = window.m_85441_();
      int height = window.m_85442_();
      Vector4f clipSpace = new Vector4f((float)(targetPos.f_82479_ - camera.m_90583_().f_82479_), (float)(targetPos.f_82480_ - camera.m_90583_().f_82480_), (float)(targetPos.f_82481_ - camera.m_90583_().f_82481_), 1.0F);
      Matrix4f viewMatrix = new Matrix4f();
      viewMatrix.rotate((float)Math.toRadians((double)(-camera.m_90590_())), new Vector3f(0.0F, 1.0F, 0.0F));
      viewMatrix.rotate((float)Math.toRadians((double)(-camera.m_90589_())), new Vector3f(1.0F, 0.0F, 0.0F));
      viewMatrix.transform(clipSpace);
      float fov = (float)Math.toRadians((double)((Integer)Minecraft.m_91087_().f_91066_.m_231837_().m_231551_()).intValue());
      float aspectRatio = (float)width / (float)height;
      if(aspectRatio < 0.01F) {
         aspectRatio = 1.777F;
      }

      Matrix4f projMatrix = (new Matrix4f()).perspective(fov, aspectRatio, 0.05F, 1000.0F);
      projMatrix.transform(clipSpace);
      if(Math.abs(clipSpace.w()) < 1.0E-5F) {
         return new Vector2d(-1.0D, -1.0D);
      } else {
         float ndcX = clipSpace.x() / clipSpace.w();
         float ndcY = clipSpace.y() / clipSpace.w();
         if(!Float.isNaN(ndcX) && !Float.isNaN(ndcY)) {
            double screenX = ((double)ndcX + 1.0D) / 2.0D;
            double screenY = 1.0D - ((double)ndcY + 1.0D) / 2.0D;
            return new Vector2d(screenX, screenY);
         } else {
            return new Vector2d(-1.0D, -1.0D);
         }
      }
   }

   private static Vec3 getTargetPosition(Entity entity, float partialTicks) {
      double heightOffset = (double)entity.m_20206_() * 0.6D;
      Vec3 pos = entity.m_20318_(partialTicks);
      if(isFinite(pos.f_82479_) && isFinite(pos.f_82480_) && isFinite(pos.f_82481_)) {
         if(entity instanceof EnemyEntity) {
            EnemyEntity enemyEntity = (EnemyEntity)entity;
            if(enemyEntity.getLockPos() != null) {
               Vec3 lockPos = enemyEntity.getLockPos();
               if(isFinite((Vec3)lockPos)) {
                  return new Vec3(lockPos.f_82479_, lockPos.f_82480_, lockPos.f_82481_);
               }
            }
         }

         return new Vec3(pos.f_82479_, pos.f_82480_ + heightOffset, pos.f_82481_);
      } else {
         return lastValidTargetPos != Vec3.f_82478_?lastValidTargetPos:entity.m_20182_();
      }
   }

}
