package com.merlin204.tde.entity.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.merlin204.tde.capabilitiy.player.TDEPlayerCapabilities;
import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.capabilitiy.player.ability.PlayerAbilities;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.epicfight.skill.registry.ChargedBasicAttacks;
import com.merlin204.tde.epicfight.skill.registry.CycleSkills;
import com.merlin204.tde.epicfight.skill.registry.DodgeSkills;
import com.merlin204.tde.epicfight.skill.registry.GuardSkills;
import com.merlin204.tde.epicfight.skill.registry.SoulfireSkills;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.Map.Entry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.AttributeModifier.Operation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

public class TDEServerPlayerPatch extends ServerPlayerPatch {

   private boolean updatedMotionCurrentTick;
   private boolean updatedLiving = false;
   private boolean energyRecovery = true;
   public int stopEnergyRecoveryTime = 0;
   private ItemStack mainHandOld = null;
   private ItemStack offHandOld = null;


   public AttackResult tryHurt(DamageSource damageSource, float amount) {
      ((ServerPlayer)this.original).f_20916_ = 0;
      this.stopEnergyRecoveryTime = 30;
      ((ServerPlayer)this.original).getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES);
      this.ifPresent((NonNullConsumer)amount);
      return super.tryHurt(damageSource, (float)amount);
   }

   public void onJoinWorld(ServerPlayer entity, EntityJoinLevelEvent event) {
      super.onJoinWorld(entity, event);
      CapabilitySkill skillCapability = this.getSkillCapability();
      skillCapability.skillContainers[SkillSlots.AIR_ATTACK.universalOrdinal()].setSkill((Skill)null);
      skillCapability.skillContainers[SkillSlots.GUARD.universalOrdinal()].setSkill((Skill)null);
      skillCapability.skillContainers[TDESkillSlots.EXECUTE.universalOrdinal()].setSkill(SoulfireSkills.EXECUTE);
      this.addSkill(TDESkillSlots.CYCLE_1, CycleSkills.EMPTY1);
      this.addSkill(TDESkillSlots.CYCLE_2, CycleSkills.EMPTY2);
      this.addSkill(TDESkillSlots.CYCLE_3, CycleSkills.EMPTY3);
      this.addSkill(TDESkillSlots.CYCLE_4, CycleSkills.EMPTY4);
      this.addSkill(TDESkillSlots.CYCLE_5, CycleSkills.EMPTY5);
      this.addSkill(TDESkillSlots.TDEGUARD, GuardSkills.BASICGUARD);
      this.addSkill(TDESkillSlots.CHARGED_ATTACK, ChargedBasicAttacks.CHARGED_ATTACK);
      this.addSkill(SkillSlots.DODGE, DodgeSkills.BASICDODGE);
      this.addSkill(TDESkillSlots.SOULFIRE, SoulfireSkills.SOULFIRE);
      this.modifyLivingMotionByCurrentItem(false);
      this.tickSinceLastAction = 0;
      this.eventListeners.addEventListener(EventType.ACTION_EVENT_SERVER, PLAYER_EVENT_UUID, this);
      this.updatedLiving = false;
   }

   public void addSkill(SkillSlot skillSlot, Skill skill) {
      if(this.getSkill(skillSlot).getSkill() == null) {
         CapabilitySkill skillCapability = this.getSkillCapability();
         skillCapability.skillContainers[skillSlot.universalOrdinal()].setSkill(skill);
      }

   }

   public void tick(LivingTickEvent event) {
      super.tick(event);
      this.checkItem();
      if(this.stopEnergyRecoveryTime > 0) {
         --this.stopEnergyRecoveryTime;
         this.energyRecovery = false;
      }

      this.energyRecovery = true;
      SkillDataManager manager;
      if(this.getSkill(TDESkillSlots.CHARGED_ATTACK) != null) {
         manager = this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager();
         if(manager.hasData((SkillDataKey)TDEDatakeys.IS_CHARGING.get())) {
            this.energyRecovery = !((Boolean)manager.getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get())).booleanValue();
            if(manager.hasData((SkillDataKey)TDEDatakeys.CHARGING_POWER.get()) && !this.getEntityState().inaction()) {
               manager.setDataSync((SkillDataKey)TDEDatakeys.CHARGING_POWER.get(), Float.valueOf(0.0F), (ServerPlayer)this.original);
            }
         }
      }

      manager = this.getSkill(SkillSlots.WEAPON_PASSIVE).getDataManager();
      if(!this.updatedLiving) {
         this.modifyLivingMotionByCurrentItem(false);
      }

      AttributeModifier stepHeight = new AttributeModifier(UUID.fromString("0aa15453-26e2-4e85-8042-1fe4c65a8c3c"), "Step Height", 0.6000000238418579D, Operation.ADDITION);
      AttributeInstance stepInstance = ((ServerPlayer)this.getOriginal()).m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
      if(stepInstance != null) {
         stepInstance.m_22130_(stepHeight);
         stepInstance.m_22125_(stepHeight);
      }

      UUID SPEED_MODIFIER_ID = UUID.fromString("b1a7e3d4-0a2f-4a3d-8d1e-7c8a5f3d9b1c");
      UUID HEALTH_MODIFIER_ID = UUID.fromString("b1a7e3d4-0a2f-4a3d-8e1e-7c8a5f5d9b1c");
      double SPRINT_SPEED_BOOST = 0.2D;
      AttributeInstance movementSpeed = ((ServerPlayer)this.original).m_21051_(Attributes.f_22279_);
      AttributeInstance maxHealth = ((ServerPlayer)this.original).m_21051_(Attributes.f_22276_);
      if(movementSpeed != null) {
         AttributeModifier healthAdd = movementSpeed.m_22111_(SPEED_MODIFIER_ID);
         if(this.isEpicFightMode() && ((ServerPlayer)this.original).m_20142_()) {
            if(healthAdd == null || healthAdd.m_22218_() != 0.2D) {
               movementSpeed.m_22120_(SPEED_MODIFIER_ID);
               movementSpeed.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, "Battle Sprint Boost", 0.2D, Operation.MULTIPLY_TOTAL));
            }
         } else if(healthAdd != null) {
            movementSpeed.m_22120_(SPEED_MODIFIER_ID);
         }
      }

      double healthAdd1 = (double)(TDEAbilityUtils.getAbility(AbilityType.VITALITY, (Player)this.original) + TDEAbilityUtils.getAbility(AbilityType.STAMINA, (Player)this.original) * 0.5F + TDEAbilityUtils.getAbility(AbilityType.STRENGTH, (Player)this.original) * 0.2F);
      if(maxHealth != null) {
         AttributeModifier healthModifier = maxHealth.m_22111_(HEALTH_MODIFIER_ID);
         if(this.isEpicFightMode()) {
            if(healthModifier == null || healthModifier.m_22218_() != healthAdd1) {
               maxHealth.m_22120_(HEALTH_MODIFIER_ID);
               maxHealth.m_22118_(new AttributeModifier(HEALTH_MODIFIER_ID, "tde healthAdd", healthAdd1, Operation.ADDITION));
               ((ServerPlayer)this.getOriginal()).m_5634_(999999.0F);
            }
         } else if(healthModifier != null) {
            maxHealth.m_22120_(HEALTH_MODIFIER_ID);
         }
      }

      ((ServerPlayer)this.original).getCapability(TDEPlayerCapabilities.PLAYER_ABILITIES).ifPresent(this);
      this.updatedMotionCurrentTick = false;
   }

   public void energyDamageAtk(EnemyPatch enemyPatch, float amount) {
      Object cost = amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_BOOST, (Player)this.original);
      ((EnemyEntity)enemyPatch.getOriginal()).costEnergy((float)cost);
      System.out.println((String)cost);
   }

   public void costEnergy(float cost) {
      TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
      System.out.println(cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
   }

   public void hurtEnergyDamage(float amount) {
      TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, 5.0F * amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_RESISTANCE, (Player)this.original));
      System.out.println(amount * TDEAbilityUtils.getAbility(AbilityType.ENERGY_DAMAGE_RESISTANCE, (Player)this.original));
   }

   public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
      Item item = ((ServerPlayer)this.original).m_21120_(hand).m_41720_();
      if(item instanceof TDEWeaponItem) {
         TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
         return tdeWeaponItem.getProperties();
      } else {
         return null;
      }
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?(SoundEvent)EpicFightSounds.BLUNT_HIT.get():this.getTDETDEWeaponItemProperties(hand).getHitSound();
   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?(SoundEvent)EpicFightSounds.WHOOSH_SMALL.get():this.getTDETDEWeaponItemProperties(hand).getSwingSound();
   }

   public Collider getColliderMatching(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?ColliderPreset.FIST:this.getTDETDEWeaponItemProperties(hand).getTdeCollider().getCollider();
   }

   public HitParticleType getWeaponHitParticle(InteractionHand hand) {
      return this.getAdvancedHoldingItemCapability(hand).getHitParticle();
   }

   public boolean isGuard() {
      return this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get()) != null?((Boolean)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_GUARD.get())).booleanValue():false;
   }

   public boolean isCharging() {
      return this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get()) != null?((Boolean)this.getSkill(TDESkillSlots.CHARGED_ATTACK).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.IS_CHARGING.get())).booleanValue():false;
   }

   public void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_BACKWARD, TDELivingAnimations.TDE_WALK_BACKWARD);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_LEFT, TDELivingAnimations.TDE_WALK_LEFT);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_RIGHT, TDELivingAnimations.TDE_WALK_RIGHT);
      animator.addLivingAnimation(TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
      animator.addLivingAnimation(TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
      animator.addLivingAnimation(TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
      animator.addLivingAnimation(TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
      animator.addLivingAnimation(TDELivingMotions.TDE_DEATH, TDELivingAnimations.TDE_DEATH);
      animator.addLivingAnimation(TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
      animator.addLivingAnimation(TDELivingMotions.TDE_CREATIVE_IDLE, TDELivingAnimations.TDE_CREATIVE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_CREATIVE_FLY, TDELivingAnimations.TDE_CREATIVE_FLY);
      animator.addLivingAnimation(LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_JUMP_RUN, TDELivingAnimations.TDE_JUMP_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_JUMP_WALK, TDELivingAnimations.TDE_JUMP_WALK);
   }

   public float getDamage(InteractionHand hand) {
      Item var3 = ((ServerPlayer)this.original).m_21120_(hand).m_41720_();
      if(var3 instanceof TDEWeaponItem) {
         TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)var3;
         return tdeWeaponItem.getDamage();
      } else {
         return 0.0F;
      }
   }

   private Map getDefaultLivingAnimations() {
      HashMap defaultAnimations = Maps.newHashMap();
      defaultAnimations.put(LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
      defaultAnimations.put(TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
      defaultAnimations.put(TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
      defaultAnimations.put(TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
      defaultAnimations.put(TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
      defaultAnimations.put(TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
      defaultAnimations.put(TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
      defaultAnimations.put(TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
      defaultAnimations.put(TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
      defaultAnimations.put(LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
      defaultAnimations.put(TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
      return defaultAnimations;
   }

   public int getDefendLevel() {
      int a = 0;
      int b = 0;
      int c = 0;
      Item var5 = ((ServerPlayer)this.original).m_21205_().m_41720_();
      TDEWeaponItem basicSect;
      if(var5 instanceof TDEWeaponItem) {
         basicSect = (TDEWeaponItem)var5;
         a = basicSect.getProperties().getDefendBonus();
      }

      var5 = ((ServerPlayer)this.original).m_21206_().m_41720_();
      if(var5 instanceof TDEWeaponItem) {
         basicSect = (TDEWeaponItem)var5;
         b = basicSect.getProperties().getDefendBonus();
      }

      Skill var7 = this.getSkill(TDESkillSlots.SECT).getSkill();
      if(var7 instanceof BasicSect) {
         BasicSect basicSect1 = (BasicSect)var7;
         c = basicSect1.getDefendLevel();
         switch(null.$SwitchMap$com$merlin204$tde$epicfight$gameassets$skill$sect$basic$BasicSect$GuardType[basicSect1.getGuardType().ordinal()]) {
         case 1:
            a = 0;
            break;
         case 2:
            b = 0;
         }
      }

      return a + b + c;
   }

   public int getPerfectDodgeTime() {
      return ((Integer)this.getSkill(SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get())).intValue();
   }

   public int getPerfectGuardTime() {
      return ((Integer)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get())).intValue();
   }

   private void checkItem() {
      boolean shouldModify = false;
      ItemStack mainHandNew = ((ServerPlayer)this.original).m_21205_();
      if(mainHandNew != this.mainHandOld) {
         boolean offHandNew = this.checkItemChange(this.mainHandOld, mainHandNew);
         shouldModify |= offHandNew;
      }

      ItemStack offHandNew1 = ((ServerPlayer)this.original).m_21206_();
      if(offHandNew1 != this.offHandOld) {
         boolean offHandChange = this.checkItemChange(this.offHandOld, offHandNew1);
         shouldModify |= offHandChange;
      }

      if(shouldModify) {
         this.modifyLivingMotionByCurrentItem(false);
      }

      this.mainHandOld = mainHandNew;
      this.offHandOld = offHandNew1;
   }

   private boolean checkItemChange(ItemStack oldStack, ItemStack newStack) {
      if(oldStack != null && newStack != null) {
         if(!(oldStack.m_41720_() instanceof TDEWeaponItem) && !(newStack.m_41720_() instanceof TDEWeaponItem)) {
            return false;
         } else if(oldStack.m_41720_() instanceof TDEWeaponItem != (newStack.m_41720_() instanceof TDEWeaponItem)) {
            return true;
         } else {
            TDEWeaponItem oldWeapon = (TDEWeaponItem)oldStack.m_41720_();
            TDEWeaponItem newWeapon = (TDEWeaponItem)newStack.m_41720_();
            return oldWeapon.getProperties().getWeaponType() != newWeapon.getProperties().getWeaponType();
         }
      } else {
         return true;
      }
   }

   public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
      if(hand == InteractionHand.OFF_HAND) {
         Collection var10000;
         AttributeInstance var10001;
         Multimap modifiers;
         if(!from.m_41619_()) {
            modifiers = from.m_41638_(EquipmentSlot.MAINHAND);
            var10000 = modifiers.get(Attributes.f_22283_);
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
         }

         if(!fromCap.isEmpty()) {
            modifiers = fromCap.getAllAttributeModifiers(EquipmentSlot.MAINHAND);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.ARMOR_NEGATION.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.IMPACT.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.MAX_STRIKES.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get(Attributes.f_22283_);
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
         }

         if(!to.m_41619_()) {
            modifiers = to.m_41638_(EquipmentSlot.MAINHAND);
            var10000 = modifiers.get(Attributes.f_22283_);
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
         }

         if(!toCap.isEmpty()) {
            modifiers = toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.ARMOR_NEGATION.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.IMPACT.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get((Attribute)EpicFightAttributes.MAX_STRIKES.get());
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
            var10000 = modifiers.get(Attributes.f_22283_);
            var10001 = ((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get());
            Objects.requireNonNull(var10001);
            var10000.forEach(var10001);
         }
      }

   }

   public void modifyLivingMotionByCurrentItem(boolean checkOldAnimations) {
      if(!this.updatedMotionCurrentTick || !checkOldAnimations) {
         Map oldLivingAnimations = this.getAnimator().getLivingAnimations();
         HashMap newLivingAnimations = Maps.newHashMap();
         SkillContainer basicAttackContainer = this.getSkill(TDESkillSlots.SECT);
         boolean isBasicSectActive = basicAttackContainer != null && basicAttackContainer.getSkill() instanceof BasicSect;
         if(isBasicSectActive) {
            BasicSect msg = (BasicSect)basicAttackContainer.getSkill();
            if(msg.checkAllowed((Player)this.original)) {
               Map entry = msg.getLivingAnimations();
               this.forEach(newLivingAnimations);
            } else {
               newLivingAnimations.putAll(this.getDefaultLivingAnimations());
               this.updatedLiving = true;
            }
         } else {
            newLivingAnimations.putAll(this.getDefaultLivingAnimations());
            this.updatedLiving = true;
         }

         Iterator msg1 = newLivingAnimations.entrySet().iterator();

         while(msg1.hasNext()) {
            Entry entry1 = (Entry)msg1.next();
            AssetAccessor newAnim = (AssetAccessor)entry1.getValue();
            AssetAccessor oldAnim = (AssetAccessor)oldLivingAnimations.get(entry1.getKey());
            if(oldAnim == null || !oldAnim.equals(newAnim)) {
               this.updatedMotionCurrentTick = true;
               break;
            }
         }

         if(this.updatedMotionCurrentTick || !checkOldAnimations) {
            this.getAnimator().resetLivingAnimations();
            Animator var10001 = this.getAnimator();
            Objects.requireNonNull(var10001);
            newLivingAnimations.forEach(var10001);
            SPChangeLivingMotion msg2 = new SPChangeLivingMotion(((ServerPlayer)this.original).m_19879_());
            msg2.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg2, (ServerPlayer)this.original);
         }

      }
   }

   public boolean applyStun(StunType stunType, float stunTime) {
      return false;
   }

   // $FF: synthetic method
   private void lambda$modifyLivingMotionByCurrentItem$3(Map newLivingAnimations, LivingMotion motion, AnimationAccessor accessor) {
      newLivingAnimations.put(motion, accessor);
      this.updatedLiving = true;
   }

   // $FF: synthetic method
   private void lambda$tick$2(PlayerAbilities abilities) {
      abilities.get(AbilityType.MANA).add(abilities.get(AbilityType.MANA_RECOVERY_SPEED).getCurrentMax());
      if(this.isEpicFightMode()) {
         if(((ServerPlayer)this.original).m_20142_()) {
            float cost = 1.0F - abilities.get(AbilityType.ENERGY_COST_EFFICIENCY).getCurrentMax();
            float currentEnergy = abilities.get(AbilityType.ENERGY).get();
            if(currentEnergy >= cost) {
               abilities.get(AbilityType.ENERGY).sub(cost);
            } else {
               ((ServerPlayer)this.original).m_6858_(false);
            }
         } else if(!this.getEntityState().inaction() && this.energyRecovery && this.stopEnergyRecoveryTime == 0) {
            abilities.get(AbilityType.ENERGY).add(abilities.get(AbilityType.ENERGY_RECOVERY_SPEED).getCurrentMax());
         }
      } else if(!this.getEntityState().inaction() && this.energyRecovery && this.stopEnergyRecoveryTime == 0) {
         abilities.get(AbilityType.ENERGY).add(abilities.get(AbilityType.ENERGY_RECOVERY_SPEED).getCurrentMax());
      }

      abilities.syncToClient((Player)this.original);
   }

   // $FF: synthetic method
   private void lambda$onJoinWorld$1(ActionEvent playerEvent) {
      this.resetActionTick();
   }

   // $FF: synthetic method
   private void lambda$tryHurt$0(float amount, PlayerAbilities abilities) {
      abilities.get(AbilityType.ENERGY).sub(amount * 0.25F * (1.0F - abilities.get(AbilityType.ENERGY_DAMAGE_RESISTANCE).get()));
      abilities.syncToClient((Player)this.original);
   }
}
