package com.merlin204.tde.entity.player;

import com.merlin204.tde.capabilitiy.player.ability.AbilityType;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.player.client.TDECamera;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.epicfight.gameassets.animations.bipe.TDELivingAnimations;
import com.merlin204.tde.epicfight.skill.TDEDatakeys;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.merlin204.tde.epicfight.skill.registry.ChargedBasicAttacks;
import com.merlin204.tde.epicfight.skill.registry.CycleSkills;
import com.merlin204.tde.epicfight.skill.registry.DodgeSkills;
import com.merlin204.tde.epicfight.skill.registry.GuardSkills;
import com.merlin204.tde.epicfight.skill.registry.SoulfireSkills;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.util.TDEAbilityUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer.Priority;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent.BaseLayer;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent.CompositeLayer;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.events.engine.ControllEngine;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPSetPlayerTarget;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.CapabilityItem.WeaponCategories;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.ActionEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener.EventType;

@OnlyIn(Dist.CLIENT)
public class TDELocalPlayerPatch extends LocalPlayerPatch {

   private LivingEntity target;
   private int searchTargetCooldown;
   private LivingEntity lastTarget;
   public int mainBackTick;
   public int offBackTick;
   private int lineOfSightCacheTime = 0;
   private Map lineOfSightCache = new HashMap();


   public void onJoinWorld(LocalPlayer entity, EntityJoinLevelEvent event) {
      super.onJoinWorld(entity, event);
      CapabilitySkill skillCapability = this.getSkillCapability();
      skillCapability.skillContainers[TDESkillSlots.EXECUTE.universalOrdinal()].setSkill(SoulfireSkills.EXECUTE);
      this.addSkill(TDESkillSlots.CYCLE_1, CycleSkills.EMPTY1);
      this.addSkill(TDESkillSlots.CYCLE_2, CycleSkills.EMPTY2);
      this.addSkill(TDESkillSlots.CYCLE_3, CycleSkills.EMPTY3);
      this.addSkill(TDESkillSlots.CYCLE_4, CycleSkills.EMPTY4);
      this.addSkill(TDESkillSlots.CYCLE_5, CycleSkills.EMPTY5);
      this.addSkill(TDESkillSlots.TDEGUARD, GuardSkills.BASICGUARD);
      this.addSkill(TDESkillSlots.CHARGED_ATTACK, ChargedBasicAttacks.CHARGED_ATTACK);
      this.addSkill(SkillSlots.DODGE, DodgeSkills.BASICDODGE);
      this.addSkill(TDESkillSlots.SOULFIRE, SoulfireSkills.SOULFIRE);
      this.tickSinceLastAction = 0;
      this.eventListeners.addEventListener(EventType.ACTION_EVENT_SERVER, PLAYER_EVENT_UUID, this);
   }

   public void addSkill(SkillSlot skillSlot, Skill skill) {
      if(this.getSkill(skillSlot).getSkill() == null) {
         CapabilitySkill skillCapability = this.getSkillCapability();
         skillCapability.skillContainers[skillSlot.universalOrdinal()].setSkill(skill);
      }

   }

   public void tick(LivingTickEvent event) {
      super.tick(event);
      if(this.mainBackTick > 0) {
         --this.mainBackTick;
      }

      if(this.offBackTick > 0) {
         --this.offBackTick;
      }

      if(this.searchTargetCooldown > 0) {
         --this.searchTargetCooldown;
      }

      Minecraft mc = Minecraft.m_91087_();
      ControllEngine.setKeyBind(mc.f_91066_.f_92096_, false);
   }

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      super.poseTick(animation, pose, elapsedTime, partialTicks);
      TDECamera.thirdCamera(this, partialTicks);
      if(this.target != null) {
         EpicFightNetworkManager.sendToServer(new CPSetPlayerTarget(this.getTarget().m_19879_()));
         if(!this.target.m_6084_()) {
            this.searchTargetCooldown = 0;
            this.searchTarget(true);
         }

         this.setLockOn(true);
      } else {
         this.setLockOn(false);
      }

   }

   public boolean isTargetLockedOn() {
      return false;
   }

   public boolean isLockon() {
      return this.target != null;
   }

   public void setLockOn(boolean targetLockedOn) {
      super.setLockOn(targetLockedOn);
      if(!targetLockedOn) {
         this.target = null;
      }

   }

   public void searchTarget(boolean param1) {
      // $FF: Couldn't be decompiled
   }

   private boolean hasLineOfSightCached(LivingEntity target) {
      Map var10000 = this.lineOfSightCache;
      return ((Boolean)target.computeIfAbsent(this, target)).booleanValue();
   }

   public void setTarget(LivingEntity entity) {
      this.target = this.target;
   }

   public LivingEntity getTarget() {
      return this.target != null?this.target:super.getTarget();
   }

   public void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, TDELivingAnimations.TDE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_IDLE, TDELivingAnimations.TDE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_KNEEL, TDELivingAnimations.TDE_KNEEL);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK, TDELivingAnimations.TDE_WALK);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_BACKWARD, TDELivingAnimations.TDE_WALK_BACKWARD);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_LEFT, TDELivingAnimations.TDE_WALK_LEFT);
      animator.addLivingAnimation(TDELivingMotions.TDE_WALK_RIGHT, TDELivingAnimations.TDE_WALK_RIGHT);
      animator.addLivingAnimation(TDELivingMotions.TDE_RUN, TDELivingAnimations.TDE_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_SNEAK, TDELivingAnimations.TDE_SNEAK);
      animator.addLivingAnimation(TDELivingMotions.TDE_FALL, TDELivingAnimations.TDE_FALL);
      animator.addLivingAnimation(TDELivingMotions.TDE_CLIMB, TDELivingAnimations.TDE_CLIMB);
      animator.addLivingAnimation(TDELivingMotions.TDE_DIG, TDELivingAnimations.TDE_DIG);
      animator.addLivingAnimation(TDELivingMotions.TDE_DEATH, TDELivingAnimations.TDE_DEATH);
      animator.addLivingAnimation(TDELivingMotions.TDE_FLOAT, TDELivingAnimations.TDE_FLOAT);
      animator.addLivingAnimation(TDELivingMotions.TDE_CREATIVE_IDLE, TDELivingAnimations.TDE_CREATIVE_IDLE);
      animator.addLivingAnimation(TDELivingMotions.TDE_CREATIVE_FLY, TDELivingAnimations.TDE_CREATIVE_FLY);
      animator.addLivingAnimation(LivingMotions.JUMP, TDELivingAnimations.TDE_JUMP_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_JUMP_RUN, TDELivingAnimations.TDE_JUMP_RUN);
      animator.addLivingAnimation(TDELivingMotions.TDE_JUMP_WALK, TDELivingAnimations.TDE_JUMP_WALK);
   }

   public void rotateTo(Vec3 pos, float limit, boolean syncPrevRot) {
      Vec3 playerPosition = ((LivingEntity)this.original).m_20182_();
      float yaw = (float)MathUtils.getYRotOfVector(pos.m_82546_(playerPosition));
      this.rotateTo(yaw, limit, syncPrevRot);
   }

   public void updateMotion(boolean considerInaction) {
      if(((AbstractClientPlayer)this.original).m_21223_() <= 0.0F) {
         this.currentLivingMotion = TDELivingMotions.TDE_DEATH;
      } else if(!this.state.updateLivingMotion() && considerInaction) {
         this.currentLivingMotion = LivingMotions.INACTION;
      } else {
         ClientAnimator baseLayerEvent = this.getClientAnimator();
         if(!((AbstractClientPlayer)this.original).m_21255_() && !((AbstractClientPlayer)this.original).m_21209_()) {
            if(((AbstractClientPlayer)this.original).m_20202_() != null) {
               if(((AbstractClientPlayer)this.original).m_20202_() instanceof PlayerRideableJumping) {
                  this.currentLivingMotion = LivingMotions.MOUNT;
               } else {
                  this.currentLivingMotion = LivingMotions.SIT;
               }
            } else if(((AbstractClientPlayer)this.original).m_6067_()) {
               this.currentLivingMotion = LivingMotions.SWIM;
            } else if(((AbstractClientPlayer)this.original).m_5803_()) {
               this.currentLivingMotion = LivingMotions.SLEEP;
            } else if(!((AbstractClientPlayer)this.original).m_20096_() && ((AbstractClientPlayer)this.original).m_6147_()) {
               this.currentLivingMotion = TDELivingMotions.TDE_CLIMB;
            } else if(!((AbstractClientPlayer)this.original).m_150110_().f_35935_) {
               if(((AbstractClientPlayer)this.original).m_5842_() && ((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ < -0.005D) {
                  this.currentLivingMotion = TDELivingMotions.TDE_FLOAT;
               } else if(((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ >= -0.4000000059604645D && !this.isAirborneState()) {
                  if(this.isMoving()) {
                     if(((AbstractClientPlayer)this.original).m_6047_()) {
                        this.currentLivingMotion = TDELivingMotions.TDE_SNEAK;
                     } else if(((AbstractClientPlayer)this.original).m_20142_()) {
                        this.currentLivingMotion = TDELivingMotions.TDE_RUN;
                     } else {
                        this.currentLivingMotion = TDELivingMotions.TDE_WALK;
                     }

                     baseLayerEvent.baseLayer.animationPlayer.setReversed(this.dz < 0.0D);
                  } else {
                     baseLayerEvent.baseLayer.animationPlayer.setReversed(false);
                     if(((AbstractClientPlayer)this.original).m_6047_()) {
                        this.currentLivingMotion = TDELivingMotions.TDE_KNEEL;
                     } else {
                        this.currentLivingMotion = LivingMotions.IDLE;
                     }
                  }
               } else {
                  this.currentLivingMotion = TDELivingMotions.TDE_FALL;
               }
            } else if(this.isMoving()) {
               this.currentLivingMotion = TDELivingMotions.TDE_CREATIVE_FLY;
            } else {
               this.currentLivingMotion = TDELivingMotions.TDE_CREATIVE_IDLE;
            }
         } else {
            this.currentLivingMotion = LivingMotions.FLY;
         }
      }

      BaseLayer baseLayerEvent1 = new BaseLayer(this, this.currentLivingMotion, !this.state.updateLivingMotion() && considerInaction);
      MinecraftForge.EVENT_BUS.post(baseLayerEvent1);
      this.currentLivingMotion = baseLayerEvent1.getMotion();
      CapabilityItem activeItemCap = this.getHoldingItemCapability(((AbstractClientPlayer)this.original).m_7655_());
      if(((AbstractClientPlayer)this.original).m_6117_()) {
         UseAnim compositeLayerEvent = ((AbstractClientPlayer)this.original).m_21211_().m_41780_();
         UseAnim capUseAnim = activeItemCap.getUseAnimation(this);
         if(compositeLayerEvent != UseAnim.BLOCK && capUseAnim != UseAnim.BLOCK) {
            if(compositeLayerEvent != UseAnim.BOW && compositeLayerEvent != UseAnim.SPEAR) {
               if(compositeLayerEvent == UseAnim.CROSSBOW) {
                  this.currentCompositeMotion = LivingMotions.RELOAD;
               } else if(compositeLayerEvent == UseAnim.DRINK) {
                  this.currentCompositeMotion = LivingMotions.DRINK;
               } else if(compositeLayerEvent == UseAnim.EAT) {
                  this.currentCompositeMotion = LivingMotions.EAT;
               } else if(compositeLayerEvent == UseAnim.SPYGLASS) {
                  this.currentCompositeMotion = LivingMotions.SPECTATE;
               } else {
                  this.currentCompositeMotion = this.currentLivingMotion;
               }
            } else {
               this.currentCompositeMotion = LivingMotions.AIM;
            }
         } else if(activeItemCap.getWeaponCategory() == WeaponCategories.SHIELD) {
            this.currentCompositeMotion = LivingMotions.BLOCK_SHIELD;
         } else {
            this.currentCompositeMotion = LivingMotions.BLOCK;
         }
      } else if(((AbstractClientPlayer)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem && CrossbowItem.m_40932_(((AbstractClientPlayer)this.original).m_21205_())) {
         this.currentCompositeMotion = LivingMotions.AIM;
      } else if(((DynamicAnimation)this.getClientAnimator().getCompositeLayer(Priority.MIDDLE).animationPlayer.getAnimation().get()).isReboundAnimation()) {
         this.currentCompositeMotion = LivingMotions.NONE;
      } else {
         this.currentCompositeMotion = this.currentLivingMotion;
      }

      CompositeLayer compositeLayerEvent1 = new CompositeLayer(this, this.currentCompositeMotion);
      MinecraftForge.EVENT_BUS.post(compositeLayerEvent1);
      this.currentCompositeMotion = compositeLayerEvent1.getMotion();
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?(SoundEvent)EpicFightSounds.BLUNT_HIT.get():this.getTDETDEWeaponItemProperties(hand).getHitSound();
   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?(SoundEvent)EpicFightSounds.WHOOSH_SMALL.get():this.getTDETDEWeaponItemProperties(hand).getSwingSound();
   }

   public void costEnergy(float cost) {
      TDEAbilityUtils.subAbility(AbilityType.ENERGY, (Player)this.original, cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
      System.out.println(cost * TDEAbilityUtils.getAbility(AbilityType.ENERGY_COST_EFFICIENCY, (Player)this.original));
   }

   public int getPerfectDodgeTime() {
      return ((Integer)this.getSkill(SkillSlots.DODGE).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_DODGE_TIME.get())).intValue();
   }

   public int getPerfectGuardTime() {
      return ((Integer)this.getSkill(TDESkillSlots.TDEGUARD).getDataManager().getDataValue((SkillDataKey)TDEDatakeys.PERFECT_GUARD_TIME.get())).intValue();
   }

   public Collider getColliderMatching(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand) == null?ColliderPreset.FIST:this.getTDETDEWeaponItemProperties(hand).getTdeCollider().getCollider();
   }

   public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
      Item item = ((LocalPlayer)this.original).m_21120_(hand).m_41720_();
      if(item instanceof TDEWeaponItem) {
         TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
         return tdeWeaponItem.getProperties();
      } else {
         return null;
      }
   }

   private boolean isTargetingPlayer(LivingEntity enemy) {
      if(enemy instanceof EnemyEntity) {
         EnemyEntity mob = (EnemyEntity)enemy;
         return mob.m_5448_() == this.original;
      } else {
         return false;
      }
   }

   public boolean applyStun(StunType stunType, float stunTime) {
      return false;
   }

   // $FF: synthetic method
   private Boolean lambda$hasLineOfSightCached$8(LivingEntity target, LivingEntity k) {
      return Boolean.valueOf(((LocalPlayer)this.original).m_142582_(target));
   }

   // $FF: synthetic method
   private static double lambda$searchTarget$7(TDELocalPlayerPatch.EntityData data) {
      return data.distance;
   }

   // $FF: synthetic method
   private static double lambda$searchTarget$6(TDELocalPlayerPatch.EntityData data) {
      return -data.frontDot;
   }

   // $FF: synthetic method
   private static double lambda$searchTarget$5(TDELocalPlayerPatch.EntityData data) {
      return data.frontDot > 0.0D?2.0D:3.0D;
   }

   // $FF: synthetic method
   private static double lambda$searchTarget$4(TDELocalPlayerPatch.EntityData data) {
      return data.frontDot > 0.86D?0.0D:1.0D;
   }

   // $FF: synthetic method
   private static int lambda$searchTarget$3(TDELocalPlayerPatch.EntityData data) {
      return data.isPriorityTarget?0:1;
   }

   // $FF: synthetic method
   private TDELocalPlayerPatch.EntityData lambda$searchTarget$2(Vec3 pos, Vec3 lookVec, LivingEntity e) {
      Vec3 toTarget = e.m_20182_().m_82546_(pos);
      double distance = toTarget.m_82553_();
      double frontDot = lookVec.m_82526_(toTarget.m_82541_());
      boolean isPriorityTarget = this.isTargetingPlayer(e);
      return new TDELocalPlayerPatch.EntityData(e, distance, frontDot, isPriorityTarget);
   }

   // $FF: synthetic method
   private boolean lambda$searchTarget$1(LivingEntity e) {
      return e != this.original && e.m_6084_() && e instanceof EnemyEntity && (((LocalPlayer)this.original).m_142582_(e) || this.isTargetingPlayer(e));
   }

   // $FF: synthetic method
   private void lambda$onJoinWorld$0(ActionEvent playerEvent) {
      this.resetActionTick();
   }

   private static class EntityData {

      final LivingEntity entity;
      final double distance;
      final double frontDot;
      final boolean isPriorityTarget;


      EntityData(LivingEntity entity, double distance, double frontDot, boolean isPriorityTarget) {
         this.entity = entity;
         this.distance = distance;
         this.frontDot = frontDot;
         this.isPriorityTarget = isPriorityTarget;
      }
   }
}
