package com.merlin204.tde.entity.enemy.e1.e1_5;

import com.merlin204.tde.entity.ai.SmartChaseGoal;
import com.merlin204.tde.entity.ai.TDEAnimatedAttackGoal;
import com.merlin204.tde.entity.ai.WonderGoal;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.entity.enemy.e1.e1_5.E1_5Animations;
import com.merlin204.tde.entity.enemy.e1.e1_5.ai.E1_5CombatBehaviors;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;

public class E1_5Patch extends EnemyPatch {

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, E1_5Animations.IDLE);
      animator.addLivingAnimation(LivingMotions.WALK, E1_5Animations.WALK);
      animator.addLivingAnimation(TDELivingMotions.TDE_BLOCK, E1_5Animations.BLOCK);
      animator.addLivingAnimation(TDELivingMotions.WONDER_R, E1_5Animations.WONDER_R);
      animator.addLivingAnimation(TDELivingMotions.WONDER_L, E1_5Animations.WONDER_R);
      animator.addLivingAnimation(LivingMotions.DEATH, E1_5Animations.HIT_M);
   }

   protected void initAI() {
      super.initAI();
      ((EnemyEntity)this.original).f_21345_.m_25352_(0, new TDEAnimatedAttackGoal(this, E1_5CombatBehaviors.TYPE1.build(this)));
      ((EnemyEntity)this.original).f_21345_.m_25352_(1, new WonderGoal(this, 3.0F, false));
      ((EnemyEntity)this.original).f_21345_.m_25352_(2, new SmartChaseGoal(this, 3.1F, 0.30000001192092896D));
   }

   public void updateMotion(boolean considerInaction) {
      super.updateMotion(considerInaction);
   }

   public AssetAccessor getTDEhitAnimation(TDEDamageSource damageSource) {
      AtkDirection atkDirection = damageSource.getAtkDirection();
      if(((EnemyEntity)this.original).isKnockdown()) {
         return null;
      } else {
         switch(null.$SwitchMap$com$merlin204$tde$world$AtkDirection[atkDirection.ordinal()]) {
         case 1:
            return E1_5Animations.HIT_L;
         case 2:
            return E1_5Animations.HIT_R;
         case 3:
            return E1_5Animations.HIT_M;
         default:
            return E1_5Animations.HIT_M;
         }
      }
   }

   public AnimationAccessor getKnockdownAnimation() {
      return E1_5Animations.KNOCKDOWN;
   }

   public AnimationAccessor getKnockFlyAnimation() {
      return E1_5Animations.KNOCKFLY;
   }

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      if(((EnemyEntity)this.original).getHitTick() > 0) {
         float ratio = (float)((EnemyEntity)this.original).getHitTick() / 20.0F;
         TDEAnimationUtils.joinRotationInPose(pose, this, "body", -20.0F * ratio, 0.0F, 0.0F);
         TDEAnimationUtils.joinRotationInPose(pose, this, "head", 10.0F * ratio, 0.0F, 0.0F);
      }

   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.WHOOSH.get();
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
   }

   public HitParticleType getWeaponHitParticle(InteractionHand hand) {
      return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
   }
}
