package com.merlin204.tde.entity.enemy.e1.e1_1;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.entity.TDEEntities;
import com.merlin204.tde.entity.ai.TargetSelector;
import com.merlin204.tde.entity.enemy.e1.SREntity;
import com.merlin204.tde.entity.vfx.soulfire.SoulFireEntity;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.util.TDEAnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class E1_1Entity extends SREntity {

   public E1_1Entity(EntityType pEntityType, Level pLevel) {
      super(pEntityType, pLevel);
      this.setEnergyrecoverspeed(0.5F);
   }

   public void m_8119_() {
      super.m_8119_();
      if(this.isFire()) {
         this.setEnergyrecoverspeed(1.0F);
         if(this.m_9236_().f_46443_) {
            FX fx = FXHelper.getFX(new ResourceLocation("photon:soulfire/soulfire_2"));
            if(fx == null) {
               return;
            }

            (new JointEffect(fx, this.m_9236_(), this, this.getArmature().searchJointByName("axe_R"), new Vec3f(0.0F, 0.0F, 0.0F), 4, false, true)).start();
            (new JointEffect(fx, this.m_9236_(), this, this.getArmature().searchJointByName("axe_L"), new Vec3f(0.0F, 0.0F, 0.0F), 4, false, true)).start();
         }
      }

   }

   public Vec3 getLockPos() {
      Vec3 pos = TDEAnimationUtils.getJointWorldPos(this.getEnemyPatch(), this.getArmature().searchJointByName("chest"));
      return pos;
   }

   protected void m_8099_() {
      super.m_8099_();
      this.f_21346_.m_25352_(0, new TargetSelector(this, 360.0F, 35.0D));
      this.f_21345_.m_25352_(0, new FloatGoal(this));
   }

   public int getDefendLevel() {
      EntityState entityState = this.getEnemyPatch().getEntityState();
      return entityState.attacking()?4 + this.getDefendLevelAdd():(entityState.inaction()?3 + this.getDefendLevelAdd():2 + this.getDefendLevelAdd());
   }

   public Armature getArmature() {
      // $FF: Couldn't be decompiled
   }

   public AssetAccessor getMesh() {
      // $FF: Couldn't be decompiled
   }

   public ResourceLocation getTexture() {
      return ResourceLocation.fromNamespaceAndPath("tde", "textures/entity/enemy/e1_1.png");
   }

   public static AttributeSupplier getDefaultAttribute() {
      return Animal.m_21552_().m_22268_(Attributes.f_22276_, 200.0D).m_22268_(Attributes.f_22278_, 500.0D).m_22268_(Attributes.f_22281_, 12.0D).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0D).m_22265_();
   }

   protected void m_8097_() {
      super.m_8097_();
      this.m_20088_().m_135372_(ENERGY, Float.valueOf(125.0F));
      this.m_20088_().m_135372_(MAX_ENERGY, Float.valueOf(125.0F));
      this.m_20088_().m_135372_(ENERGYRECOVER, Boolean.valueOf(true));
   }

   public void m_6667_(DamageSource pDamageSource) {
      Level soulFireEntity = this.m_9236_();
      if(soulFireEntity instanceof ServerLevel) {
         ServerLevel serverLevel = (ServerLevel)soulFireEntity;
         SoulFireEntity soulFireEntity1 = new SoulFireEntity((EntityType)TDEEntities.SOUL_FIRE.get(), serverLevel, "photon:soulfire/soulfire_2", Float.valueOf(2000.0F));
         soulFireEntity1.m_146884_(this.getLockPos());
         serverLevel.m_7967_(soulFireEntity1);
      }

      super.m_6667_(pDamageSource);
   }

   @Nullable
   protected SoundEvent m_7975_(DamageSource pDamageSource) {
      return SoundEvents.f_12008_;
   }

   protected SoundEvent m_5592_() {
      return SoundEvents.f_12059_;
   }

   protected void m_7355_(BlockPos pPos, BlockState pState) {
      this.m_5496_(SoundEvents.f_12010_, 1.0F, 1.0F);
   }

   public float getEnergyRenderSpeed() {
      return 1.0F;
   }

   public float getHealthRenderSpeed() {
      return 2.5F;
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$getMesh$0(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }
}
