package com.merlin204.tde.entity.enemy;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.item.weapon.TDEWeaponItem;
import com.merlin204.tde.item.weapon.TDEWeaponItemProperties;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class EnemyPatch extends MobPatch {

   public float getRootYRot() {
      JointTransform transform = this.getAnimator().getPose(1.0F).get("Root");
      if(transform == null) {
         return 0.0F;
      } else {
         float x = -transform.rotation().x;
         float y = -transform.rotation().y;
         float z = -transform.rotation().z;
         float w = transform.rotation().w;
         float yaw = (float)Math.atan2((double)(2.0F * (w * y - z * x)), (double)(w * w - x * x - y * y + z * z));
         yaw = (float)Math.toDegrees((double)yaw);
         float sinP = 2.0F * (w * y - z * x);
         sinP = Math.max(-1.0F, Math.min(1.0F, sinP));
         float pitchY = (float)Math.asin((double)sinP);
         float rollX1 = (float)Math.atan2((double)(2.0F * (w * x + y * z)), (double)(1.0F - 2.0F * (x * x + y * y)));
         float yawZ1 = (float)Math.atan2((double)(2.0F * (w * z + x * y)), (double)(1.0F - 2.0F * (y * y + z * z)));
         float rollX = (float)Math.toDegrees((double)rollX1);
         pitchY = (float)Math.toDegrees((double)pitchY);
         float yawZ = (float)Math.toDegrees((double)yawZ1);
         return yaw;
      }
   }

   public void onConstructed(EnemyEntity entity) {
      this.original = entity;
      this.armature = entity.getArmature();
      Animator animator = EpicFightSharedConstants.getAnimator(this);
      this.animator = animator;
      this.initAnimator(animator);
      animator.postInit();
   }

   public void updateMotion(boolean considerInaction) {
      if(((Mob)this.original).m_21223_() <= 0.0F) {
         this.currentLivingMotion = LivingMotions.DEATH;
      } else if(((EnemyEntity)this.getOriginal()).isGuarding() && !this.getEntityState().inaction()) {
         this.currentLivingMotion = TDELivingMotions.TDE_BLOCK;
      } else if(this.state.inaction() && considerInaction) {
         this.currentLivingMotion = LivingMotions.IDLE;
      } else if(((Mob)this.original).m_20184_().f_82480_ >= -0.550000011920929D && !this.isAirborneState()) {
         if(((Mob)this.original).f_267362_.m_267731_() > 0.01F) {
            if(((EnemyEntity)this.original).isWonder()) {
               if(((EnemyEntity)this.original).getWonderClockwise()) {
                  this.currentLivingMotion = TDELivingMotions.WONDER_L;
               } else {
                  this.currentLivingMotion = TDELivingMotions.WONDER_R;
               }
            } else {
               this.currentLivingMotion = LivingMotions.WALK;
            }
         } else {
            this.currentLivingMotion = LivingMotions.IDLE;
         }
      } else {
         this.currentLivingMotion = LivingMotions.IDLE;
      }

      this.currentCompositeMotion = this.currentLivingMotion;
   }

   public boolean applyStun(StunType stunType, float stunTime) {
      return false;
   }

   public AssetAccessor getTDEhitAnimation(TDEDamageSource damageSource) {
      if(((EnemyEntity)this.original).isKnockdown()) {
         return null;
      } else {
         AtkDirection atkDirection = damageSource.getAtkDirection();
         switch(null.$SwitchMap$com$merlin204$tde$world$AtkDirection[atkDirection.ordinal()]) {
         case 1:
            return null;
         case 2:
            return null;
         case 3:
            return null;
         default:
            return null;
         }
      }
   }

   public void playHitAnimation(TDEDamageSource tdeDamageSource) {
      if(tdeDamageSource.getImpactLevel() > ((EnemyEntity)this.original).getDefendLevel() && this.getTDEhitAnimation(tdeDamageSource) != null) {
         this.playAnimationSynchronized(this.getTDEhitAnimation(tdeDamageSource), 0.1F);
      } else if(((EnemyEntity)this.original).getHitTick() <= 10) {
         ((EnemyEntity)this.original).setHitTick(20);
      }

   }

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      super.poseTick(animation, pose, elapsedTime, partialTicks);
   }

   public AssetAccessor getHitAnimation(StunType stunType) {
      return null;
   }

   public TDEWeaponItemProperties getTDETDEWeaponItemProperties(InteractionHand hand) {
      Item item = ((EnemyEntity)this.original).m_21120_(hand).m_41720_();
      if(item instanceof TDEWeaponItem) {
         TDEWeaponItem tdeWeaponItem = (TDEWeaponItem)item;
         return tdeWeaponItem.getProperties();
      } else {
         return null;
      }
   }

   public OpenMatrix4f getModelMatrix(float partialTicks) {
      return MathUtils.getModelMatrixIntegral(0.0F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F, ((EnemyEntity)this.original).f_19860_, ((EnemyEntity)this.original).m_146909_(), ((EnemyEntity)this.getOriginal()).getCorrectYRot(partialTicks), ((EnemyEntity)this.getOriginal()).getCorrectYRot(partialTicks), partialTicks, 1.0F, 1.0F, 1.0F).scale(1.0F, 1.0F, 1.0F);
   }

   public AnimationAccessor getKnockdownAnimation() {
      return null;
   }

   public AnimationAccessor getKnockFlyAnimation() {
      return null;
   }

   public void tick(LivingTickEvent event) {
      super.tick(event);
      if(((EnemyEntity)this.original).getHitTick() > 0) {
         ((EnemyEntity)this.original).setHitTick(((EnemyEntity)this.original).getHitTick() - 1);
      }

   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand).getHitSound();
   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return this.getTDETDEWeaponItemProperties(hand).getSwingSound();
   }
}
