package com.merlin204.tde.entity.enemy;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.entity.TDEMeshEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import com.merlin204.tde.entity.player.TDEServerPlayerPatch;
import com.merlin204.tde.photon.PosEffect;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Entity.RemovalReason;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSetAttackTarget;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class EnemyEntity extends PathfinderMob implements TDEMeshEntity {

   protected static final EntityDataAccessor ENERGY = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135029_);
   protected static final EntityDataAccessor MAX_ENERGY = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135029_);
   protected static final EntityDataAccessor ENERGYRECOVERSPEED = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135029_);
   protected static EntityDataAccessor Y_ROT_BEFORE_ROTATION = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135029_);
   protected static final EntityDataAccessor STOP_RECOVER_TICK = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor WONDER_TICK = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor GUARD_TICK = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor KNOCKDOWN_TICK = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor HIT_TICK = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor DEFEND_LEVEL_ADD = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135028_);
   protected static final EntityDataAccessor ENERGYRECOVER = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor IS_KNOCKDOWN = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor IS_WONDER = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor WONDER_ClOCKWISE = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor IS_GUARD = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor IS_DODGE = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   protected static final EntityDataAccessor ROTATING = SynchedEntityData.m_135353_(EnemyEntity.class, EntityDataSerializers.f_135035_);
   private float renderHealth = this.m_21223_();
   private float renderEnergy = this.getEnergy();


   protected EnemyEntity(EntityType pEntityType, Level pLevel) {
      super(pEntityType, pLevel);
   }

   public void onAddedToWorld() {
      super.onAddedToWorld();
   }

   protected void m_8097_() {
      super.m_8097_();
      this.m_20088_().m_135372_(STOP_RECOVER_TICK, Integer.valueOf(0));
      this.m_20088_().m_135372_(WONDER_TICK, Integer.valueOf(0));
      this.m_20088_().m_135372_(GUARD_TICK, Integer.valueOf(0));
      this.m_20088_().m_135372_(KNOCKDOWN_TICK, Integer.valueOf(0));
      this.m_20088_().m_135372_(HIT_TICK, Integer.valueOf(0));
      this.m_20088_().m_135372_(DEFEND_LEVEL_ADD, Integer.valueOf(0));
      this.m_20088_().m_135372_(ENERGYRECOVERSPEED, Float.valueOf(0.8F));
      this.m_20088_().m_135372_(IS_DODGE, Boolean.valueOf(false));
      this.m_20088_().m_135372_(IS_GUARD, Boolean.valueOf(false));
      this.m_20088_().m_135372_(IS_WONDER, Boolean.valueOf(false));
      this.m_20088_().m_135372_(WONDER_ClOCKWISE, Boolean.valueOf(false));
      this.m_20088_().m_135372_(ROTATING, Boolean.valueOf(false));
      this.m_20088_().m_135372_(IS_KNOCKDOWN, Boolean.valueOf(false));
      this.m_20088_().m_135372_(Y_ROT_BEFORE_ROTATION, Float.valueOf(0.0F));
   }

   public void m_142687_(RemovalReason pReason) {
      System.out.println(pReason);
      super.m_142687_(pReason);
   }

   public void m_7380_(CompoundTag tag) {
      super.m_7380_(tag);
      tag.m_128350_("Energy", ((Float)this.f_19804_.m_135370_(ENERGY)).floatValue());
      tag.m_128350_("MaxEnergy", ((Float)this.f_19804_.m_135370_(MAX_ENERGY)).floatValue());
      tag.m_128350_("EnergyRecoverSpeed", ((Float)this.f_19804_.m_135370_(ENERGYRECOVERSPEED)).floatValue());
      tag.m_128350_("YRotBeforeRotation", ((Float)this.f_19804_.m_135370_(Y_ROT_BEFORE_ROTATION)).floatValue());
      tag.m_128405_("StopRecoverTick", ((Integer)this.f_19804_.m_135370_(STOP_RECOVER_TICK)).intValue());
      tag.m_128405_("WonderTick", ((Integer)this.f_19804_.m_135370_(WONDER_TICK)).intValue());
      tag.m_128405_("GuardTick", ((Integer)this.f_19804_.m_135370_(GUARD_TICK)).intValue());
      tag.m_128405_("KnockdownTick", ((Integer)this.f_19804_.m_135370_(KNOCKDOWN_TICK)).intValue());
      tag.m_128405_("DefendLevel", ((Integer)this.f_19804_.m_135370_(DEFEND_LEVEL_ADD)).intValue());
      tag.m_128379_("EnergyRecover", ((Boolean)this.f_19804_.m_135370_(ENERGYRECOVER)).booleanValue());
      tag.m_128379_("IsKnockdown", ((Boolean)this.f_19804_.m_135370_(IS_KNOCKDOWN)).booleanValue());
      tag.m_128379_("IsWonder", ((Boolean)this.f_19804_.m_135370_(IS_WONDER)).booleanValue());
      tag.m_128379_("IsGuard", ((Boolean)this.f_19804_.m_135370_(IS_GUARD)).booleanValue());
      tag.m_128379_("IsDodge", ((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue());
      tag.m_128379_("Rotating", ((Boolean)this.f_19804_.m_135370_(ROTATING)).booleanValue());
   }

   public void m_7378_(CompoundTag tag) {
      super.m_7378_(tag);
      if(tag.m_128441_("Energy")) {
         this.f_19804_.m_135381_(ENERGY, Float.valueOf(tag.m_128457_("Energy")));
      }

      if(tag.m_128441_("MaxEnergy")) {
         this.f_19804_.m_135381_(MAX_ENERGY, Float.valueOf(tag.m_128457_("MaxEnergy")));
      }

      if(tag.m_128441_("EnergyRecoverSpeed")) {
         this.f_19804_.m_135381_(ENERGYRECOVERSPEED, Float.valueOf(tag.m_128457_("EnergyRecoverSpeed")));
      }

      if(tag.m_128441_("YRotBeforeRotation")) {
         this.f_19804_.m_135381_(Y_ROT_BEFORE_ROTATION, Float.valueOf(tag.m_128457_("YRotBeforeRotation")));
      }

      if(tag.m_128441_("StopRecoverTick")) {
         this.f_19804_.m_135381_(STOP_RECOVER_TICK, Integer.valueOf(tag.m_128451_("StopRecoverTick")));
      }

      if(tag.m_128441_("WonderTick")) {
         this.f_19804_.m_135381_(WONDER_TICK, Integer.valueOf(tag.m_128451_("WonderTick")));
      }

      if(tag.m_128441_("GuardTick")) {
         this.f_19804_.m_135381_(GUARD_TICK, Integer.valueOf(tag.m_128451_("GuardTick")));
      }

      if(tag.m_128441_("KnockdownTick")) {
         this.f_19804_.m_135381_(KNOCKDOWN_TICK, Integer.valueOf(tag.m_128451_("KnockdownTick")));
      }

      if(tag.m_128441_("DefendLevel")) {
         this.f_19804_.m_135381_(DEFEND_LEVEL_ADD, Integer.valueOf(tag.m_128451_("DefendLevel")));
      }

      if(tag.m_128441_("EnergyRecover")) {
         this.f_19804_.m_135381_(ENERGYRECOVER, Boolean.valueOf(tag.m_128471_("EnergyRecover")));
      }

      if(tag.m_128441_("IsKnockdown")) {
         this.f_19804_.m_135381_(IS_KNOCKDOWN, Boolean.valueOf(tag.m_128471_("IsKnockdown")));
      }

      if(tag.m_128441_("IsWonder")) {
         this.f_19804_.m_135381_(IS_WONDER, Boolean.valueOf(tag.m_128471_("IsWonder")));
      }

      if(tag.m_128441_("IsGuard")) {
         this.f_19804_.m_135381_(IS_GUARD, Boolean.valueOf(tag.m_128471_("IsGuard")));
      }

      if(tag.m_128441_("IsDodge")) {
         this.f_19804_.m_135381_(IS_DODGE, Boolean.valueOf(tag.m_128471_("IsDodge")));
      }

      if(tag.m_128441_("Rotating")) {
         this.f_19804_.m_135381_(ROTATING, Boolean.valueOf(tag.m_128471_("Rotating")));
      }

   }

   public void updateYRotBeforeRotation() {
      if(!this.m_9236_().f_46443_) {
         this.m_20088_().m_135381_(Y_ROT_BEFORE_ROTATION, Float.valueOf(this.m_146908_()));
      }

   }

   public boolean m_6785_(double pDistanceToClosestPlayer) {
      return false;
   }

   public Vec3 getLockPos() {
      return null;
   }

   public EnemyPatch getEnemyPatch() {
      return (EnemyPatch)EpicFightCapabilities.getEntityPatch(this, EnemyPatch.class);
   }

   public float getCorrectYRot(float partialTick) {
      EnemyPatch enemyPatch = (EnemyPatch)EpicFightCapabilities.getEntityPatch(this, EnemyPatch.class);
      return this.isRotaing()?((Float)this.m_20088_().m_135370_(Y_ROT_BEFORE_ROTATION)).floatValue():this.m_5675_(partialTick);
   }

   public void atkEvent(Entity from, Entity to) {
   }

   public int getHitTick() {
      return ((Integer)this.f_19804_.m_135370_(HIT_TICK)).intValue();
   }

   public void setHitTick(int hitTick) {
      this.f_19804_.m_135381_(HIT_TICK, Integer.valueOf(hitTick));
   }

   public int getDefendLevel() {
      return ((Integer)this.f_19804_.m_135370_(DEFEND_LEVEL_ADD)).intValue();
   }

   public int getDefendLevelAdd() {
      return ((Integer)this.f_19804_.m_135370_(DEFEND_LEVEL_ADD)).intValue();
   }

   public void setDefendLevelAdd(int defendLevel) {
      this.f_19804_.m_135381_(DEFEND_LEVEL_ADD, Integer.valueOf(defendLevel));
   }

   public void setIsWonder(boolean isWonder) {
      this.f_19804_.m_135381_(IS_WONDER, Boolean.valueOf(isWonder));
   }

   public void setIsGuard(boolean isGuard) {
      this.f_19804_.m_135381_(IS_GUARD, Boolean.valueOf(isGuard));
   }

   public void setWonderClockwise(boolean Clockwise) {
      this.f_19804_.m_135381_(WONDER_ClOCKWISE, Boolean.valueOf(Clockwise));
   }

   public void setIsKnockdown(boolean isKnockdown) {
      this.f_19804_.m_135381_(IS_KNOCKDOWN, Boolean.valueOf(isKnockdown));
   }

   public void addEnergy(float add) {
      this.f_19804_.m_135381_(ENERGY, Float.valueOf(Math.min(this.getEnergy() + add, this.getMaxEnergy())));
   }

   public void costEnergy(float cost) {
      this.f_19804_.m_135381_(ENERGY, Float.valueOf(Math.max(this.getEnergy() - cost, 0.0F)));
   }

   public void setEnergy(float newEnergy) {
      this.f_19804_.m_135381_(ENERGY, Float.valueOf(newEnergy));
   }

   public float getMaxEnergy() {
      return ((Float)this.f_19804_.m_135370_(MAX_ENERGY)).floatValue();
   }

   public float getEnergy() {
      return ((Float)this.f_19804_.m_135370_(ENERGY)).floatValue();
   }

   public float getEnergyRecoverSpeed() {
      return ((Float)this.f_19804_.m_135370_(ENERGYRECOVERSPEED)).floatValue();
   }

   public void setEnergyrecoverspeed(float speed) {
      this.f_19804_.m_135381_(ENERGYRECOVERSPEED, Float.valueOf(speed));
   }

   public boolean getWonderClockwise() {
      return ((Boolean)this.f_19804_.m_135370_(WONDER_ClOCKWISE)).booleanValue();
   }

   public boolean isWonder() {
      return ((Boolean)this.f_19804_.m_135370_(IS_WONDER)).booleanValue();
   }

   public boolean isGuarding() {
      return ((Boolean)this.f_19804_.m_135370_(IS_GUARD)).booleanValue();
   }

   public boolean isKnockdown() {
      return ((Boolean)this.f_19804_.m_135370_(IS_KNOCKDOWN)).booleanValue();
   }

   public boolean isDodge() {
      return ((Boolean)this.f_19804_.m_135370_(IS_DODGE)).booleanValue();
   }

   public void setWonderTick(int tick) {
      this.f_19804_.m_135381_(WONDER_TICK, Integer.valueOf(Math.max(tick, 0)));
   }

   public int getWonderTick() {
      return ((Integer)this.f_19804_.m_135370_(WONDER_TICK)).intValue();
   }

   public void setGuardTick(int tick) {
      this.f_19804_.m_135381_(GUARD_TICK, Integer.valueOf(Math.max(tick, 0)));
   }

   public int getGuardTick() {
      return ((Integer)this.f_19804_.m_135370_(GUARD_TICK)).intValue();
   }

   public void setKnockdownTick(int tick) {
      this.f_19804_.m_135381_(KNOCKDOWN_TICK, Integer.valueOf(Math.max(tick, 0)));
   }

   public int getKnockdownTick() {
      return ((Integer)this.f_19804_.m_135370_(KNOCKDOWN_TICK)).intValue();
   }

   public void setStopEnergyRecoverTick(int tick) {
      this.f_19804_.m_135381_(STOP_RECOVER_TICK, Integer.valueOf(Math.max(tick, 0)));
   }

   public int getStopEnergyRecoverTick() {
      return ((Integer)this.f_19804_.m_135370_(STOP_RECOVER_TICK)).intValue();
   }

   public boolean canEnergyRecover() {
      return ((Boolean)this.f_19804_.m_135370_(ENERGYRECOVER)).booleanValue();
   }

   public float getRenderHealth() {
      return this.renderHealth;
   }

   public float getRenderEnergy() {
      return this.renderEnergy;
   }

   public float getHealthRenderSpeed() {
      return 1.0F;
   }

   public float getEnergyRenderSpeed() {
      return 0.5F;
   }

   public void m_8119_() {
      super.m_8119_();
      if(this.renderHealth > this.m_21223_()) {
         this.renderHealth -= this.getHealthRenderSpeed();
         if(this.renderHealth < this.m_21223_()) {
            this.renderHealth = this.m_21223_();
         }
      } else if(this.renderHealth < this.m_21223_()) {
         this.renderHealth += this.getHealthRenderSpeed();
         if(this.renderHealth > this.m_21223_()) {
            this.renderHealth = this.m_21223_();
         }
      }

      if(this.renderEnergy > this.getEnergy()) {
         this.renderEnergy -= this.getEnergyRenderSpeed();
         if(this.renderEnergy < this.getEnergy()) {
            this.renderEnergy = this.getEnergy();
         }
      } else if(this.renderEnergy < this.getEnergy()) {
         this.renderEnergy += this.getEnergyRenderSpeed();
         if(this.renderEnergy > this.getEnergy()) {
            this.renderEnergy = this.getEnergy();
         }
      }

      if(this.getEnergy() < this.getMaxEnergy() && this.getStopEnergyRecoverTick() <= 0 && !this.isDodge() && this.canEnergyRecover()) {
         this.addEnergy(this.getEnergyRecoverSpeed());
      } else if(this.getStopEnergyRecoverTick() > 0) {
         this.setStopEnergyRecoverTick(this.getStopEnergyRecoverTick() - 1);
         if(this.getStopEnergyRecoverTick() - 1 == 0) {
            this.setDefendLevelAdd(0);
         }
      }

      if(this.getKnockdownTick() > 0) {
         this.setIsKnockdown(true);
         this.setKnockdownTick(this.getKnockdownTick() - 1);
      } else if(this.getKnockdownTick() == 0 && this.isKnockdown()) {
         this.addEnergy(9999.0F);
         this.setIsKnockdown(false);
      }

      if(this.getGuardTick() > 0) {
         this.setIsGuard(true);
         this.setGuardTick(this.getGuardTick() - 1);
      } else if(this.getGuardTick() == 0 && this.isGuarding()) {
         this.setIsGuard(false);
      }

      if(this.getWonderTick() > 0) {
         this.setIsWonder(true);
         this.setWonderTick(this.getWonderTick() - 1);
      } else if(this.getWonderTick() == 0 && this.isWonder()) {
         this.setIsWonder(false);
      }

      if(this.getEnergy() <= 0.0F && !this.isKnockdown()) {
         this.setWonderTick(0);
         this.setGuardTick(0);
         this.setIsKnockdown(true);
         this.getEnemyPatch().playAnimationSynchronized(this.getEnemyPatch().getKnockdownAnimation(), 0.0F);
      }

   }

   public void m_6710_(@Nullable LivingEntity pTarget) {
      if(!this.m_9236_().m_5776_()) {
         super.m_6710_(pTarget);
         EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPSetAttackTarget(this.m_19879_(), pTarget != null?pTarget.m_19879_():-1), this);
      } else {
         super.m_6710_(pTarget);
      }

   }

   public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
      this.f_20916_ = 0;
      this.setDefendLevelAdd(this.getDefendLevelAdd() + 1);
      Entity tdeServerPlayerPatch = pSource.m_7639_();
      if(tdeServerPlayerPatch instanceof Player) {
         Player player = (Player)tdeServerPlayerPatch;
         if(this.getEnemyPatch().getTarget() == null) {
            this.m_6710_(player);
         }

         TDEServerPlayerPatch tdeServerPlayerPatch1 = (TDEServerPlayerPatch)EpicFightCapabilities.getEntityPatch(player, TDEServerPlayerPatch.class);
         if(tdeServerPlayerPatch1 != null) {
            if(this.getEnergy() <= 0.0F) {
               this.setStopEnergyRecoverTick(60);
               return super.m_6469_(pSource, 1.25F * pAmount);
            } else if(this.isDodge()) {
               return super.m_6469_(pSource, 0.0F);
            } else if(this.isGuarding() && !this.getEnemyPatch().getEntityState().inaction()) {
               this.spark(this.getEnemyPatch(), "photon:spark", 5);
               this.getEnemyPatch().playSound((SoundEvent)EpicFightSounds.CLASH.get(), 0.0F, 1.0F);
               tdeServerPlayerPatch1.energyDamageAtk(this.getEnemyPatch(), pAmount * 3.0F);
               this.setStopEnergyRecoverTick(60);
               return super.m_6469_(pSource, 0.0F);
            } else {
               tdeServerPlayerPatch1.energyDamageAtk(this.getEnemyPatch(), pAmount * 1.5F);
               this.setStopEnergyRecoverTick(60);
               return super.m_6469_(pSource, pAmount);
            }
         } else {
            return super.m_6469_(pSource, pAmount);
         }
      } else if(this.getEnergy() <= 0.0F) {
         this.setStopEnergyRecoverTick(60);
         return super.m_6469_(pSource, 1.25F * pAmount);
      } else if(this.isDodge()) {
         return super.m_6469_(pSource, 0.0F);
      } else if(this.isGuarding() && !this.getEnemyPatch().getEntityState().inaction()) {
         this.getEnemyPatch().playSound((SoundEvent)EpicFightSounds.CLASH.get(), 0.0F, 1.0F);
         this.spark(this.getEnemyPatch(), "photon:spark", 5);
         this.setStopEnergyRecoverTick(60);
         return super.m_6469_(pSource, 0.0F);
      } else {
         this.setStopEnergyRecoverTick(60);
         return super.m_6469_(pSource, pAmount);
      }
   }

   private void spark(LivingEntityPatch entityPatch, String Fx, int maxAge) {
      LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
      Vec3 pos = entity.m_146892_();
      float yaw = entityPatch.getYRot();
      double radians = Math.toRadians((double)yaw);
      double cosYaw = Math.cos(radians);
      double sinYaw = Math.sin(radians);
      Vec3 viewDir = (new Vec3(-sinYaw, 0.0D, cosYaw)).m_82490_(1.0D);
      Vec3 target = pos.m_82520_(viewDir.f_82479_, viewDir.f_82480_ - 0.699999988079071D, viewDir.f_82481_);
      FX fx = FXHelper.getFX(new ResourceLocation(Fx));
      fx.createRuntime(true);
      (new PosEffect(fx, entity.m_9236_(), entity, target, maxAge, false)).start();
   }

   public boolean m_6094_() {
      return false;
   }

   protected void m_7324_(Entity entity) {
      if(entity instanceof Player) {
         Vec3 pushDirection = entity.m_20182_().m_82546_(this.m_20182_()).m_82541_();
         double pushStrength = 0.1D;
         entity.m_20256_(entity.m_20184_().m_82549_(pushDirection.m_82490_(pushStrength)));
      }

   }

   public float getStepHeight() {
      return 1.1F;
   }

   public float getEnergyDamageCostModifier() {
      return 0.25F;
   }

   public boolean isRotaing() {
      return ((Boolean)this.f_19804_.m_135370_(ROTATING)).booleanValue();
   }

   public void setRotating(boolean b) {
      this.f_19804_.m_135381_(ROTATING, Boolean.valueOf(b));
   }

}
