package com.merlin204.tde.entity.client.renderer;

import com.google.gson.JsonElement;
import com.merlin204.tde.entity.player.TDELocalPlayerPatch;
import com.merlin204.tde.epicfight.gameassets.skill.sect.basic.BasicSect;
import com.merlin204.tde.epicfight.skill.TDESkillSlots;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class RenderMeshItem extends RenderItemBase {

   private final ResourceLocation texture;
   private final AssetAccessor mesh_main;
   private final AssetAccessor mesh_off;
   private final AssetAccessor mesh_main_b;
   private final AssetAccessor mesh_off_b;


   public RenderMeshItem(JsonElement param1) {
      // $FF: Couldn't be decompiled
   }

   public void renderItemInHand(ItemStack stack, LivingEntityPatch entitypatch, InteractionHand hand, OpenMatrix4f[] poses, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
      SkinnedMesh renderMesh = null;
      if(hand == InteractionHand.MAIN_HAND) {
         renderMesh = (SkinnedMesh)this.mesh_main.get();
      } else if(hand == InteractionHand.OFF_HAND) {
         renderMesh = (SkinnedMesh)this.mesh_off.get();
      }

      if(entitypatch instanceof TDELocalPlayerPatch) {
         TDELocalPlayerPatch armature = (TDELocalPlayerPatch)entitypatch;
         SkillContainer skillContainer = armature.getSkill(TDESkillSlots.SECT);
         Skill var13 = skillContainer.getSkill();
         if(var13 instanceof BasicSect) {
            BasicSect basicSect = (BasicSect)var13;
            if(!basicSect.checkAllowed((Player)armature.getOriginal())) {
               if(hand == InteractionHand.MAIN_HAND) {
                  renderMesh = (SkinnedMesh)this.mesh_main_b.get();
               } else if(hand == InteractionHand.OFF_HAND) {
                  renderMesh = (SkinnedMesh)this.mesh_off_b.get();
               }
            }

            if(hand == InteractionHand.MAIN_HAND && armature.mainBackTick > 0) {
               renderMesh = (SkinnedMesh)this.mesh_main_b.get();
            } else if(hand == InteractionHand.OFF_HAND && armature.offBackTick > 0) {
               renderMesh = (SkinnedMesh)this.mesh_off_b.get();
            }
         }
      }

      Armature armature1 = entitypatch.getArmature();
      poseStack.m_85836_();
      if(renderMesh != null) {
         renderMesh.draw(poseStack, buffer, RenderType.m_110473_(this.texture), packedLight, 1.0F, 1.0F, 1.0F, 1.0F, OverlayTexture.f_118083_, entitypatch.getArmature(), armature1.getPoseMatrices());
      }

      poseStack.m_85849_();
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$new$3(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$new$2(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$new$1(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$new$0(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }
}
