package com.merlin204.tde.entity.client.renderer;

import com.merlin204.tde.entity.client.model.EmptyEntityModel;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider.Context;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EmptyRenderer extends LivingEntityRenderer {

   public EmptyRenderer(Context pContext, EntityModel pModel, float pShadowRadius) {
      super(pContext, pModel, pShadowRadius);
   }

   public EmptyRenderer(Context pContext) {
      super(pContext, new EmptyEntityModel(), 0.0F);
   }

   public boolean m_5523_(Entity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
      return pLivingEntity.f_19797_ > 3;
   }

   public ResourceLocation m_5478_(Entity entity) {
      if(entity instanceof EnemyEntity) {
         EnemyEntity enemyEntity = (EnemyEntity)entity;
         return enemyEntity.getTexture();
      } else {
         return ResourceLocation.fromNamespaceAndPath("tde", "textures/entity/enemy/e1_1.png");
      }
   }

   protected boolean m_6512_(Entity entity) {
      return false;
   }
}
