package com.merlin204.tde.entity.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider.Context;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(Dist.CLIENT)
public class EmptyHumanoidMobRenderer extends HumanoidMobRenderer {

   private final ResourceLocation TEXTURE;


   public EmptyHumanoidMobRenderer(Context context, ResourceLocation texture) {
      super(context, new HumanoidModel(context.m_174023_(ModelLayers.f_171162_)), 0.5F);
      this.m_115326_(new HumanoidArmorLayer(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
      this.TEXTURE = texture;
   }

   public EmptyHumanoidMobRenderer(Context context) {
      super(context, new HumanoidModel(context.m_174023_(ModelLayers.f_171162_)), 0.5F);
      this.m_115326_(new HumanoidArmorLayer(this, new HumanoidModel(context.m_174023_(ModelLayers.f_171164_)), new HumanoidModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
      this.TEXTURE = ResourceLocation.parse("");
   }

   public boolean m_5523_(@NotNull Mob pLivingEntity, @NotNull Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
      return pLivingEntity.f_19797_ > 5;
   }

   public void m_7392_(@NotNull Mob pEntity, float pEntityYaw, float pPartialTicks, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
      this.f_114477_ = 0.0F;
      super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
   }

   @NotNull
   public ResourceLocation getTextureLocation(@NotNull Mob Entity) {
      return this.TEXTURE;
   }
}
