package com.merlin204.tde.entity.boss.b2;

import com.merlin204.tde.entity.ai.SmartChaseGoal;
import com.merlin204.tde.entity.ai.TDEAnimatedAttackGoal;
import com.merlin204.tde.entity.boss.BossPatch;
import com.merlin204.tde.entity.boss.b2.B2Animations;
import com.merlin204.tde.entity.boss.b2.ai.B2CombatBehaviors;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;

public class B2Patch extends BossPatch {

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, B2Animations.IDLE);
      animator.addLivingAnimation(LivingMotions.WALK, B2Animations.WALK);
      animator.addLivingAnimation(LivingMotions.DEATH, B2Animations.HIT_M);
   }

   protected void initAI() {
      super.initAI();
      ((EnemyEntity)this.original).f_21345_.m_25352_(0, new TDEAnimatedAttackGoal(this, B2CombatBehaviors.TYPE1.build(this)));
      ((EnemyEntity)this.original).f_21345_.m_25352_(1, new SmartChaseGoal(this, 2.0F, 0.30000001192092896D));
   }

   public void tick(LivingTickEvent event) {
      super.tick(event);
   }

   public AssetAccessor getTDEhitAnimation(TDEDamageSource damageSource) {
      AtkDirection atkDirection = damageSource.getAtkDirection();
      if(((EnemyEntity)this.original).isKnockdown()) {
         return null;
      } else {
         switch(null.$SwitchMap$com$merlin204$tde$world$AtkDirection[atkDirection.ordinal()]) {
         case 1:
            return B2Animations.HIT_L;
         case 2:
            return B2Animations.HIT_R;
         case 3:
            return B2Animations.HIT_M;
         default:
            return B2Animations.HIT_M;
         }
      }
   }

   public AnimationAccessor getKnockdownAnimation() {
      return B2Animations.KNOCKDOWN;
   }

   public AnimationAccessor getKnockFlyAnimation() {
      return B2Animations.KNOCKFLY;
   }

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      if(((EnemyEntity)this.original).getHitTick() > 0) {
         float ratio = (float)((EnemyEntity)this.original).getHitTick() / 20.0F;
         TDEAnimationUtils.joinRotationInPose(pose, this, "body", 10.0F * ratio, 0.0F, -10.0F * ratio);
         TDEAnimationUtils.joinRotationInPose(pose, this, "head", -10.0F * ratio, 0.0F, 10.0F * ratio);
      }

   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.WHOOSH.get();
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
   }

   public HitParticleType getWeaponHitParticle(InteractionHand hand) {
      return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
   }
}
