package com.merlin204.tde.entity.boss.B1;

import com.merlin204.tde.entity.client.renderer.EntityRendererPatch;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider.Context;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class B1RenderPatch extends EntityRendererPatch {

   public B1RenderPatch(Context context, EntityType entityType) {
      super(context, entityType);
   }

   public void render(LivingEntity entity, LivingEntityPatch entitypatch, LivingEntityRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
      Minecraft mc = Minecraft.m_91087_();
      if(entity instanceof EnemyEntity) {
         EnemyEntity enemyEntity = (EnemyEntity)entity;
         Armature armature = entitypatch.getArmature();
         SkinnedMesh mesh = (SkinnedMesh)enemyEntity.getMesh().get();
         ResourceLocation texture = enemyEntity.getTexture();
         RenderType renderType = RenderType.m_110473_(texture);
         poseStack.m_85836_();
         this.mulPoseStack(poseStack, armature, entity, entitypatch, partialTicks);
         this.setArmaturePose(entitypatch, armature, partialTicks);
         mesh.draw(poseStack, buffer, renderType, packedLight, 1.0F, 1.0F, 1.0F, 1.0F, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
         mesh.draw(poseStack, buffer, RenderType.m_234338_(ResourceLocation.fromNamespaceAndPath("tde", "textures/entity/boss/b1_l.png")), packedLight, 1.0F, 1.0F, 1.0F, 0.6F, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
         this.renderLayer(renderer, entitypatch, entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
         if(Minecraft.m_91087_().m_91290_().m_114377_()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
         }

         poseStack.m_85849_();
      }

   }
}
