package com.merlin204.tde.entity.boss.B1;

import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXHelper;
import com.merlin204.tde.entity.ai.TDEAnimatedAttackGoal;
import com.merlin204.tde.entity.ai.WonderGoal;
import com.merlin204.tde.entity.boss.BossPatch;
import com.merlin204.tde.entity.boss.B1.B1Animations;
import com.merlin204.tde.entity.boss.B1.ai.B1CombatBehaviors;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.epicfight.api.animation.TDELivingMotions;
import com.merlin204.tde.photon.JointEffect;
import com.merlin204.tde.util.TDEAnimationUtils;
import com.merlin204.tde.world.AtkDirection;
import com.merlin204.tde.world.TDEDamageSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.event.entity.living.LivingEvent.LivingTickEvent;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;

public class B1Patch extends BossPatch {

   protected void initAnimator(Animator animator) {
      super.initAnimator(animator);
      animator.addLivingAnimation(LivingMotions.IDLE, B1Animations.B1_IDLE);
      animator.addLivingAnimation(LivingMotions.WALK, B1Animations.B1_IDLE);
      animator.addLivingAnimation(LivingMotions.DEATH, B1Animations.B1_HIT_M);
      animator.addLivingAnimation(TDELivingMotions.WONDER_R, B1Animations.B1_WONDER_R);
   }

   protected void initAI() {
      super.initAI();
      ((EnemyEntity)this.original).f_21345_.m_25352_(0, new TDEAnimatedAttackGoal(this, B1CombatBehaviors.TYPE1.build(this)));
      ((EnemyEntity)this.original).f_21345_.m_25352_(1, new WonderGoal(this, 60.0F, false));
   }

   public void tick(LivingTickEvent event) {
      super.tick(event);
      boolean upPos = true;
      if(!this.getEntityState().canBasicAttack()) {
         upPos = false;
      }

      if(((EnemyEntity)this.original).m_9236_().f_46443_) {
         FX fx = FXHelper.getFX(new ResourceLocation("photon:b1/b1_soulfire"));
         if(fx == null) {
            return;
         }

         (new JointEffect(fx, ((EnemyEntity)this.original).m_9236_(), this.original, this.getArmature().searchJointByName("chest"), new Vec3f(0.0D, 0.1D, -0.15D), 3, upPos, true)).start();
      }

   }

   public AssetAccessor getTDEhitAnimation(TDEDamageSource damageSource) {
      AtkDirection atkDirection = damageSource.getAtkDirection();
      if(((EnemyEntity)this.original).isKnockdown()) {
         return null;
      } else {
         switch(null.$SwitchMap$com$merlin204$tde$world$AtkDirection[atkDirection.ordinal()]) {
         case 1:
            return B1Animations.B1_HIT_L;
         case 2:
            return B1Animations.B1_HIT_R;
         case 3:
            return B1Animations.B1_HIT_M;
         default:
            return B1Animations.B1_HIT_M;
         }
      }
   }

   public AnimationAccessor getKnockdownAnimation() {
      return B1Animations.B1_KNOCKDOWN;
   }

   public AnimationAccessor getKnockFlyAnimation() {
      return B1Animations.B1_KNOCKFLY;
   }

   public void poseTick(DynamicAnimation animation, Pose pose, float elapsedTime, float partialTicks) {
      if(((EnemyEntity)this.original).getHitTick() > 0) {
         float ratio = (float)((EnemyEntity)this.original).getHitTick() / 20.0F;
         TDEAnimationUtils.joinRotationInPose(pose, this, "body", 10.0F * ratio, 0.0F, -10.0F * ratio);
         TDEAnimationUtils.joinRotationInPose(pose, this, "head", -10.0F * ratio, 0.0F, 10.0F * ratio);
      }

   }

   public SoundEvent getSwingSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.WHOOSH_BIG.get();
   }

   public SoundEvent getWeaponHitSound(InteractionHand hand) {
      return (SoundEvent)EpicFightSounds.BLADE_HIT.get();
   }

   public HitParticleType getWeaponHitParticle(InteractionHand hand) {
      return (HitParticleType)EpicFightParticles.HIT_BLADE.get();
   }
}
