package com.merlin204.tde.entity.boss.B1;

import com.merlin204.tde.entity.TDEEntities;
import com.merlin204.tde.entity.ai.TargetSelector;
import com.merlin204.tde.entity.boss.BossEntity;
import com.merlin204.tde.entity.vfx.soulfire.BossSoulFireEntity;
import com.merlin204.tde.util.TDEAnimationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Entity.RemovalReason;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class B1Entity extends BossEntity {

   public B1Entity(EntityType pEntityType, Level pLevel) {
      super(pEntityType, pLevel);
   }

   protected void m_8099_() {
      super.m_8099_();
      this.f_21346_.m_25352_(2, new TargetSelector(this, 360.0F, 60.0D));
   }

   public void m_8119_() {
      super.m_8119_();
   }

   public void m_6667_(DamageSource pDamageSource) {
      super.m_6667_(pDamageSource);
   }

   public int getDefendLevel() {
      EntityState entityState = this.getEnemyPatch().getEntityState();
      return entityState.attacking()?5 + this.getDefendLevelAdd():(entityState.inaction()?4 + this.getDefendLevelAdd():3 + this.getDefendLevelAdd());
   }

   public Vec3 getLockPos() {
      return TDEAnimationUtils.getJointWorldPos(this.getEnemyPatch(), this.getArmature().searchJointByName("chest"));
   }

   public Armature getArmature() {
      // $FF: Couldn't be decompiled
   }

   public AssetAccessor getMesh() {
      // $FF: Couldn't be decompiled
   }

   public ResourceLocation getTexture() {
      return ResourceLocation.fromNamespaceAndPath("tde", "textures/entity/boss/b1.png");
   }

   public static AttributeSupplier getDefaultAttribute() {
      return Animal.m_21552_().m_22268_(Attributes.f_22276_, 600.0D).m_22268_(Attributes.f_22278_, 500.0D).m_22268_(Attributes.f_22281_, 12.0D).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 10.0D).m_22265_();
   }

   public void m_142687_(RemovalReason pReason) {
      if(pReason != RemovalReason.DISCARDED) {
         Level soulFireEntity = this.m_9236_();
         if(soulFireEntity instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)soulFireEntity;
            BossSoulFireEntity soulFireEntity1 = new BossSoulFireEntity((EntityType)TDEEntities.BOSS_SOUL_FIRE.get(), serverLevel, Float.valueOf(10000.0F), "tde:cs1_8");
            soulFireEntity1.m_146884_(this.getLockPos());
            serverLevel.m_7967_(soulFireEntity1);
         }
      }

      super.m_142687_(pReason);
   }

   protected void m_8097_() {
      super.m_8097_();
      this.m_20088_().m_135372_(ENERGY, Float.valueOf(250.0F));
      this.m_20088_().m_135372_(MAX_ENERGY, Float.valueOf(250.0F));
      this.m_20088_().m_135372_(ENERGYRECOVER, Boolean.valueOf(false));
   }

   @Nullable
   protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
      return SoundEvents.f_12381_;
   }

   protected SoundEvent m_5592_() {
      return SoundEvents.f_12424_;
   }

   protected void m_7355_(BlockPos pPos, BlockState pState) {
      this.m_5496_(SoundEvents.f_12383_, 1.0F, 1.0F);
   }

   public float getEnergyRenderSpeed() {
      return 1.0F;
   }

   public float getHealthRenderSpeed() {
      return 5.0F;
   }

   // $FF: synthetic method
   private static SkinnedMesh lambda$getMesh$0(JsonAssetLoader param0) {
      // $FF: Couldn't be decompiled
   }
}
