package com.merlin204.tde.entity.ai.condition;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.data.conditions.Condition;

public class TDETargetInGirdCondition implements Condition {

   private final List rectangles;


   public TDETargetInGirdCondition(int x, int z) {
      this.rectangles = Collections.singletonList(new TDETargetInGirdCondition.Rectangle(x, z, x, z));
   }

   public TDETargetInGirdCondition(TDETargetInGirdCondition.Rectangle ... rects) {
      this.rectangles = Arrays.asList(rects);
   }

   public boolean predicate(EnemyPatch enemyPatch) {
      Vec3 Pos = ((EnemyEntity)enemyPatch.getOriginal()).m_20182_();
      Level world = ((EnemyEntity)enemyPatch.getOriginal()).m_9236_();
      AABB searchArea = new AABB(Pos.f_82479_ - 30.0D, Pos.f_82480_ - 2.0D, Pos.f_82481_ - 30.0D, Pos.f_82479_ + 30.0D, Pos.f_82480_ + 2.0D, Pos.f_82481_ + 30.0D);
      List entities = world.m_6443_(LivingEntity.class, searchArea, enemyPatch);
      float yRot = ((EnemyEntity)enemyPatch.getOriginal()).m_146908_();
      double theta = Math.toRadians((double)yRot);
      double cos = Math.cos(theta);
      double sin = Math.sin(theta);
      ArrayList rects = new ArrayList(this.rectangles);
      Iterator var14 = entities.iterator();

      while(var14.hasNext()) {
         LivingEntity entity = (LivingEntity)var14.next();
         Vec3 entityPos = entity.m_20182_();
         double dx = entityPos.f_82479_ - Pos.f_82479_;
         double dz = entityPos.f_82481_ - Pos.f_82481_;
         double localX = dx * cos + dz * sin;
         double localZ = -dx * sin + dz * cos;
         if(Math.abs(localX) < 24.0D && Math.abs(localZ) < 24.0D) {
            int gridX = (int)Math.floor(localX + 0.5D);
            int gridZ = (int)Math.floor(localZ + 0.5D);
            Iterator var27 = rects.iterator();

            while(var27.hasNext()) {
               TDETargetInGirdCondition.Rectangle rect = (TDETargetInGirdCondition.Rectangle)var27.next();
               if(gridX >= rect.xMin && gridX <= rect.xMax && gridZ >= rect.zMin && gridZ <= rect.zMax && entity == enemyPatch.getTarget()) {
                  return true;
               }
            }
         }
      }

      return false;
   }

   private void drawAllRectangles(EnemyPatch enemyPatch) {
      Vec3 Pos = ((EnemyEntity)enemyPatch.getOriginal()).m_20182_();
      float yRot = ((EnemyEntity)enemyPatch.getOriginal()).m_146908_();
      LivingEntity livingEntity = (LivingEntity)enemyPatch.getOriginal();
      Iterator var5 = this.rectangles.iterator();

      while(var5.hasNext()) {
         TDETargetInGirdCondition.Rectangle rect = (TDETargetInGirdCondition.Rectangle)var5.next();
         double minX = (double)rect.xMin - 0.5D;
         double maxX = (double)rect.xMax + 0.5D;
         double minZ = (double)rect.zMin - 0.5D;
         double maxZ = (double)rect.zMax + 0.5D;
         this.drawLine(Pos, yRot, minX, minZ, maxX, minZ, livingEntity);
         this.drawLine(Pos, yRot, maxX, minZ, maxX, maxZ, livingEntity);
         this.drawLine(Pos, yRot, maxX, maxZ, minX, maxZ, livingEntity);
         this.drawLine(Pos, yRot, minX, maxZ, minX, minZ, livingEntity);
      }

   }

   private void drawLine(Vec3 Pos, float yRot, double x1, double z1, double x2, double z2, LivingEntity entity) {
      double step = 0.1D;
      double dx = x2 - x1;
      double dz = z2 - z1;
      double length = Math.sqrt(dx * dx + dz * dz);
      int steps = (int)(length / 0.1D);

      for(int i = 0; i <= steps; ++i) {
         double progress = (double)i / (double)steps;
         double localX = x1 + dx * progress;
         double localZ = z1 + dz * progress;
         Vec3 worldPos = this.localToWorld(new Vec3(localX, 0.0D, localZ), Pos, yRot);
         Level var30 = entity.m_9236_();
         if(var30 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)var30;
            serverLevel.m_8767_(ParticleTypes.f_123810_, worldPos.f_82479_, worldPos.f_82480_ + 0.5D, worldPos.f_82481_, 5, 0.0D, 0.0D, 0.0D, 0.0D);
         }
      }

   }

   private Vec3 localToWorld(Vec3 local, Vec3 origin, float yRot) {
      double radian = Math.toRadians((double)yRot);
      double cos = Math.cos(radian);
      double sin = Math.sin(radian);
      return new Vec3(origin.f_82479_ + local.f_82479_ * cos - local.f_82481_ * sin, origin.f_82480_, origin.f_82481_ + local.f_82479_ * sin + local.f_82481_ * cos);
   }

   public Condition read(CompoundTag compoundTag) throws IllegalArgumentException {
      return null;
   }

   public CompoundTag serializePredicate() {
      return null;
   }

   public List getAcceptingParameters(Screen screen) {
      return null;
   }

   // $FF: synthetic method
   private static boolean lambda$predicate$0(EnemyPatch enemyPatch, LivingEntity e) {
      return e.m_6084_() && e != enemyPatch.getOriginal();
   }

   public static class Rectangle {

      public final int xMin;
      public final int xMax;
      public final int zMin;
      public final int zMax;


      public Rectangle(int x1, int z1, int x2, int z2) {
         this.xMin = Math.min(x1, x2);
         this.xMax = Math.max(x1, x2);
         this.zMin = Math.min(z1, z2);
         this.zMax = Math.max(z1, z2);
      }
   }
}
