package com.merlin204.tde.entity.ai;

import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.utils.math.MathUtils;

public class WonderGoal extends Goal {

   private final EnemyPatch entityPatch;
   private final float dis;
   private final boolean isRandom;


   public WonderGoal(EnemyPatch entityPatch, float dis, boolean Random) {
      this.entityPatch = entityPatch;
      this.dis = dis;
      this.isRandom = Random;
   }

   public void m_8041_() {
      super.m_8041_();
   }

   public boolean m_8036_() {
      LivingEntity target = this.entityPatch.getTarget();
      return !this.entityPatch.getEntityState().inaction() && target != null && target.m_20270_(this.entityPatch.getOriginal()) <= this.dis && !((EnemyEntity)this.entityPatch.getOriginal()).isGuarding() && !((EnemyEntity)this.entityPatch.getOriginal()).isRotaing() && !((EnemyEntity)this.entityPatch.getOriginal()).isDodge() && !((EnemyEntity)this.entityPatch.getOriginal()).isKnockdown() && ((EnemyEntity)this.entityPatch.getOriginal()).isWonder();
   }

   public void m_8037_() {
      if(!this.entityPatch.getEntityState().inaction()) {
         LivingEntity target = this.entityPatch.getTarget();
         EnemyEntity entity = (EnemyEntity)this.entityPatch.getOriginal();
         Vec3 targetPos = target.m_20182_();
         Vec3 entityPos = entity.m_20182_();
         Vec3 toTarget = targetPos.m_82546_(entityPos).m_82541_();
         double targetYaw = MathUtils.getYRotOfVector(toTarget);
         float random = ((EnemyEntity)this.entityPatch.getOriginal()).m_9236_().f_46441_.m_188501_();
         if((double)random > 0.99D && this.isRandom) {
            entity.setWonderClockwise(!((EnemyEntity)this.entityPatch.getOriginal()).getWonderClockwise());
         }

         boolean clockwise = ((EnemyEntity)this.entityPatch.getOriginal()).getWonderClockwise();
         float currentYaw = entity.m_146908_();

         double deltaYaw;
         for(deltaYaw = targetYaw - (double)currentYaw; deltaYaw < -180.0D; deltaYaw += 360.0D) {
            ;
         }

         while(deltaYaw > 180.0D) {
            deltaYaw -= 360.0D;
         }

         float rotationStep = (float)(Math.signum(deltaYaw) * Math.min(3.0D, Math.abs(deltaYaw) * 0.30000001192092896D));
         if(Math.abs(deltaYaw) > 45.0D) {
            rotationStep = (float)(Math.signum(deltaYaw) * Math.min(10.0D, Math.abs(deltaYaw) * 3.0D));
         }

         entity.m_146922_(currentYaw + rotationStep);
         float moveSpeed = 0.03F;
         Vec3 tangent = (new Vec3(-toTarget.f_82481_, 0.0D, toTarget.f_82479_)).m_82541_();
         if(clockwise) {
            tangent = tangent.m_82490_(-1.0D);
         }

         Vec3 moveVec = tangent.m_82490_((double)moveSpeed).m_82520_(0.0D, (target.m_20186_() - entity.m_20186_()) * 0.02D, 0.0D);
         entity.m_6478_(MoverType.SELF, moveVec);
      }
   }
}
