package com.merlin204.tde.entity.ai;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal.Flag;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ClipContext.Block;
import net.minecraft.world.level.ClipContext.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.HitResult.Type;

public class TargetSelector extends TargetGoal {

   private static final int DEFAULT_RANDOM_INTERVAL = 10;
   protected final int randomInterval;
   @Nullable
   protected Player targetPlayer;
   protected TargetingConditions targetConditions;
   private final float lockAngle;
   private final double maxLockDistance;
   private boolean isLocked;


   public TargetSelector(Mob mob, float lockAngle, double maxLockDistance) {
      this(mob, lockAngle, maxLockDistance, 10, true);
   }

   public TargetSelector(Mob mob, float lockAngle, double maxLockDistance, int randomInterval, boolean mustSee) {
      super(mob, mustSee, false);
      this.isLocked = false;
      this.lockAngle = lockAngle;
      this.maxLockDistance = maxLockDistance;
      this.randomInterval = m_186073_(randomInterval);
      this.m_7021_(EnumSet.of(Flag.TARGET));
      this.targetConditions = TargetingConditions.m_148352_().m_26883_(maxLockDistance).m_26893_();
   }

   protected double m_7623_() {
      return this.maxLockDistance;
   }

   public boolean m_8036_() {
      if(this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
         return false;
      } else {
         this.targetPlayer = this.findSuitablePlayer();
         if(this.targetPlayer != null) {
            this.isLocked = true;
            return true;
         } else {
            return false;
         }
      }
   }

   @Nullable
   private Player findSuitablePlayer() {
      // $FF: Couldn't be decompiled
   }

   public void m_8056_() {
      if(this.targetPlayer != null) {
         this.f_26135_.m_6710_(this.targetPlayer);
      }

      super.m_8056_();
   }

   public boolean m_8045_() {
      if(this.isLocked && this.targetPlayer != null) {
         if(!this.targetPlayer.m_6084_()) {
            return false;
         } else {
            double distanceSq = this.f_26135_.m_20280_(this.targetPlayer);
            return distanceSq <= this.maxLockDistance * this.maxLockDistance;
         }
      } else {
         return super.m_8045_();
      }
   }

   public void m_8041_() {
      this.targetPlayer = null;
      this.isLocked = false;
      super.m_8041_();
   }

   // $FF: synthetic method
   private static double lambda$findSuitablePlayer$3(Vec3 eyePosition, Player player) {
      return eyePosition.m_82557_(player.m_20182_());
   }

   // $FF: synthetic method
   private boolean lambda$findSuitablePlayer$2(Vec3 eyePosition, Player player) {
      Vec3 playerEyePos = player.m_146892_();
      ClipContext context = new ClipContext(eyePosition, playerEyePos, Block.COLLIDER, Fluid.NONE, this.f_26135_);
      return this.f_26135_.m_9236_().m_45547_(context).m_6662_() == Type.MISS;
   }

   // $FF: synthetic method
   private boolean lambda$findSuitablePlayer$1(Vec3 eyePosition, Vec3 viewVector, Player player) {
      Vec3 toPlayer = player.m_146892_().m_82546_(eyePosition).m_82541_();
      double dot = viewVector.m_82526_(toPlayer);
      double requiredDot = Math.cos(Math.toRadians((double)(this.lockAngle / 2.0F)));
      return dot >= requiredDot;
   }

   // $FF: synthetic method
   private boolean lambda$findSuitablePlayer$0(Vec3 eyePosition, Player player) {
      double distanceSq = eyePosition.m_82557_(player.m_20182_());
      return distanceSq <= this.maxLockDistance * this.maxLockDistance;
   }
}
