package com.merlin204.tde.entity.ai;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.Mob;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.CustomCondition;
import yesman.epicfight.data.conditions.entity.HealthPoint;
import yesman.epicfight.data.conditions.entity.RandomChance;
import yesman.epicfight.data.conditions.entity.TargetInDistance;
import yesman.epicfight.data.conditions.entity.TargetInEyeHeight;
import yesman.epicfight.data.conditions.entity.TargetInPov;
import yesman.epicfight.data.conditions.entity.HealthPoint.Comparator;
import yesman.epicfight.data.conditions.entity.TargetInPov.TargetInPovHorizontal;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch.ServerAnimationPacketProvider;

public class TDECombatBehaviors {

   private final List behaviorSeriesList;
   private final MobPatch mobpatch;
   private int currentBehaviorPointer;


   protected TDECombatBehaviors(TDECombatBehaviors.Builder param1, MobPatch param2) {
      // $FF: Couldn't be decompiled
   }

   public void reset() {
      this.currentBehaviorPointer = -1;

      TDECombatBehaviors.BehaviorSeries series;
      for(Iterator var1 = this.behaviorSeriesList.iterator(); var1.hasNext(); series.loopFinished = false) {
         series = (TDECombatBehaviors.BehaviorSeries)var1.next();
         series.nextBehaviorPointer = 0;
      }

   }

   public TDECombatBehaviors.BehaviorSeries getCurrentBehaviorSeries() {
      return this.currentBehaviorPointer >= 0 && this.currentBehaviorPointer < this.behaviorSeriesList.size()?(TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(this.currentBehaviorPointer):null;
   }

   public void stopCurrentBehavior() {
      TDECombatBehaviors.BehaviorSeries currentSeries = this.getCurrentBehaviorSeries();
      if(currentSeries != null) {
         currentSeries.nextBehaviorPointer = 0;
         currentSeries.loopFinished = false;
      }

      this.currentBehaviorPointer = -1;
   }

   private int getRandomCombatBehaviorSeries() {
      IntArrayList candidates = new IntArrayList();
      FloatArrayList rescaledWeight = new FloatArrayList();
      float weightSum = 0.0F;

      for(int random = 0; random < this.behaviorSeriesList.size(); ++random) {
         if(this.currentBehaviorPointer != random) {
            TDECombatBehaviors.BehaviorSeries delta = (TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(random);
            if(delta.canBeSelected(this.mobpatch)) {
               weightSum += delta.weight;
               candidates.add(random);
            }
         }
      }

      IntListIterator var8 = candidates.iterator();

      while(var8.hasNext()) {
         int var10 = ((Integer)var8.next()).intValue();
         rescaledWeight.add(((TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(var10)).weight / weightSum);
      }

      float var9 = ((Mob)this.mobpatch.getOriginal()).m_217043_().m_188501_();
      float var11 = 0.0F;

      for(int i = 0; i < candidates.size(); ++i) {
         int index = candidates.getInt(i);
         var11 += rescaledWeight.getFloat(i);
         if(var9 < var11) {
            this.resetCooldown(index, true);
            return index;
         }
      }

      return -1;
   }

   public void execute(int seriesPointer) {
      this.currentBehaviorPointer = seriesPointer;
      TDECombatBehaviors.BehaviorSeries behaviorSeries = (TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(seriesPointer);
      TDECombatBehaviors.Behavior behavior = (TDECombatBehaviors.Behavior)behaviorSeries.behaviors.get(behaviorSeries.nextBehaviorPointer);
      behaviorSeries.count();
      behavior.execute(this.mobpatch);
   }

   public void resetCooldown(int seriesPointer, boolean resetSharingCooldown) {
      ((TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(seriesPointer)).resetCooldown(this, resetSharingCooldown);
   }

   public TDECombatBehaviors.Behavior selectRandomBehaviorSeries() {
      int seriesPointer = this.getRandomCombatBehaviorSeries();
      if(seriesPointer >= 0) {
         this.currentBehaviorPointer = seriesPointer;
         TDECombatBehaviors.BehaviorSeries behaviorSeries = (TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(seriesPointer);
         TDECombatBehaviors.Behavior behavior = (TDECombatBehaviors.Behavior)behaviorSeries.behaviors.get(behaviorSeries.nextBehaviorPointer);
         behaviorSeries.count();
         if(behaviorSeries.loopFinished && !behaviorSeries.looping) {
            behaviorSeries.loopFinished = false;
            this.currentBehaviorPointer = -1;
         }

         return behavior;
      } else {
         return null;
      }
   }

   public TDECombatBehaviors.Behavior tryProceed() {
      TDECombatBehaviors.BehaviorSeries currentBehaviorSeries = (TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(this.currentBehaviorPointer);
      if(currentBehaviorSeries.canBeInterrupted) {
         int nextBehavior = this.getRandomCombatBehaviorSeries();
         if(nextBehavior >= 0 && this.currentBehaviorPointer != nextBehavior) {
            this.currentBehaviorPointer = nextBehavior;
            TDECombatBehaviors.BehaviorSeries newCombatBehaviorSeries = (TDECombatBehaviors.BehaviorSeries)this.behaviorSeriesList.get(nextBehavior);
            return (TDECombatBehaviors.Behavior)newCombatBehaviorSeries.behaviors.get(newCombatBehaviorSeries.nextBehaviorPointer);
         }
      }

      if(currentBehaviorSeries.loopFinished && !currentBehaviorSeries.looping) {
         currentBehaviorSeries.loopFinished = false;
         this.currentBehaviorPointer = -1;
         return null;
      } else {
         TDECombatBehaviors.Behavior nextBehavior1 = (TDECombatBehaviors.Behavior)currentBehaviorSeries.behaviors.get(currentBehaviorSeries.nextBehaviorPointer);
         if(nextBehavior1.checkPredicates(this.mobpatch)) {
            currentBehaviorSeries.count();
            return nextBehavior1;
         } else {
            this.currentBehaviorPointer = -1;
            if(!currentBehaviorSeries.looping) {
               currentBehaviorSeries.nextBehaviorPointer = 0;
            }

            return null;
         }
      }
   }

   public boolean hasActivatedMove() {
      return this.currentBehaviorPointer >= 0;
   }

   public void tick() {
      if(!this.mobpatch.getEntityState().inaction()) {
         Iterator var1 = this.behaviorSeriesList.iterator();

         while(var1.hasNext()) {
            TDECombatBehaviors.BehaviorSeries behaviorSeries = (TDECombatBehaviors.BehaviorSeries)var1.next();
            behaviorSeries.tick();
         }

      }
   }

   public static TDECombatBehaviors.Builder builder() {
      return new TDECombatBehaviors.Builder();
   }

   public static class Builder {

      private final List behaviorSeriesList = Lists.newArrayList();


      public TDECombatBehaviors.Builder newBehaviorSeries(TDECombatBehaviors.BehaviorSeries.Builder builder) {
         this.behaviorSeriesList.add(builder);
         return this;
      }

      public TDECombatBehaviors build(MobPatch mobpatch) {
         return new TDECombatBehaviors(this, mobpatch);
      }
   }

   public static class BehaviorSeries {

      private final List behaviors;
      private final boolean looping;
      private final boolean canBeInterrupted;
      private final float weight;
      private final int maxCooldown;
      private final IntList cooldownShares;
      private boolean loopFinished;
      private int cooldown;
      private int nextBehaviorPointer;


      private BehaviorSeries(TDECombatBehaviors.BehaviorSeries.Builder param1) {
         // $FF: Couldn't be decompiled
      }

      public boolean canBeSelected(MobPatch mobpatch) {
         return this.cooldown > 0?false:((TDECombatBehaviors.Behavior)this.behaviors.get(this.nextBehaviorPointer)).checkPredicates(mobpatch);
      }

      public void count() {
         ++this.nextBehaviorPointer;
         this.loopFinished = false;
         int behaviorsNum = this.behaviors.size();
         if(this.nextBehaviorPointer >= behaviorsNum) {
            this.nextBehaviorPointer %= behaviorsNum;
            this.loopFinished = true;
         }

      }

      public void tick() {
         if(this.cooldown > 0) {
            --this.cooldown;
         }

      }

      public void resetCooldown(TDECombatBehaviors mobBehavior, boolean resetSharingCooldown) {
         this.cooldown = this.maxCooldown;
         TDECombatBehaviors.BehaviorSeries behaviorSeries;
         if(resetSharingCooldown) {
            for(IntListIterator var3 = this.cooldownShares.iterator(); var3.hasNext(); behaviorSeries.cooldown = behaviorSeries.maxCooldown) {
               int i = ((Integer)var3.next()).intValue();
               behaviorSeries = (TDECombatBehaviors.BehaviorSeries)mobBehavior.behaviorSeriesList.get(i);
            }
         }

      }

      public static TDECombatBehaviors.BehaviorSeries.Builder builder() {
         return new TDECombatBehaviors.BehaviorSeries.Builder();
      }

      public static class Builder {

         private final List behaviors = Lists.newArrayList();
         private boolean looping = false;
         private boolean canBeInterrupted = true;
         private float weight;
         private int cooldown;
         private final IntList cooldownSharingPointers = new IntArrayList();


         public TDECombatBehaviors.BehaviorSeries.Builder weight(float weight) {
            this.weight = weight;
            return this;
         }

         public TDECombatBehaviors.BehaviorSeries.Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
         }

         public TDECombatBehaviors.BehaviorSeries.Builder simultaneousCooldown(int ... cooldownSharingPointers) {
            int[] var2 = cooldownSharingPointers;
            int var3 = cooldownSharingPointers.length;

            for(int var4 = 0; var4 < var3; ++var4) {
               int pointer = var2[var4];
               this.cooldownSharingPointers.add(pointer);
            }

            return this;
         }

         public TDECombatBehaviors.BehaviorSeries.Builder nextBehavior(TDECombatBehaviors.Behavior.Builder motion) {
            this.behaviors.add(motion);
            return this;
         }

         public TDECombatBehaviors.BehaviorSeries.Builder looping(boolean looping) {
            this.looping = looping;
            return this;
         }

         public TDECombatBehaviors.BehaviorSeries.Builder canBeInterrupted(boolean canBeInterrupted) {
            this.canBeInterrupted = canBeInterrupted;
            return this;
         }

         public TDECombatBehaviors.BehaviorSeries build() {
            return new TDECombatBehaviors.BehaviorSeries(this);
         }
      }
   }

   public static class Behavior {

      private final Consumer behavior;
      private final List conditions;


      private Behavior(TDECombatBehaviors.Behavior.Builder builder) {
         this.behavior = builder.behavior;
         this.conditions = builder.conditions;
      }

      private boolean checkPredicates(MobPatch mobpatch) {
         Iterator var2 = this.conditions.iterator();

         Condition condition;
         do {
            if(!var2.hasNext()) {
               return true;
            }

            condition = (Condition)var2.next();
         } while(condition.predicate(mobpatch));

         return false;
      }

      public void execute(MobPatch mobpatch) {
         this.behavior.accept(mobpatch);
         mobpatch.updateEntityState();
      }

      public static TDECombatBehaviors.Behavior.Builder builder() {
         return new TDECombatBehaviors.Behavior.Builder();
      }

      public static class Builder {

         private Consumer behavior;
         private final List conditions;
         private ServerAnimationPacketProvider packetProvider;


         public Builder() {
            // $FF: Couldn't be decompiled
         }

         public TDECombatBehaviors.Behavior.Builder behavior(Consumer behavior) {
            this.behavior = behavior;
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder emptyBehavior() {
            // $FF: Couldn't be decompiled
         }

         public TDECombatBehaviors.Behavior.Builder animationBehavior(AnimationAccessor motion) {
            this.behavior = motion;
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder withinEyeHeight() {
            this.condition(new TargetInEyeHeight());
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder randomChance(float chance) {
            this.condition(new RandomChance(chance));
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder withinDistance(double minDistance, double maxDistance) {
            this.condition(new TargetInDistance(minDistance, maxDistance));
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder withinAngle(double minDegree, double maxDegree) {
            this.condition(new TargetInPov(minDegree, maxDegree));
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder withinAngleHorizontal(double minDegree, double maxDegree) {
            this.condition(new TargetInPovHorizontal(minDegree, maxDegree));
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder health(float health, Comparator comparator) {
            this.condition(new HealthPoint(health, comparator));
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder custom(Function customPredicate) {
            this.condition(new CustomCondition(customPredicate));
            return this;
         }

         public void condition(Condition predicate) {
            this.conditions.add(predicate);
         }

         public TDECombatBehaviors.Behavior.Builder predicate(Condition predicate) {
            this.conditions.add(predicate);
            return this;
         }

         public TDECombatBehaviors.Behavior.Builder packetProvider(ServerAnimationPacketProvider packetProvider) {
            this.packetProvider = packetProvider;
            return this;
         }

         public TDECombatBehaviors.Behavior build() {
            return new TDECombatBehaviors.Behavior(this);
         }

         // $FF: synthetic method
         private void lambda$animationBehavior$1(AnimationAccessor motion, MobPatch mobpatch) {
            mobpatch.playAnimationSynchronized(motion, 0.0F, this.packetProvider);
         }

         // $FF: synthetic method
         private static void lambda$emptyBehavior$0(MobPatch mobpatch) {
         }
      }
   }
}
