package com.merlin204.tde.entity.ai;

import com.merlin204.tde.entity.ai.TDECombatBehaviors;
import com.merlin204.tde.entity.enemy.EnemyEntity;
import com.merlin204.tde.entity.enemy.EnemyPatch;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class TDEAnimatedAttackGoal extends Goal {

   protected final MobPatch mobpatch;
   protected final TDECombatBehaviors combatBehaviors;
   private LivingEntity lastTarget;


   public TDEAnimatedAttackGoal(MobPatch mobpatch, TDECombatBehaviors combatBehaviors) {
      this.mobpatch = mobpatch;
      this.combatBehaviors = combatBehaviors;
      this.lastTarget = null;
   }

   public boolean m_8036_() {
      return true;
   }

   public void m_8056_() {
      this.lastTarget = this.mobpatch.getTarget();
   }

   public void m_8037_() {
      LivingEntity currentTarget = this.mobpatch.getTarget();
      if(currentTarget != this.lastTarget) {
         this.resetCombatState();
         this.lastTarget = currentTarget;
      }

      if(currentTarget != null) {
         EntityState state = this.mobpatch.getEntityState();
         this.combatBehaviors.tick();
         TDECombatBehaviors.Behavior result;
         if(this.combatBehaviors.hasActivatedMove()) {
            if(state.canBasicAttack()) {
               result = this.combatBehaviors.tryProceed();
               if(result != null) {
                  result.execute(this.mobpatch);
               }
            }
         } else if(!state.inaction()) {
            result = this.combatBehaviors.selectRandomBehaviorSeries();
            if(result != null) {
               result.execute(this.mobpatch);
            }
         }

      }
   }

   private void resetCombatState() {
      TDECombatBehaviors.BehaviorSeries currentSeries = this.combatBehaviors.getCurrentBehaviorSeries();
      this.combatBehaviors.stopCurrentBehavior();
   }

   protected boolean checkTargetValid() {
      MobPatch player = this.mobpatch;
      if(player instanceof EnemyPatch) {
         EnemyPatch livingentity = (EnemyPatch)player;
         if(((EnemyEntity)livingentity.getOriginal()).getStopEnergyRecoverTick() > 50) {
            return false;
         }
      }

      LivingEntity livingentity1 = this.mobpatch.getTarget();
      if(livingentity1 == null) {
         return false;
      } else if(!livingentity1.m_6084_()) {
         return false;
      } else {
         boolean var10000;
         if(livingentity1 instanceof Player) {
            Player player1 = (Player)livingentity1;
            if(player1.m_5833_() || player1.m_7500_()) {
               var10000 = false;
               return var10000;
            }
         }

         var10000 = true;
         return var10000;
      }
   }

   public void m_8041_() {
      this.lastTarget = null;
      this.resetCombatState();
   }
}
