package com.merlin204.tde.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(Dist.CLIENT)
public class TDEScaleEntityAfterImageParticle extends CustomModelParticle {

   public static final ResourceLocation WHITE = ResourceLocation.fromNamespaceAndPath("epicfight", "textures/particle/white.png");
   private final Pose pose;
   private final Matrix4f modelMatrix;
   private float alphaO;
   private final float scaleSpeed;
   private final Entity entity;
   private final LivingEntityPatch entityPatch;


   public TDEScaleEntityAfterImageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, AssetAccessor particleMesh, Pose pose, Matrix4f modelMatrix, Entity entity, LivingEntityPatch entityPatch) {
      super(level, x, y, z, xd, yd, zd, particleMesh);
      this.modelMatrix = modelMatrix;
      this.f_107225_ = (int)zd;
      this.f_107227_ = 1.0F;
      this.f_107228_ = 1.0F;
      this.f_107229_ = 1.0F;
      this.alphaO = 0.3F;
      this.f_107230_ = 0.3F;
      this.entity = entity;
      this.pose = pose;
      this.entityPatch = entityPatch;
      this.scaleSpeed = (float)yd;
   }

   public void m_5989_() {
      super.m_5989_();
      this.alphaO = this.f_107230_;
      this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 0.8F;
   }

   public void m_5744_(VertexConsumer param1, Camera param2, float param3) {
      // $FF: Couldn't be decompiled
   }

   protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
      Quaternionf rotation = new Quaternionf(0.0F, 0.0F, 0.0F, 1.0F);
      float roll = Mth.m_14179_(partialTicks, this.f_107204_, this.f_107231_);
      float pitch = Mth.m_14179_(partialTicks, this.pitchO, this.pitch);
      float yaw = Mth.m_14179_(partialTicks, this.yawO, this.yaw);
      rotation.mul(QuaternionUtils.YP.rotationDegrees(yaw));
      rotation.mul(QuaternionUtils.XP.rotationDegrees(pitch));
      rotation.mul(QuaternionUtils.ZP.rotationDegrees(roll));
      Vec3 vec3 = camera.m_90583_();
      float x = (float)(Mth.m_14139_((double)partialTicks, this.f_107209_, this.f_107212_) - vec3.m_7096_());
      float y = (float)(Mth.m_14139_((double)partialTicks, this.f_107210_, this.f_107213_) - vec3.m_7098_());
      float z = (float)(Mth.m_14139_((double)partialTicks, this.f_107211_, this.f_107214_) - vec3.m_7094_());
      float scale = (float)Mth.m_14139_((double)partialTicks, (double)this.scaleO, (double)this.scale);
      poseStack.m_252880_(x, y, z);
      poseStack.m_252781_(rotation);
      poseStack.m_85841_(scale, scale, scale);
   }

   public ParticleRenderType m_7556_() {
      return EpicFightParticleRenderTypes.PARTICLE_MODEL_NO_NORMAL;
   }

   public static double calculateUniformScalingFactor(int scalingSteps, double targetScaleFactor) {
      if(scalingSteps <= 0) {
         throw new IllegalArgumentException("缩放次数必须大于0");
      } else if(targetScaleFactor <= 0.0D) {
         throw new IllegalArgumentException("目标缩放倍数必须大于0");
      } else {
         return Math.pow(targetScaleFactor, 1.0D / (double)scalingSteps);
      }
   }


   @OnlyIn(Dist.CLIENT)
   public static class Provider implements ParticleProvider {

      public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
         Entity entity = level.m_6815_((int)Double.doubleToLongBits(xSpeed));
         LivingEntityPatch entityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
         if(entityPatch != null && ClientEngine.getInstance().renderEngine.hasRendererFor(entityPatch.getOriginal())) {
            PatchedEntityRenderer renderer = ClientEngine.getInstance().renderEngine.getEntityRenderer(entityPatch.getOriginal());
            Armature armature = entityPatch.getArmature();
            PoseStack poseStack = new PoseStack();
            renderer.mulPoseStack(poseStack, armature, (LivingEntity)entityPatch.getOriginal(), entityPatch, 1.0F);
            Pose pose = entityPatch.getAnimator().getPose(1.0F);
            renderer.setJointTransforms(entityPatch, armature, pose, 1.0F);
            AssetAccessor meshProvider = ClientEngine.getInstance().renderEngine.getEntityRenderer(entityPatch.getOriginal()).getMeshProvider(entityPatch);
            TDEScaleEntityAfterImageParticle particle = new TDEScaleEntityAfterImageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, meshProvider, pose, poseStack.m_85850_().m_252922_(), entity, entityPatch);
            return particle;
         } else {
            return null;
         }
      }
   }
}
