package com.merlin204.tde.client.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.MultiBufferSource.BufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.Mesh.DrawingFunction;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.QuaternionUtils;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.CustomModelParticle;
import yesman.epicfight.client.particle.EpicFightParticleRenderTypes;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.renderer.patched.entity.PatchedEntityRenderer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(Dist.CLIENT)
public class TDEEntityAfterImageParticle extends CustomModelParticle {

   public static final ResourceLocation WHITE = ResourceLocation.fromNamespaceAndPath("epicfight", "textures/particle/white.png");
   private final OpenMatrix4f[] poseMatrices;
   private final Matrix4f modelMatrix;
   private float alphaO;
   private Armature armature;
   private final Entity entity;


   public TDEEntityAfterImageParticle(ClientLevel level, double x, double y, double z, double xd, double yd, double zd, AssetAccessor particleMesh, OpenMatrix4f[] matrices, Matrix4f modelMatrix, Armature armature, Entity entity) {
      super(level, x, y, z, xd, yd, zd, particleMesh);
      this.poseMatrices = matrices;
      this.modelMatrix = modelMatrix;
      this.f_107225_ = 20;
      this.f_107227_ = 1.0F;
      this.f_107228_ = 1.0F;
      this.f_107229_ = 1.0F;
      this.alphaO = 0.3F;
      this.f_107230_ = 0.3F;
      this.armature = armature;
      this.entity = entity;
   }

   public void m_5989_() {
      super.m_5989_();
      this.alphaO = this.f_107230_;
      this.f_107230_ = (float)(this.f_107225_ - this.f_107224_) / (float)this.f_107225_ * 0.8F;
   }

   public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTicks) {
      PoseStack poseStack = new PoseStack();
      poseStack.m_252931_(RenderSystem.getModelViewMatrix());
      this.setupPoseStack(poseStack, camera, partialTicks);
      poseStack.m_252931_(this.modelMatrix);
      float alpha = this.alphaO + (this.f_107230_ - this.alphaO) * partialTicks;
      BufferSource bufferSources = Minecraft.m_91087_().m_91269_().m_110104_();
      RenderType renderType = RenderType.m_110473_(Minecraft.m_91087_().m_91290_().m_114382_(this.entity).m_5478_(this.entity));
      ((SkinnedMesh)this.particleMeshProvider.get()).drawPosed(poseStack, bufferSources.m_6299_(EpicFightRenderTypes.getTriangulated(renderType)), DrawingFunction.NEW_ENTITY, this.m_6355_(partialTicks), this.f_107227_, this.f_107228_, this.f_107229_, alpha, OverlayTexture.f_118083_, (Armature)null, this.poseMatrices);
   }

   protected void setupPoseStack(PoseStack poseStack, Camera camera, float partialTicks) {
      Quaternionf rotation = new Quaternionf(0.0F, 0.0F, 0.0F, 1.0F);
      float roll = Mth.m_14179_(partialTicks, this.f_107204_, this.f_107231_);
      float pitch = Mth.m_14179_(partialTicks, this.pitchO, this.pitch);
      float yaw = Mth.m_14179_(partialTicks, this.yawO, this.yaw);
      rotation.mul(QuaternionUtils.YP.rotationDegrees(yaw));
      rotation.mul(QuaternionUtils.XP.rotationDegrees(pitch));
      rotation.mul(QuaternionUtils.ZP.rotationDegrees(roll));
      Vec3 vec3 = camera.m_90583_();
      float x = (float)(Mth.m_14139_((double)partialTicks, this.f_107209_, this.f_107212_) - vec3.m_7096_());
      float y = (float)(Mth.m_14139_((double)partialTicks, this.f_107210_, this.f_107213_) - vec3.m_7098_());
      float z = (float)(Mth.m_14139_((double)partialTicks, this.f_107211_, this.f_107214_) - vec3.m_7094_());
      float scale = (float)Mth.m_14139_((double)partialTicks, (double)this.scaleO, (double)this.scale);
      poseStack.m_252880_(x, y, z);
      poseStack.m_252781_(rotation);
      poseStack.m_85841_(scale, scale, scale);
   }

   public ParticleRenderType m_7556_() {
      return EpicFightParticleRenderTypes.PARTICLE_MODEL_NO_NORMAL;
   }


   @OnlyIn(Dist.CLIENT)
   public static class Provider implements ParticleProvider {

      public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
         Entity entity = level.m_6815_((int)Double.doubleToLongBits(xSpeed));
         LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
         if(entitypatch != null && ClientEngine.getInstance().renderEngine.hasRendererFor(entitypatch.getOriginal())) {
            PatchedEntityRenderer renderer = ClientEngine.getInstance().renderEngine.getEntityRenderer(entitypatch.getOriginal());
            Armature armature = entitypatch.getArmature();
            PoseStack poseStack = new PoseStack();
            renderer.mulPoseStack(poseStack, armature, (LivingEntity)entitypatch.getOriginal(), entitypatch, 1.0F);
            Pose pose = entitypatch.getAnimator().getPose(1.0F);
            renderer.setJointTransforms(entitypatch, armature, pose, 1.0F);
            OpenMatrix4f[] matrices = armature.getPoseAsTransformMatrix(pose, true);
            AssetAccessor meshProvider = ClientEngine.getInstance().renderEngine.getEntityRenderer(entitypatch.getOriginal()).getMeshProvider(entitypatch);
            TDEEntityAfterImageParticle particle = new TDEEntityAfterImageParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, meshProvider, matrices, poseStack.m_85850_().m_252922_(), armature, entity);
            return particle;
         } else {
            return null;
         }
      }
   }
}
