package com.merlin204.tde.client.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.AnimationManager.AnimationAccessor;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.physics.bezier.CubicBezierCurve;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.AbstractTrailParticle;
import yesman.epicfight.client.particle.AbstractTrailParticle.TrailEdge;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(Dist.CLIENT)
public class TDEAnimationTrailParticle extends AbstractTrailParticle {

   protected final Joint joint;
   protected final AssetAccessor animation;
   protected final List invisibleTrailEdges;
   protected Pose lastPose;
   protected JointTransform lastTransform;


   protected TDEAnimationTrailParticle(ClientLevel level, LivingEntityPatch owner, Joint joint, AssetAccessor animation, TrailInfo trailInfo) {
      super(level, owner, trailInfo);
      this.joint = joint;
      this.animation = animation;
      this.invisibleTrailEdges = Lists.newLinkedList();
      Pose prevPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.0F);
      Pose middlePose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.5F);
      Pose currentPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(1.0F);
      Vec3 posOld = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(0.0F);
      Vec3 posMid = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(0.5F);
      Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(1.0F);
      this.lastPose = currentPose;
      this.lastPos = posCur;
      this.lastTransform = JointTransform.fromMatrix(((LivingEntityPatch)this.owner).getModelMatrix(1.0F));
      OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)posOld.f_82479_, (float)posOld.f_82480_, (float)posOld.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.0F));
      OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)posMid.f_82479_, (float)posMid.f_82480_, (float)posMid.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.5F));
      OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)posCur.f_82479_, (float)posCur.f_82480_, (float)posCur.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(1.0F));
      OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
      OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(middlePose, this.joint).mulFront(middleModelTf);
      OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(currentPose, this.joint).mulFront(curModelTf);
      Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, trailInfo.start());
      Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, trailInfo.end());
      Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, trailInfo.start());
      Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, trailInfo.end());
      Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, trailInfo.start());
      Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, trailInfo.end());
      this.invisibleTrailEdges.add(new TrailEdge(prevStartPos, prevEndPos, this.trailInfo.trailLifetime()));
      this.invisibleTrailEdges.add(new TrailEdge(middleStartPos, middleEndPos, this.trailInfo.trailLifetime()));
      this.invisibleTrailEdges.add(new TrailEdge(currentStartPos, currentEndPos, this.trailInfo.trailLifetime()));
      this.f_107227_ = Math.max(this.trailInfo.rCol(), 0.0F);
      this.f_107228_ = Math.max(this.trailInfo.gCol(), 0.0F);
      this.f_107229_ = Math.max(this.trailInfo.bCol(), 0.0F);
      if(this.trailInfo.texturePath() != null) {
         TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
         AbstractTexture abstracttexture = texturemanager.m_118506_(this.trailInfo.texturePath());
         RenderSystem.bindTexture(abstracttexture.m_117963_());
         RenderSystem.texParameter(3553, 10242, '脯');
         RenderSystem.texParameter(3553, 10243, '脯');
      }

   }

   protected boolean canContinue() {
      AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
      return ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_6084_() && this.animation == animPlayer.getRealAnimation() && animPlayer.getElapsedTime() <= this.trailInfo.endTime();
   }

   protected boolean canCreateNextCurve() {
      AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
      return TrailInfo.isValidTime(this.trailInfo.fadeTime()) && this.trailInfo.endTime() < animPlayer.getElapsedTime()?false:super.canCreateNextCurve();
   }

   protected void createNextCurve() {
      AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
      boolean isTrailInvisible = ((DynamicAnimation)animPlayer.getAnimation().get()).isLinkAnimation() || animPlayer.getElapsedTime() <= this.trailInfo.startTime();
      boolean isFirstTrail = this.trailEdges.isEmpty();
      boolean needCorrection = !isTrailInvisible && isFirstTrail;
      if(needCorrection) {
         float trailInfo = Math.max((this.trailInfo.startTime() - animPlayer.getPrevElapsedTime()) / (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()), 0.0F);
         this.startEdgeCorrection = (float)(this.trailInfo.interpolateCount() * 2) * trailInfo;
      }

      TrailInfo var35 = this.trailInfo;
      Pose prevPose = this.lastPose;
      Pose currentPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(1.0F);
      Pose middlePose = Pose.interpolatePose(prevPose, currentPose, 0.5F);
      Vec3 posOld = this.lastPos;
      Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(1.0F);
      Vec3 posMid = MathUtils.lerpVector(posOld, posCur, 0.5F);
      OpenMatrix4f prevModelMatrix = this.lastTransform.toMatrix();
      OpenMatrix4f curModelMatrix = ((LivingEntityPatch)this.owner).getModelMatrix(1.0F);
      JointTransform currentTransform = JointTransform.fromMatrix(curModelMatrix);
      OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)posOld.f_82479_, (float)posOld.f_82480_, (float)posOld.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(prevModelMatrix);
      OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)posMid.f_82479_, (float)posMid.f_82480_, (float)posMid.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(JointTransform.interpolate(this.lastTransform, currentTransform, 0.5F).toMatrix());
      OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)posCur.f_82479_, (float)posCur.f_82480_, (float)posCur.f_82481_).rotateDeg(180.0F, Vec3f.Y_AXIS).mulBack(curModelMatrix);
      OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
      OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(middlePose, this.joint).mulFront(middleModelTf);
      OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBindedTransformFor(currentPose, this.joint).mulFront(curModelTf);
      Vec3 prevStartPos = OpenMatrix4f.transform(prevJointTf, var35.start());
      Vec3 prevEndPos = OpenMatrix4f.transform(prevJointTf, var35.end());
      Vec3 middleStartPos = OpenMatrix4f.transform(middleJointTf, var35.start());
      Vec3 middleEndPos = OpenMatrix4f.transform(middleJointTf, var35.end());
      Vec3 currentStartPos = OpenMatrix4f.transform(currentJointTf, var35.start());
      Vec3 currentEndPos = OpenMatrix4f.transform(currentJointTf, var35.end());
      Object finalStartPositions;
      Object finalEndPositions;
      boolean visibleTrail;
      if(isTrailInvisible) {
         finalStartPositions = Lists.newArrayList();
         finalEndPositions = Lists.newArrayList();
         ((List)finalStartPositions).add(prevStartPos);
         ((List)finalStartPositions).add(middleStartPos);
         ((List)finalEndPositions).add(prevEndPos);
         ((List)finalEndPositions).add(middleEndPos);
         this.invisibleTrailEdges.clear();
         visibleTrail = false;
      } else {
         ArrayList startPosList = Lists.newArrayList();
         ArrayList endPosList = Lists.newArrayList();
         TrailEdge edge1;
         TrailEdge edge2;
         if(isFirstTrail) {
            int lastIdx = this.invisibleTrailEdges.size() - 1;
            edge1 = (TrailEdge)this.invisibleTrailEdges.get(lastIdx);
            edge2 = new TrailEdge(prevStartPos, prevEndPos, -1);
         } else {
            edge1 = (TrailEdge)this.trailEdges.get(this.trailEdges.size() - (this.trailInfo.interpolateCount() / 2 + 1));
            edge2 = (TrailEdge)this.trailEdges.get(this.trailEdges.size() - 1);
            ++edge2.lifetime;
         }

         startPosList.add(edge1.start);
         endPosList.add(edge1.end);
         startPosList.add(edge2.start);
         endPosList.add(edge2.end);
         startPosList.add(middleStartPos);
         endPosList.add(middleEndPos);
         startPosList.add(currentStartPos);
         endPosList.add(currentEndPos);
         finalStartPositions = CubicBezierCurve.getBezierInterpolatedPoints(startPosList, 1, 3, this.trailInfo.interpolateCount());
         finalEndPositions = CubicBezierCurve.getBezierInterpolatedPoints(endPosList, 1, 3, this.trailInfo.interpolateCount());
         if(!isFirstTrail) {
            ((List)finalStartPositions).remove(0);
            ((List)finalEndPositions).remove(0);
         }

         visibleTrail = true;
      }

      this.makeTrailEdges((List)finalStartPositions, (List)finalEndPositions, visibleTrail?this.trailEdges:this.invisibleTrailEdges);
      this.lastPos = posCur;
      this.lastPose = currentPose;
      this.lastTransform = currentTransform;
   }

   @OnlyIn(Dist.CLIENT)
   public static class Provider implements ParticleProvider {

      public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
         int eid = (int)Double.doubleToRawLongBits(x);
         int animid = (int)Double.doubleToRawLongBits(z);
         int jointId = (int)Double.doubleToRawLongBits(xSpeed);
         int idx = (int)Double.doubleToRawLongBits(ySpeed);
         Entity entity = level.m_6815_(eid);
         if(entity == null) {
            return null;
         } else {
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch(entity, LivingEntityPatch.class);
            if(entitypatch == null) {
               return null;
            } else {
               AnimationAccessor animation = AnimationManager.byId(animid);
               if(animation == null) {
                  return null;
               } else {
                  Optional trailInfo = ((StaticAnimation)animation.get()).getProperty(ClientAnimationProperties.TRAIL_EFFECT);
                  if(trailInfo.isEmpty()) {
                     return null;
                  } else {
                     TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
                     TrailInfo fInfo = TrailInfo.builder().time(result.startTime() / 60.0F, result.endTime() / 60.0F).create();
                     fInfo = result.overwrite(fInfo);
                     if(result.hand() != null) {
                        ItemStack stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand());
                        RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
                        if(renderItemBase != null && renderItemBase.trailInfo() != null) {
                           fInfo = renderItemBase.trailInfo().overwrite(fInfo);
                        }
                     }

                     return fInfo.playable()?new TDEAnimationTrailParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), animation, fInfo):null;
                  }
               }
            }
         }
      }
   }
}
